import java.awt.*;
import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * Write a description of class Monster here.
 * 
 * @author Florian
 * @version (a version number or a date)
 */
public class Monster extends Element
{
    public static boolean checkthethrow_bottle = false;

    private long lasthit = 0;
    private long lastBottleHit = 0;
    private long lastOffsetChange = 0;
    protected int live = 1;
    private static long buftime = 1000;

    protected int size = 30;        //Größe
    protected double step = 1.3;    //Geschwindigkeit
    protected int sichtweite = 200; //Abstand in dem der Zombie den Linch erkennt

    protected String[] picsoben = {"Skins/Zombie/up/zomby_up1.png", "Skins/Zombie/up/zomby_up2.png", "Skins/Zombie/up/zomby_up3.png", "Skins/Zombie/up/zomby_up4.png", "Skins/Zombie/up/zomby_up5.png", "Skins/Zombie/up/zomby_up6.png", "Skins/Zombie/up/zomby_up7.png", "Skins/Zombie/up/zomby_up8.png"};
    protected String[] picsunten = {"Skins/Zombie/down/zomby_down1.png", "Skins/Zombie/down/zomby_down2.png", "Skins/Zombie/down/zomby_down3.png", "Skins/Zombie/down/zomby_down4.png", "Skins/Zombie/down/zomby_down5.png", "Skins/Zombie/down/zomby_down6.png", "Skins/Zombie/down/zomby_down7.png", "Skins/Zombie/down/zomby_down8.png"};
    protected String[] picslinks = {"Skins/Zombie/left/zomby_left1.png", "Skins/Zombie/left/zomby_left2.png", "Skins/Zombie/left/zomby_left3.png", "Skins/Zombie/left/zomby_left4.png"};
    protected String[] picsrechts = {"Skins/Zombie/right/zomby_right1.png", "Skins/Zombie/right/zomby_right2.png", "Skins/Zombie/right/zomby_right3.png", "Skins/Zombie/right/zomby_right4.png"};

    private boolean right, left, up, down;
    private int offset;
    /**
     * Act - do whatever the Monster wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     * 
     * @author Florian, Jonathan
     */
    public void act() 
    {
        //GreenfootSound zombie = new GreenfootSound("zombie"+(Greenfoot.getRandomNumber(6)+1)+".mp3");
        if(!Welt.pause){
            if(getObjectsInRange(sichtweite, Linch.class).isEmpty()){//Linch ist weit weg, also zufällig bewegen
                if (Greenfoot.getRandomNumber(300) == 1)
                {
                    Greenfoot.playSound("zombie"+(Greenfoot.getRandomNumber(6)+1)+".mp3");
                }
                if((System.currentTimeMillis() - lastOffsetChange) >= Greenfoot.getRandomNumber(750) + 500){
                    do{
                        left    = Greenfoot.getRandomNumber(3) == 1;
                        right   = Greenfoot.getRandomNumber(3) == 1;
                        up      = Greenfoot.getRandomNumber(3) == 1;
                        down    = Greenfoot.getRandomNumber(3) == 1;
                    }while(left && right || up && down);

                    lastOffsetChange = System.currentTimeMillis();
                }
            }else{
                //Linch ist in Reichweite, auf ihn zu bewegen
                if (Greenfoot.getRandomNumber(200) == 1)
                {
                    Greenfoot.playSound("zombie"+(Greenfoot.getRandomNumber(6)+1)+".mp3");
                }
                left    = false;     
                right   = false;
                up      = false; 
                down    = false; 
                if((System.currentTimeMillis() - lastOffsetChange) >= Greenfoot.getRandomNumber(500) + 200){         //Damit Monster nicht gerade läuft
                    offset = Greenfoot.getRandomNumber(31)-15;
                    lastOffsetChange = System.currentTimeMillis();
                }
                if ((Linch.Xcoord-getX()-offset)>0)
                {
                    right = true;
                }
                else if ((Linch.Xcoord-getX()-offset)<0)
                {
                    left = true;
                }
                if ((Linch.Ycoord-getY()-offset)>0)
                {
                    down = true;
                }
                else if ((Linch.Ycoord-getY()-offset)<0)
                {
                    up = true;
                }
            }
            if(!setPictureAndMove()){
                lastOffsetChange = (System.currentTimeMillis() - 50000);
            }
            checkLinch();
            checkBottle();
            if (checkthethrow_bottle == true)
            {
                checkthrow_bottle();
                checkthethrow_bottle = false;
            }
        }
        else
        {
            //zombie.stop();
        }
    }

    private void checkBottle(){
        if((System.currentTimeMillis() - lastBottleHit) >= 1000){
            if(isTouching(Bottle.class)){
                if(live == 1){
                    getWorld().removeObject(this);
                    Greenfoot.playSound("zombiedie.mp3");
                }else{
                    live--;
                }
                lastBottleHit = System.currentTimeMillis();
            }
        }

    }

    public void livedown()
    {

        if(live == 1){
            getWorld().removeObject(this);
            Greenfoot.playSound("zombiedie.mp3");
        }else{
            live--;
        }

    }
    
    /**
     * 
     * @author Jonathan
     */
    private void checkthrow_bottle()
    {
        if (isTouching(throw_bottle.class)){
            if (live == 1){
                getWorld().removeObject(this);
                Greenfoot.playSound("zombiedie.mp3");
            }
            else{
                live--;
            }
            throw_bottle.monstertouched = true;
        }
    }

    /**
     * @author Florian
     */
    private void checkLinch(){
        if (System.currentTimeMillis()-lasthit >= buftime)
        {
            if(isTouching(Linch.class)){
                lasthit = (System.currentTimeMillis());
                Linch linch = (Linch)getOneTouching(Linch.class);
                linch.removeHeart();
                linch.move(-5);
                Greenfoot.playSound("zombiedie.mp3");
            }
        }
    }

    /**
     * @author Jonathan, Florian
     */
    private boolean setPictureAndMove()
    {
        double stepTmp;
        boolean returnVal = false;
        if (right == true && up == true)
        {
            setRotation(0);
            stepTmp = Math.sqrt(step*step/2);
            move(picsrechts,true,size,size);
            returnVal = setLocation(getX() + (int)stepTmp, getY() - (int)stepTmp, true);
            //Bild obenrechts
        }
        else if (right == true && down == true)
        {
            // setRotation(45);
            stepTmp = Math.sqrt(step*step/2);
            move(picsrechts,true,size,size);
            returnVal = setLocation(getX() + (int)stepTmp, getY() + (int)stepTmp, true);
            //Bild untenrechts
        }
        else if (right == true)
        {
            setRotation(0);
            stepTmp = step;
            move(picsrechts,true,size,size);
            returnVal = setLocation(getX() + (int)stepTmp, getY(), true);
            //Bild rechts
        }
        if (left == true && up == true)
        {
            setRotation(0);
            stepTmp = Math.sqrt(step*step/2);
            move(picslinks,true,size,size);
            returnVal = setLocation(getX() - (int)stepTmp, getY() - (int)stepTmp, true);
            //Bild obenLinchs
        }
        else if (left == true && down == true)
        {
            setRotation(0);
            stepTmp = Math.sqrt(step*step/2);
            move(picslinks,true,size,size);
            returnVal = setLocation(getX() - (int)stepTmp, getY() + (int)stepTmp, true);
            //Bild untenLinchs
        }
        else if (left == true)
        {
            setRotation(0);
            stepTmp = step;
            move(picslinks,true,size,size);
            returnVal = setLocation(getX() - (int)stepTmp, getY(), true);
            //Bild Linchs
        }
        if (up == true && left != true && right != true)
        {
            setRotation(0);
            stepTmp = step;
            move(picsoben,true,size,size);
            returnVal = setLocation(getX(), getY() - (int)stepTmp, true);
            //Bild oben
        }
        if (down == true && left != true && right != true)
        {
            setRotation(0);
            stepTmp = step;
            move(picsunten,true,size,size);
            returnVal = setLocation(getX(), getY() + (int)stepTmp, true);
            //Bild unten
        }
        return returnVal;
    }

    /**
     * Überschreibt setLocation und bewegt den Actor nur wenn die Maske es zulässt
     * und er nicht aus dem Bild läuft
     * 
     * @param x Neue-X-Koordinate
     * @param y Neue-Y-Koordinate
     * @param checkBeforeMoving Wenn TRUE wird Linch nur bewegt wenn er nicht aus dem Bild läuft und die Maske es zulässt
     * @author Florian
     * @return TRUE, wenn das Monster an die Stelle laufen darf
     */
    public boolean setLocation(int x, int y, boolean checkBeforeMoving){
        if(checkBeforeMoving){
            if(x >= 0 && y >= 0 && y < Welt.height && x < Welt.width){   
                if(!Background.mask.getColorAt(x, y).equals(Color.black)){  //Actor darf an die Stelle laufen
                    super.setLocation(x, y);
                    return true;
                }
            }else{
                return false;
            }
        }else{      //beim z.B: Scrollen soll nicht geprüft werden (Monster läuft aus dem Bild)
            super.setLocation(x, y);
        }
        return false;
    }

}

