import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)
import java.util.*;
/**
 * Write a description of class Moving here.
 * 
 * @author Jonathan, Florian
 * @version (a version number or a date)
 */
public class Moving extends Actor
{
    private long lastchange = 0;
    private int actualpic = 0;
    public static int animationspeed = 800; //je größer der Wert, desto lansamer die Animation
    /**
     * Act - do whatever the Moving wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        if(Welt.pause){
            return;
        }
    }   
    
    public void move(String[] p, boolean change, int sizex, int sizey)
    {
        if (change == true)
        {
            int count = 0;
            for (int index = 0; index < p.length; index++) 
            {
                if(p[index] != null)
                {
                    count++;
                }
            }
            
            if (System.currentTimeMillis()-lastchange >= (animationspeed/count))
            {
                GreenfootImage img = new GreenfootImage(p[(actualpic < p.length) ? actualpic : p.length-1]);
                img.scale(sizex, sizey);
                setImage(img);

                if (actualpic < (count-1))
                {
                    actualpic++;
                }
                else
                {
                    actualpic = 0;
                }
                
                
                lastchange = (System.currentTimeMillis());
            }  
           

        }
        else
        {
        }
        
        

    }
    
    
     /**
     * Prüft, ob das aktuelle Objekt sich mit dem angegebenen Objekt schneidet.
     * Prüft dabei jedes überschneidende Pixel auf Transparenz
     * 
     * @param obj Zu prüfendes Objekt
     * @author Florian Keck
     */
    protected boolean isTouching(Actor obj){
        GreenfootImage img = getImage();
        GreenfootImage img2 = obj.getImage();
        int dx = obj.getX() - (img2.getWidth() / 2) - (getX() - (img.getWidth() /2));       //Versatz in X-Richtung der Ecken der Bilder
        int dy = obj.getY() - (img2.getHeight() / 2) - (getY() - (img.getHeight() / 2));    //Versttz in Y-Richtung der Ecken der Bilder

        if(dx > img.getWidth() || dx < -img2.getWidth() || dy > img.getHeight() || dy < -img2.getHeight()){
            return false;
        }else{       
            if(dx >= 0){            //Objekt der angegebenen Klasse ist weiter rechts als this
                for(int x = dx; x < Math.min(img.getWidth(), img2.getWidth() + dx); x++){  
                    if(dy >= 0){    //Objekt der angegebenen Klasse ist weiter unten als this
                        for(int y = dy; y < Math.min(img.getHeight(), img2.getHeight()+ dy); y++){
                            if(img.getColorAt(x, y).getAlpha() != 0 && img2.getColorAt(x - dx, y - dy).getAlpha() != 0){
                                return true; 
                            }
                        }
                    }else{      //Objekt der angegebenen Klasse ist weiter oben als this
                        for(int y = 0; y < Math.min(img2.getHeight() + dy, img.getHeight()); y++){
                            if(img.getColorAt(x, y).getAlpha() != 0 && img2.getColorAt(x - dx, y - dy).getAlpha() != 0){
                                return true; 
                            }
                        }
                    }
                }
            }else{            //Objekt der angegebenen Klasse ist weiter links als this
                for(int x = 0; x < Math.min(img2.getWidth() + dx, img.getWidth()); x++){
                    if(dy >= 0){
                        for(int y = dy; y < Math.min(img.getHeight(), img2.getHeight() + dy); y++){
                            if(img.getColorAt(x, y).getAlpha() != 0 && img2.getColorAt(x - dx, y - dy).getAlpha() != 0){
                                return true;
                            }
                        }
                    }else{
                        for(int y = 0; y < Math.min(img2.getHeight() + dy, img.getHeight()); y++){
                            if(img.getColorAt(x, y).getAlpha() != 0 && img2.getColorAt(x - dx, y - dy).getAlpha() != 0){
                                return true; 
                            }
                        }
                    }
                }
            }
        }

        return false;
    }
    
    /**
     * Prüft, ob sich das aktuelle Objekt mit einem der angegebenen Klasse schneidet
     * 
     * @param cls Klasse der zu prüfenden Objekte
     * @author Florian Keck
     */
    protected boolean isTouching(Class cls){
        List<Actor> list = getWorld().getObjects(cls);
        List<Actor> intersecting;
        GreenfootImage img = getImage();

        for(Actor obj: list){
            if(isTouching(obj)){
                return true;
            }
        }
        return false;
    }
    
    /**
     * Gibt alle Objekt der angegeben Klasse zurück, die das aktuelle Objekt schneiden
     * 
     * @param cls Klasse der zu prüfenden Objekte
     * @author Florian Keck
     */
    protected List getTouching(Class cls){
        List<Actor> list = getWorld().getObjects(cls);
        List<Actor> objects = new ArrayList<Actor>();

        for(Actor obj: list){
            if(isTouching(obj)){
               objects.add(obj);
            }
        }
        return objects;
    }
    /**
     * Gibt ein Objekt der angegebenen Klasse zurück, das das aktuelle Objekt schneidet
     * 
     * @param cls Klasse der zu prüfenden Objekte
     * @return Objekt oder bei Fehler this
     * @author Florian Keck
     */
    protected Actor getOneTouching(Class cls){
        List<Actor> list = getWorld().getObjects(cls);
        Actor act;
        for(Actor obj: list){
            if(isTouching(obj)){
              return obj;
            }
        }
        return this;
    }
    
}
