/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.event.UndoableEditEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.UndoManager;

class EDITOR
extends ANZEIGE {
    private static final int umrechnung = 25410;
    private static File letzterOrdner = null;
    private JEditorPane editor;
    private JScrollPane scroll;
    private JLabel status;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    private JFileChooser fileChooser;
    private File file;
    private UndoManager undo = new UndoManager(){

        public void undoableEditHappened(UndoableEditEvent e) {
            super.undoableEditHappened(e);
            EDITOR.this.undoItem.setEnabled(this.canUndo());
            EDITOR.this.redoItem.setEnabled(this.canRedo());
        }
    };
    private boolean istAssembler = true;
    private String sicherungsstand = "";

    EDITOR(KONTROLLEURINTERFACE k) {
        super(k);
        this.fenster = new JFrame("Editor");
        this.MenuesErzeugen();
        this.fenster.setJMenuBar(this.menueZeile);
        JPanel content = (JPanel)this.fenster.getContentPane();
        content.setLayout(new BorderLayout());
        this.editor = new JEditorPane("text/plain", null);
        this.editor.getDocument().addUndoableEditListener(this.undo);
        this.scroll = new JScrollPane(this.editor, 20, 30);
        content.add((Component)this.scroll, "Center");
        this.status = new JLabel();
        this.status.setBorder(LineBorder.createGrayLineBorder());
        this.status.setBackground(Color.yellow);
        content.add((Component)this.status, "South");
        this.fenster.setSize(400, 200);
        this.fenster.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EDITOR.this.SchliessenAusfuehren(false);
            }
        });
        this.fenster.setDefaultCloseOperation(2);
        this.fileChooser = new JFileChooser();
        this.fileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                String n = f.getName();
                return n.toLowerCase().endsWith(".mis") || f.isDirectory();
            }

            public String getDescription() {
                return "Minimaschine Minisprache";
            }
        });
        this.fileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                String n = f.getName();
                return n.toLowerCase().endsWith(".mia") || f.isDirectory();
            }

            public String getDescription() {
                return "Minimaschine Assembler";
            }
        });
    }

    private void SichernAusfuehren(boolean immer) {
        if (this.file == null || immer) {
            if (this.file != null) {
                this.fileChooser.setSelectedFile(this.file);
            } else {
                this.fileChooser.setCurrentDirectory(letzterOrdner);
            }
            int res = this.fileChooser.showSaveDialog(this.fenster);
            if (res == 0) {
                this.file = this.fileChooser.getSelectedFile();
                if (this.fileChooser.getFileFilter().getDescription().equals("Minimaschine Assembler")) {
                    if (!this.file.getName().toLowerCase().endsWith(".mia")) {
                        this.file = new File(this.file.getPath() + ".mia");
                    }
                    letzterOrdner = this.file;
                } else if (this.fileChooser.getFileFilter().getDescription().equals("Minimaschine Minisprache")) {
                    if (!this.file.getName().toLowerCase().endsWith(".mis")) {
                        this.file = new File(this.file.getPath() + ".mis");
                    }
                    letzterOrdner = this.file;
                }
            } else {
                return;
            }
        }
        try {
            FileWriter out = new FileWriter(this.file);
            this.editor.write(out);
            out.close();
            this.sicherungsstand = this.editor.getText();
            this.fenster.setTitle(this.file.getPath());
            this.kontrolleur.FensterTitelAendernWeitergeben(this.selbst);
        }
        catch (Exception ex) {
            this.file = null;
        }
    }

    private void SchliessenAusfuehren(boolean cancelErlaubt) {
        if (!this.sicherungsstand.equals(this.editor.getText())) {
            int res = JOptionPane.showConfirmDialog(this.fenster, new String[]{"Dieses Fenster enth\u00e4lt ungesicherte \u00c4nderungen.", "Sollen sie gesichert werden?"}, "\u00c4nderungen sichern", cancelErlaubt ? 1 : 0);
            if (res == 0) {
                this.SichernAusfuehren(false);
            } else if (res != 1) {
                return;
            }
        }
        this.kontrolleur.SchliessenAusfuehren(this.selbst);
        this.fenster.dispose();
    }

    void BeendenMitteilen() {
        int res;
        if (!this.sicherungsstand.equals(this.editor.getText()) && (res = JOptionPane.showConfirmDialog(this.fenster, new String[]{"Dieses Fenster enth\u00e4lt ungesicherte \u00c4nderungen.", "Sollen sie gesichert werden?"}, "\u00c4nderungen sichern", 0)) == 0) {
            this.SichernAusfuehren(false);
        }
    }

    protected void MenuesErzeugen() {
        super.MenuesErzeugen();
        this.schliessenItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.SchliessenAusfuehren(true);
            }
        });
        this.sichernItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.SichernAusfuehren(false);
            }
        });
        this.sichernUnterItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.SichernAusfuehren(true);
            }
        });
        this.druckenItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.DruckenAusfuehren();
            }
        });
        this.undoItem = new JMenuItem("Widerrufen", 90);
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, kommando));
        this.undoItem.setEnabled(false);
        this.undoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.undo.undo();
                EDITOR.this.undoItem.setEnabled(EDITOR.this.undo.canUndo());
                EDITOR.this.redoItem.setEnabled(EDITOR.this.undo.canRedo());
            }
        });
        this.bearbeitenMenue.add(this.undoItem);
        this.redoItem = new JMenuItem("Wiederholen");
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(90, 64 + kommando));
        this.redoItem.setEnabled(false);
        this.redoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.undo.redo();
                EDITOR.this.undoItem.setEnabled(EDITOR.this.undo.canUndo());
                EDITOR.this.redoItem.setEnabled(EDITOR.this.undo.canRedo());
            }
        });
        this.bearbeitenMenue.add(this.redoItem);
        this.bearbeitenMenue.addSeparator();
        JMenuItem item = new JMenuItem("Ausschneiden", 88);
        item.setAccelerator(KeyStroke.getKeyStroke(88, kommando));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.editor.cut();
            }
        });
        this.bearbeitenMenue.add(item);
        item = new JMenuItem("Kopieren", 67);
        item.setAccelerator(KeyStroke.getKeyStroke(67, kommando));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.editor.copy();
            }
        });
        this.bearbeitenMenue.add(item);
        item = new JMenuItem("Einf\u00fcgen", 86);
        item.setAccelerator(KeyStroke.getKeyStroke(86, kommando));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.editor.paste();
            }
        });
        this.bearbeitenMenue.add(item);
        item = new JMenuItem("Alles ausw\u00e4hlen", 65);
        item.setAccelerator(KeyStroke.getKeyStroke(65, kommando));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.editor.selectAll();
            }
        });
        this.bearbeitenMenue.add(item);
        this.werkzeugMenue.addSeparator();
        this.groesseItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EDITOR.this.groesseItem.isSelected()) {
                    EDITOR.this.FontgroesseSetzen(24);
                } else {
                    EDITOR.this.FontgroesseSetzen(13);
                }
                EDITOR.this.editor.invalidate();
                EDITOR.this.editor.repaint();
            }
        });
        item = new JMenuItem("Assemblieren");
        item.setAccelerator(KeyStroke.getKeyStroke(65, kommando + 512));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.status.setText("");
                EDITOR.this.kontrolleur.Assemblieren(EDITOR.this.editor.getText(), (EDITOR)EDITOR.this.selbst);
            }
        });
        this.werkzeugMenue.add(item);
        this.werkzeugMenue.addSeparator();
        item = new JMenuItem("\u00dcbersetzen");
        item.setAccelerator(KeyStroke.getKeyStroke(85, kommando + 512));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.status.setText("");
                EDITOR.this.kontrolleur.Uebersetzen(EDITOR.this.editor.getText(), (EDITOR)EDITOR.this.selbst);
            }
        });
        this.werkzeugMenue.add(item);
        item = new JMenuItem("Assemblertext zeigen");
        item.setAccelerator(KeyStroke.getKeyStroke(90, kommando + 512));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EDITOR.this.status.setText("");
                EDITOR.this.kontrolleur.AssemblertextZeigen(EDITOR.this.editor.getText(), (EDITOR)EDITOR.this.selbst);
            }
        });
        this.werkzeugMenue.add(item);
    }

    private void FontgroesseSetzen(int size) {
        Font alt = this.editor.getFont();
        this.editor.setFont(new Font(alt.getName(), alt.getStyle(), size));
    }

    void DateiLesen() {
        this.fileChooser.setCurrentDirectory(letzterOrdner);
        int res = this.fileChooser.showOpenDialog(this.fenster);
        if (res == 0) {
            this.file = this.fileChooser.getSelectedFile();
            try {
                FileReader in = new FileReader(this.file);
                this.editor.read(in, null);
                in.close();
                this.sicherungsstand = this.editor.getText();
                this.fenster.setTitle(this.file.getPath());
                letzterOrdner = this.file;
            }
            catch (Exception ex) {
                this.file = null;
            }
        } else {
            this.file = null;
        }
        if (this.file != null) {
            this.fenster.setVisible(true);
            this.undoItem.setEnabled(false);
            this.redoItem.setEnabled(false);
            this.kontrolleur.FensterTitelAendernWeitergeben(this.selbst);
        } else {
            this.kontrolleur.SchliessenAusfuehren(this.selbst);
            this.fenster.dispose();
        }
    }

    void DateiLesen(String pfad) {
        this.file = new File(pfad);
        try {
            FileReader in = new FileReader(this.file);
            this.editor.read(in, null);
            in.close();
            this.sicherungsstand = this.editor.getText();
            this.fenster.setTitle(this.file.getPath());
        }
        catch (Exception ex) {
            this.file = null;
        }
        this.fenster.setVisible(true);
        this.undoItem.setEnabled(false);
        this.redoItem.setEnabled(false);
        this.kontrolleur.FensterTitelAendernWeitergeben(this.selbst);
    }

    void FehlerAnzeigen(String text, int pos) {
        this.status.setText(text);
        this.editor.select(pos - 2, pos - 1);
    }

    private void DruckenAusfuehren() {
        int i;
        String[] zeilen = this.editor.getText().split("\n");
        for (i = 0; i < zeilen.length; ++i) {
            int pos;
            while ((pos = zeilen[i].indexOf(9)) >= 0) {
                zeilen[i] = zeilen[i].substring(0, pos) + "        ".substring(0, 8 - pos % 8) + zeilen[i].substring(pos + 1);
            }
        }
        PrintJob job = this.fenster.getToolkit().getPrintJob(this.fenster, this.fenster.getTitle(), null);
        Dimension seite = job.getPageDimension();
        int res = job.getPageResolution();
        int rand = 15000 * res / 25410;
        int cm = 10000 * res / 25410;
        seite.width -= rand * 2;
        seite.height -= rand * 2;
        Font font = new Font("Monospaced", 0, 10);
        Font fontgross = new Font("Monospaced", 0, 14);
        Graphics port = job.getGraphics();
        int zeilenhoehe = port.getFontMetrics(font).getHeight();
        int anzahlZeilen = (seite.height - cm * 2) / zeilenhoehe;
        int anzahlSeiten = (zeilen.length + anzahlZeilen - 1) / anzahlZeilen;
        this.RahmenDrucken(port, seite, rand, cm, 1, anzahlSeiten, font, fontgross);
        for (i = 0; i < zeilen.length; ++i) {
            port.drawString(zeilen[i], rand + cm * 5 / 10, rand + 2 * cm + i % anzahlZeilen * zeilenhoehe);
            if ((i + 1) % anzahlZeilen != 0) continue;
            port.dispose();
            port = job.getGraphics();
            this.RahmenDrucken(port, seite, rand, cm, (i + 1) / anzahlZeilen, anzahlSeiten, font, fontgross);
        }
        port.dispose();
        job.end();
    }

    private void RahmenDrucken(Graphics port, Dimension seite, int rand, int cm, int seitennummer, int seitenzahl, Font font, Font fontgross) {
        port.drawRoundRect(rand, rand, seite.width, seite.height, cm * 2, cm * 2);
        port.drawLine(rand, rand + cm, rand + seite.width, rand + cm);
        port.drawLine(rand, rand + seite.height - cm, rand + seite.width, rand + seite.height - cm);
        String text = this.fenster.getTitle();
        port.setFont(fontgross);
        port.drawString(text, rand + seite.width / 2 - port.getFontMetrics().stringWidth(text) / 2, rand + cm * 7 / 10);
        text = "\u2013 " + seitennummer + " von " + seitenzahl + " \u2013";
        port.setFont(font);
        port.drawString(text, rand + seite.width / 2 - port.getFontMetrics().stringWidth(text) / 2, rand + seite.height - cm * 4 / 10);
    }
}

