/*
 * Decompiled with CFR 0.152.
 */
import MODEL.CPU;
import MODEL.FEHLERVERWALTUNG;
import MODEL.MINISPRACHE.PARSER;
import MODEL.SPEICHERLESEN;

class KONTROLLEUR
implements KONTROLLEURINTERFACE {
    private CPU cpu;
    private CPU cpuEinfach;
    private CPU cpuDetail;
    private FENSTERVERWALTUNG verwaltung;

    KONTROLLEUR(CPU cpuEinfach, CPU cpuDetail) {
        this.cpuEinfach = cpuEinfach;
        this.cpuDetail = cpuDetail;
        this.cpu = cpuDetail;
        this.verwaltung = null;
    }

    void VerwaltungSetzen(FENSTERVERWALTUNG verwaltung) {
        this.verwaltung = verwaltung;
        verwaltung.CpuAnzeigeWaehlen(true);
    }

    public boolean Assemblieren(String text, EDITOR e) {
        FEHLERVERWALTUNG fehler = new FEHLERVERWALTUNG();
        this.cpu.Assemblieren(text, fehler);
        if (fehler.FehlerAufgetreten()) {
            e.FehlerAnzeigen(fehler.FehlertextMelden(), fehler.FehlerpositionMelden());
        } else {
            this.cpu.ZurueckSetzen();
        }
        return !fehler.FehlerAufgetreten();
    }

    public boolean Uebersetzen(String text, EDITOR e) {
        FEHLERVERWALTUNG fehler = new FEHLERVERWALTUNG();
        this.cpu.Uebersetzen(text, fehler);
        if (fehler.FehlerAufgetreten()) {
            e.FehlerAnzeigen(fehler.FehlertextMelden(), fehler.FehlerpositionMelden());
        } else {
            this.cpu.ZurueckSetzen();
        }
        return !fehler.FehlerAufgetreten();
    }

    public boolean AssemblertextZeigen(String text, EDITOR e) {
        FEHLERVERWALTUNG fehler = new FEHLERVERWALTUNG();
        String asm = new PARSER(text, fehler).Parse();
        if (fehler.FehlerAufgetreten()) {
            e.FehlerAnzeigen(fehler.FehlertextMelden(), fehler.FehlerpositionMelden());
        } else {
            ASSEMBLERANZEIGE a = new ASSEMBLERANZEIGE(this, asm);
            this.verwaltung.EditorEintragen(a);
        }
        return !fehler.FehlerAufgetreten();
    }

    public void SpeicherLoeschen() {
        SPEICHERLESEN.SpeicherLoeschen();
    }

    public void Ausfuehren() {
        this.cpu.Ausfuehren();
    }

    public void EinzelSchritt() {
        this.cpu.Schritt();
    }

    public void MikroSchritt() {
        this.cpu.MikroSchritt();
    }

    public void ZurueckSetzen() {
        this.cpu.ZurueckSetzen();
    }

    public void NeuAusfuehren() {
        EDITOR e = new EDITOR(this);
        this.verwaltung.EditorEintragen(e);
        e.Aktivieren();
    }

    public void OeffnenAusfuehren() {
        EDITOR e = new EDITOR(this);
        this.verwaltung.EditorEintragen(e);
        e.DateiLesen();
    }

    public void OeffnenAusfuehren(String pfad) {
        EDITOR e = new EDITOR(this);
        this.verwaltung.EditorEintragen(e);
        e.DateiLesen(pfad);
    }

    public void SchliessenAusfuehren(ANZEIGE welcher) {
        this.verwaltung.EditorAustragen(welcher);
    }

    public void FensterTitelAendernWeitergeben(ANZEIGE welcher) {
        this.verwaltung.EditorTitelAendern(welcher);
    }

    public void CPUFensterAuswaehlen() {
        this.verwaltung.CPUFensterAuswaehlen();
    }

    public void SpeicherFensterAuswaehlen() {
        this.verwaltung.SpeicherFensterAuswaehlen();
    }

    public void EinfacheDarstellungAnzeigen() {
        this.cpu.Uebertragen(this.cpuEinfach);
        this.cpu = this.cpuEinfach;
        this.verwaltung.CpuAnzeigeWaehlen(false);
    }

    public void DetailDarstellungAnzeigen() {
        this.cpu.Uebertragen(this.cpuDetail);
        this.cpu = this.cpuDetail;
        this.verwaltung.CpuAnzeigeWaehlen(true);
    }

    public void BeendenAusfuehren() {
        this.verwaltung.BeendenMitteilen();
        System.exit(0);
    }
}

