/*
 * Decompiled with CFR 0.152.
 */
package MODEL;

import MODEL.ASSEMBLERBEFEHLE;
import MODEL.CPUBEOBACHTER;
import MODEL.CPUDETAIL;
import MODEL.CPUEINFACH;
import MODEL.CPUMELDUNGSERZEUGER;
import MODEL.FEHLERVERWALTUNG;
import MODEL.PARSER;
import MODEL.REGISTER;
import MODEL.SCANNER;
import MODEL.SPEICHER;
import MODEL.SPEICHERBEOBACHTER;
import java.util.ArrayList;

public abstract class CPU
implements CPUMELDUNGSERZEUGER {
    static final int noop = 0;
    static final int reset = 1;
    static final int add = 10;
    static final int sub = 11;
    static final int mul = 12;
    static final int div = 13;
    static final int mod = 14;
    static final int cmp = 15;
    static final int load = 20;
    static final int store = 21;
    static final int jgt = 30;
    static final int jge = 31;
    static final int jlt = 32;
    static final int jle = 33;
    static final int jeq = 34;
    static final int jne = 35;
    static final int jmp = 36;
    static final int jov = 37;
    static final int and = 40;
    static final int or = 41;
    static final int xor = 42;
    static final int shl = 43;
    static final int shr = 44;
    static final int shra = 45;
    static final int not = 46;
    static final int halt = 99;
    static final int ill = -1;
    static final int keineadr = 0;
    static final int absadr = 1;
    static final int immedadr = 2;
    protected REGISTER pc;
    protected REGISTER a;
    protected boolean ltflag;
    protected boolean eqflag;
    protected boolean ovflag;
    protected SPEICHER speicher;
    protected ASSEMBLERBEFEHLE mnemos;
    private ArrayList<CPUBEOBACHTER> beobachter;
    protected int befehlscode;
    protected int adressmodus;
    protected int adresse;
    private String[] progadr = new String[4];
    private String[] progmem = new String[4];
    private String[] dataadr = new String[2];
    private String[] datamem = new String[2];
    private int progAdrAlt;
    private int dataAdrAlt;

    CPU(SPEICHER s) {
        this.speicher = s;
        this.pc = new REGISTER();
        this.a = new REGISTER();
        this.mnemos = ASSEMBLERBEFEHLE.AssemblerbefehleGeben();
        this.beobachter = new ArrayList();
        this.ZurueckSetzen();
    }

    public void Registrieren(CPUBEOBACHTER beobachter) {
        this.beobachter.add(beobachter);
    }

    public void Abmelden(CPUBEOBACHTER beobachter) {
        this.beobachter.remove(beobachter);
    }

    protected void Melden(String datenWert, String adressWert, String alu1, String alu2, String alu3, boolean opMnemo, int progAdrNeu, int dataAdrNeu) {
        for (CPUBEOBACHTER b : this.beobachter) {
            int i;
            if (progAdrNeu != -1) {
                this.progAdrAlt = progAdrNeu;
            }
            if (dataAdrNeu != -1) {
                this.dataAdrAlt = dataAdrNeu;
            }
            for (i = 0; i < this.progmem.length; ++i) {
                this.progadr[i] = "" + (this.progAdrAlt + i < 0 ? 65536 + (this.progAdrAlt + i) : this.progAdrAlt + i);
                this.progmem[i] = "" + this.speicher.WortMitVorzeichenGeben(this.progAdrAlt + i);
            }
            for (i = 0; i < this.datamem.length; ++i) {
                this.dataadr[i] = "" + (this.dataAdrAlt + i < 0 ? 65536 + (this.dataAdrAlt + i) : this.dataAdrAlt + i);
                this.datamem[i] = "" + this.speicher.WortMitVorzeichenGeben(this.dataAdrAlt + i);
            }
            String op = this.mnemos.MnemonicGeben(this.befehlscode);
            b.Befehlsmeldung(datenWert, adressWert, alu1, alu2, alu3, "" + this.a.WertGeben(), this.eqflag, this.ltflag, this.ovflag, opMnemo ? (this.adressmodus == 2 ? op + "I" : op) : "" + (this.befehlscode + this.adressmodus * 256), "" + this.adresse, "" + this.pc.WertGeben(), this.progadr, this.progmem, this.dataadr, this.datamem);
        }
    }

    protected void Fehlermeldung(String text) {
        for (CPUBEOBACHTER b : this.beobachter) {
            b.Fehlermeldung(text);
        }
    }

    protected void OpcodeTesten() {
        switch (this.befehlscode) {
            case 0: 
            case 1: 
            case 46: 
            case 99: {
                if (this.adressmodus == 0 && this.adresse == 0) break;
                this.befehlscode = -1;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (this.adressmodus == 1 || this.adressmodus == 2) break;
                this.befehlscode = -1;
                break;
            }
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                if (this.adressmodus == 1) break;
                this.befehlscode = -1;
                break;
            }
            default: {
                this.befehlscode = -1;
            }
        }
    }

    public void Ausfuehren() {
        do {
            this.Schritt();
        } while (this.befehlscode != 99 && this.befehlscode != -1);
    }

    public abstract void Schritt();

    public abstract void MikroSchritt();

    protected int OperandenwertGeben(int adresse, int adressmodus) {
        switch (adressmodus) {
            case 1: {
                return this.speicher.WortMitVorzeichenGeben(adresse);
            }
            case 2: {
                return adresse;
            }
        }
        return 0;
    }

    public void ZurueckSetzen() {
        int i;
        this.pc.WertSetzen(0);
        this.a.WertSetzen(0);
        this.ltflag = false;
        this.eqflag = false;
        this.ovflag = false;
        this.befehlscode = -1;
        this.adressmodus = 0;
        this.adresse = 0;
        for (i = 0; i < this.progmem.length; ++i) {
            this.progadr[i] = "";
            this.progmem[i] = "";
        }
        for (i = 0; i < this.datamem.length; ++i) {
            this.dataadr[i] = "";
            this.datamem[i] = "";
        }
        this.progAdrAlt = 0;
        this.dataAdrAlt = 0;
        this.Melden("", "", "", "", "", true, -1, -1);
    }

    public void Uebertragen(CPU ziel) {
        if (this != ziel) {
            ziel.pc.WertSetzen(this.pc.WertGeben());
            ziel.a.WertSetzen(this.a.WertGeben());
            ziel.ltflag = this.ltflag;
            ziel.eqflag = this.eqflag;
            ziel.ovflag = this.ovflag;
            ziel.befehlscode = this.befehlscode;
            ziel.adressmodus = this.adressmodus;
            ziel.adresse = this.adresse;
            ziel.progAdrAlt = this.progAdrAlt;
            ziel.dataAdrAlt = this.dataAdrAlt;
        }
    }

    public static CPU CpuErzeugen(String name) {
        if ("einfach" == name) {
            return new CPUEINFACH(SPEICHER.SpeicherGeben());
        }
        if ("detail" == name) {
            return new CPUDETAIL(SPEICHER.SpeicherGeben());
        }
        return null;
    }

    public void Assemblieren(String text, FEHLERVERWALTUNG fehler) {
        new PARSER(new SCANNER(text), this.speicher, fehler).Parse();
    }

    public void Uebersetzen(String text, FEHLERVERWALTUNG fehler) {
        String asm = new MODEL.MINISPRACHE.PARSER(text, fehler).Parse();
        if (!fehler.FehlerAufgetreten()) {
            this.speicher.SpeicherLoeschen();
            new PARSER(new SCANNER(asm), this.speicher, fehler).Parse();
        }
    }

    public void SpeicherbeobachterSetzen(SPEICHERBEOBACHTER beobachter) {
        this.speicher.Registrieren(beobachter);
    }
}

