/*
 * Decompiled with CFR 0.152.
 */
package MODEL;

import MODEL.CPU;
import MODEL.MIKROSCHRITTE;
import MODEL.SPEICHER;

class CPUDETAIL
extends CPU {
    private MIKROSCHRITTE mikroStatus = MIKROSCHRITTE.komplett;
    private int op1;
    private int op2;
    private int res;
    private int pcAlt = 0;

    CPUDETAIL(SPEICHER s) {
        super(s);
    }

    public void ZurueckSetzen() {
        this.mikroStatus = MIKROSCHRITTE.komplett;
        this.pcAlt = 0;
        super.ZurueckSetzen();
    }

    public void Schritt() {
        do {
            this.MikroSchritt();
        } while (this.mikroStatus != MIKROSCHRITTE.komplett);
    }

    public void MikroSchritt() {
        switch (this.mikroStatus) {
            case komplett: {
                this.mikroStatus = MIKROSCHRITTE.fetch_opcode;
                this.Melden("", "", "", "", "", true, this.pc.WertGeben(), -1);
                break;
            }
            case fetch_opcode: {
                this.pcAlt = this.pc.WertGeben();
                int op = this.speicher.WortOhneVorzeichenGeben(this.pcAlt);
                this.pc.Inkrementieren(1);
                this.adressmodus = op / 256;
                this.befehlscode = op % 256;
                this.mikroStatus = MIKROSCHRITTE.fetch_adressteil;
                this.Melden("" + op, "" + (this.pcAlt < 0 ? 65536 + this.pcAlt : this.pcAlt), "", "", "", false, this.pcAlt, -1);
                break;
            }
            case fetch_adressteil: {
                this.pcAlt = this.pc.WertGeben();
                this.adresse = this.speicher.WortMitVorzeichenGeben(this.pcAlt);
                this.pc.Inkrementieren(1);
                this.mikroStatus = MIKROSCHRITTE.decode;
                this.Melden("" + this.adresse, "" + (this.pcAlt < 0 ? 65536 + this.pcAlt : this.pcAlt), "", "", "", false, -1, -1);
                break;
            }
            case decode: {
                this.OpcodeTesten();
                this.mikroStatus = MIKROSCHRITTE.execute_1;
                this.Melden("", "", "", "", "", true, -1, -1);
                break;
            }
            case execute_1: {
                this.Excecute1();
                break;
            }
            case execute_2: {
                this.Excecute2();
            }
        }
    }

    private void Excecute1() {
        switch (this.befehlscode) {
            case 0: {
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "", "", "", true, -1, -1);
                break;
            }
            case 99: {
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "", "", "", true, -1, -1);
                break;
            }
            case 1: {
                this.ZurueckSetzen();
                this.speicher.SpeicherLoeschen();
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "", "", "", true, -1, -1);
                break;
            }
            case 46: {
                this.op1 = this.a.WertGeben();
                this.mikroStatus = MIKROSCHRITTE.execute_2;
                this.Melden("", "", "" + this.op1, "", "", true, -1, -1);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.op1 = this.a.WertGeben();
                this.op2 = this.OperandenwertGeben(this.adresse, this.adressmodus);
                this.mikroStatus = MIKROSCHRITTE.execute_2;
                if (this.adressmodus == 1) {
                    this.Melden("" + this.op2, "" + (this.adresse < 0 ? 65536 + this.adresse : this.adresse), "" + this.op1, "" + this.op2, "", true, -1, this.adresse);
                    break;
                }
                this.Melden("", "", "" + this.op1, "" + this.op2, "", true, -1, -1);
                break;
            }
            case 20: {
                this.a.WertSetzen(this.OperandenwertGeben(this.adresse, this.adressmodus));
                this.ovflag = false;
                int res = this.a.WertGeben();
                this.ltflag = res < 0;
                this.eqflag = res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                if (this.adressmodus == 1) {
                    this.Melden("" + res, "" + (this.adresse < 0 ? 65536 + this.adresse : this.adresse), "", "", "", true, -1, this.adresse);
                    break;
                }
                this.Melden("", "", "", "", "", true, -1, -1);
                break;
            }
            case 21: {
                this.speicher.WortSetzen(this.adresse, this.a.WertGeben());
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("" + this.a.WertGeben(), "" + (this.adresse < 0 ? 65536 + this.adresse : this.adresse), "", "", "", true, -1, this.adresse);
                break;
            }
            case 30: {
                if (!this.ltflag && !this.eqflag) {
                    this.pc.WertSetzen(this.adresse);
                }
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "", "", "", true, this.pc.WertGeben(), -1);
                break;
            }
            case 31: {
                if (!this.ltflag) {
                    this.pc.WertSetzen(this.adresse);
                }
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "", "", "", true, this.pc.WertGeben(), -1);
                break;
            }
            case 32: {
                if (this.ltflag) {
                    this.pc.WertSetzen(this.adresse);
                }
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "", "", "", true, this.pc.WertGeben(), -1);
                break;
            }
            case 33: {
                if (this.ltflag || this.eqflag) {
                    this.pc.WertSetzen(this.adresse);
                }
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "", "", "", true, this.pc.WertGeben(), -1);
                break;
            }
            case 34: {
                if (this.eqflag) {
                    this.pc.WertSetzen(this.adresse);
                }
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "", "", "", true, this.pc.WertGeben(), -1);
                break;
            }
            case 35: {
                if (!this.eqflag) {
                    this.pc.WertSetzen(this.adresse);
                }
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "", "", "", true, this.pc.WertGeben(), -1);
                break;
            }
            case 37: {
                if (this.ovflag) {
                    this.pc.WertSetzen(this.adresse);
                }
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "", "", "", true, this.pc.WertGeben(), -1);
                break;
            }
            case 36: {
                this.pc.WertSetzen(this.adresse);
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "", "", "", true, this.pc.WertGeben(), -1);
                break;
            }
            default: {
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "", "", "", false, -1, -1);
                this.Fehlermeldung("Illegaler Befehlscode");
                this.befehlscode = -1;
            }
        }
    }

    private void Excecute2() {
        switch (this.befehlscode) {
            case 46: {
                this.res = ~this.op1;
                this.ovflag = false;
                this.a.WertSetzen(this.res);
                this.res = this.a.WertGeben();
                this.ltflag = this.res < 0;
                this.eqflag = this.res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "", "" + this.res, true, -1, -1);
                break;
            }
            case 10: {
                this.res = this.op1 + this.op2;
                this.ovflag = this.res > Short.MAX_VALUE || this.res < Short.MIN_VALUE;
                this.a.WertSetzen(this.res);
                this.res = this.a.WertGeben();
                this.ltflag = this.res < 0;
                this.eqflag = this.res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "" + this.op2, "" + this.res, true, -1, -1);
                break;
            }
            case 11: {
                this.res = this.op1 - this.op2;
                this.ovflag = this.res > Short.MAX_VALUE || this.res < Short.MIN_VALUE;
                this.a.WertSetzen(this.res);
                this.res = this.a.WertGeben();
                this.ltflag = this.res < 0;
                this.eqflag = this.res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "" + this.op2, "" + this.res, true, -1, -1);
                break;
            }
            case 12: {
                this.res = this.op1 * this.op2;
                this.ovflag = this.res > Short.MAX_VALUE || this.res < Short.MIN_VALUE;
                this.a.WertSetzen(this.res);
                this.res = this.a.WertGeben();
                this.ltflag = this.res < 0;
                this.eqflag = this.res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "" + this.op2, "" + this.res, true, -1, -1);
                break;
            }
            case 13: {
                if (this.op2 == 0) {
                    this.Fehlermeldung("Division durch 0");
                    this.res = this.op1;
                    this.ovflag = true;
                } else {
                    this.res = this.op1 / this.op2;
                    this.ovflag = this.res > Short.MAX_VALUE || this.res < Short.MIN_VALUE;
                }
                this.a.WertSetzen(this.res);
                this.res = this.a.WertGeben();
                this.ltflag = this.res < 0;
                this.eqflag = this.res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "" + this.op2, "" + this.res, true, -1, -1);
                break;
            }
            case 14: {
                if (this.op2 == 0) {
                    this.Fehlermeldung("Division durch 0");
                    this.res = this.op1;
                    this.ovflag = true;
                } else {
                    this.res = this.op1 % this.op2;
                    this.ovflag = this.res > Short.MAX_VALUE || this.res < Short.MIN_VALUE;
                }
                this.a.WertSetzen(this.res);
                this.res = this.a.WertGeben();
                this.ltflag = this.res < 0;
                this.eqflag = this.res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "" + this.op2, "" + this.res, true, -1, -1);
                break;
            }
            case 15: {
                this.ovflag = false;
                this.ltflag = this.op1 < this.op2;
                this.eqflag = this.op1 == this.op2;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "" + this.op2, "", true, -1, -1);
                break;
            }
            case 40: {
                this.res = this.op1 & this.op2;
                this.ovflag = false;
                this.a.WertSetzen(this.res);
                this.res = this.a.WertGeben();
                this.ltflag = this.res < 0;
                this.eqflag = this.res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "" + this.op2, "" + this.res, true, -1, -1);
                break;
            }
            case 41: {
                this.res = this.op1 | this.op2;
                this.ovflag = false;
                this.a.WertSetzen(this.res);
                this.res = this.a.WertGeben();
                this.ltflag = this.res < 0;
                this.eqflag = this.res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "" + this.op2, "" + this.res, true, -1, -1);
                break;
            }
            case 42: {
                this.res = this.op1 ^ this.op2;
                this.ovflag = false;
                this.a.WertSetzen(this.res);
                this.res = this.a.WertGeben();
                this.ltflag = this.res < 0;
                this.eqflag = this.res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "" + this.op2, "" + this.res, true, -1, -1);
                break;
            }
            case 43: {
                this.res = this.op1 << this.op2;
                this.ovflag = false;
                this.a.WertSetzen(this.res);
                this.res = this.a.WertGeben();
                this.ltflag = this.res < 0;
                this.eqflag = this.res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "" + this.op2, "" + this.res, true, -1, -1);
                break;
            }
            case 44: {
                this.res = (this.op1 & 0xFFFF) >> this.op2;
                this.ovflag = false;
                this.a.WertSetzen(this.res);
                this.res = this.a.WertGeben();
                this.ltflag = this.res < 0;
                this.eqflag = this.res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "" + this.op2, "" + this.res, true, -1, -1);
                break;
            }
            case 45: {
                this.res = this.op1 >> this.op2;
                this.ovflag = false;
                this.a.WertSetzen(this.res);
                this.res = this.a.WertGeben();
                this.ltflag = this.res < 0;
                this.eqflag = this.res == 0;
                this.mikroStatus = MIKROSCHRITTE.komplett;
                this.Melden("", "", "" + this.op1, "" + this.op2, "" + this.res, true, -1, -1);
            }
        }
    }

    public void Uebertragen(CPU ziel) {
        if (this != ziel) {
            while (this.mikroStatus != MIKROSCHRITTE.komplett) {
                this.MikroSchritt();
            }
        }
        super.Uebertragen(ziel);
    }
}

