/*
 * Decompiled with CFR 0.152.
 */
package MODEL.MINISPRACHE;

import MODEL.FEHLERVERWALTUNG;
import MODEL.MINISPRACHE.ASSEMBLERTEXT;
import MODEL.MINISPRACHE.ATTRIBUT;
import MODEL.MINISPRACHE.ATTRIBUTGELADEN;
import MODEL.MINISPRACHE.ATTRIBUTKONSTANT;
import MODEL.MINISPRACHE.ATTRIBUTVARIABLE;
import MODEL.MINISPRACHE.SCANNER;
import java.util.HashSet;

public class PARSER {
    private SCANNER scanner;
    private FEHLERVERWALTUNG fehler;
    private int aktToken;
    private String programmname;
    private HashSet<String> variable;
    private ASSEMBLERTEXT ausgabe;
    private int akthilfsplatz;
    private int maxhilfsplatz;
    private int markenNummer;

    public PARSER(String text, FEHLERVERWALTUNG f) {
        this.scanner = new SCANNER(text);
        this.fehler = f;
        this.aktToken = this.scanner.NaechstesToken();
        this.programmname = "";
        this.variable = new HashSet();
        this.ausgabe = new ASSEMBLERTEXT();
        this.akthilfsplatz = 0;
        this.maxhilfsplatz = 0;
        this.markenNummer = 0;
    }

    public String Parse() {
        this.Program();
        this.VariableAusgeben();
        return this.ausgabe.AssemblerGeben();
    }

    private void Program() {
        if (this.aktToken == 10) {
            this.aktToken = this.scanner.NaechstesToken();
            if (this.aktToken == 2) {
                this.programmname = this.scanner.BezeichnerGeben();
                this.aktToken = this.scanner.NaechstesToken();
            } else {
                this.fehler.FehlerEintragen("Bezeichner erwartet", this.scanner.PositionGeben());
            }
            if (this.aktToken == 30) {
                this.aktToken = this.scanner.NaechstesToken();
            } else {
                this.fehler.FehlerEintragen("';' erwartet", this.scanner.PositionGeben());
            }
            if (this.aktToken == 13) {
                this.Variablenvereinbarung();
            }
            if (this.aktToken == 11) {
                this.aktToken = this.scanner.NaechstesToken();
                this.Block();
                if (this.aktToken == 12) {
                    this.aktToken = this.scanner.NaechstesToken();
                    if (this.aktToken == 2) {
                        if (!this.programmname.equals(this.scanner.BezeichnerGeben())) {
                            this.fehler.FehlerEintragen("Programmname erwartet", this.scanner.PositionGeben());
                        }
                        this.aktToken = this.scanner.NaechstesToken();
                        if (this.aktToken == 31) {
                            this.aktToken = this.scanner.NaechstesToken();
                            if (this.aktToken != 0) {
                                this.fehler.FehlerEintragen("Unzul\u00e4ssige Zeichen am Programmende", this.scanner.PositionGeben());
                            }
                        } else {
                            this.fehler.FehlerEintragen("'.' erwartet", this.scanner.PositionGeben());
                        }
                    } else {
                        this.fehler.FehlerEintragen("Bezeichner erwartet", this.scanner.PositionGeben());
                    }
                } else {
                    this.fehler.FehlerEintragen("'END' erwartet", this.scanner.PositionGeben());
                }
            } else {
                this.fehler.FehlerEintragen("'BEGIN' erwartet", this.scanner.PositionGeben());
            }
        } else {
            this.fehler.FehlerEintragen("'PROGRAM' erwartet", this.scanner.PositionGeben());
        }
        this.ausgabe.BefehlEintragen(null, "HOLD", null);
    }

    private void Variablenvereinbarung() {
        this.aktToken = this.scanner.NaechstesToken();
        if (this.aktToken != 2) {
            this.fehler.FehlerEintragen("Bezeichner erwartet", this.scanner.PositionGeben());
            this.SkipBisStrichpunkt();
            this.aktToken = this.scanner.NaechstesToken();
        } else {
            do {
                String name;
                if (this.variable.contains(name = this.scanner.BezeichnerGeben())) {
                    this.fehler.FehlerEintragen("Bezeichner schon vereinbart", this.scanner.PositionGeben());
                } else {
                    this.variable.add(name);
                }
                this.aktToken = this.scanner.NaechstesToken();
                if (this.aktToken != 32) continue;
                this.aktToken = this.scanner.NaechstesToken();
            } while (this.aktToken == 2);
            if (this.aktToken == 30) {
                this.aktToken = this.scanner.NaechstesToken();
            } else {
                this.fehler.FehlerEintragen("';' erwartet", this.scanner.PositionGeben());
                this.SkipBisStrichpunkt();
                this.aktToken = this.scanner.NaechstesToken();
            }
        }
    }

    private void Block() {
        while (!this.BlockendeTesten() && this.aktToken != 0) {
            if (this.aktToken == 2) {
                this.Zuweisung();
            } else if (this.aktToken == 14) {
                this.BedingteAnweisung();
            } else if (this.aktToken == 17) {
                this.WiederholungEingang();
            } else if (this.aktToken == 21) {
                this.WiederholungZaehl();
            } else if (this.aktToken == 19) {
                this.WiederholungEnde();
            }
            if (this.aktToken == 30) {
                this.aktToken = this.scanner.NaechstesToken();
                continue;
            }
            if (this.BlockendeTesten()) continue;
            this.fehler.FehlerEintragen("';' erwartet", this.scanner.PositionGeben());
            if (this.aktToken == 2 || this.aktToken == 14 || this.aktToken == 17 || this.aktToken == 21 || this.aktToken == 19) continue;
            this.aktToken = this.scanner.NaechstesToken();
        }
    }

    private void Zuweisung() {
        String ergebnis = this.scanner.BezeichnerGeben();
        this.aktToken = this.scanner.NaechstesToken();
        if (this.aktToken == 33) {
            this.aktToken = this.scanner.NaechstesToken();
        } else {
            this.fehler.FehlerEintragen("':=' erwartet", this.scanner.PositionGeben());
            if (this.aktToken == 39 || this.aktToken != 1) {
                this.aktToken = this.scanner.NaechstesToken();
            }
        }
        ATTRIBUT wert = this.AusdruckStrich();
        wert.Laden(this.ausgabe);
        this.ausgabe.BefehlEintragen(null, "STORE", ergebnis);
    }

    private ATTRIBUT AusdruckStrich() {
        int benutzt;
        boolean monadMinus = false;
        if (this.aktToken == 34) {
            this.aktToken = this.scanner.NaechstesToken();
        } else if (this.aktToken == 35) {
            this.aktToken = this.scanner.NaechstesToken();
            monadMinus = true;
        }
        ATTRIBUT summand1 = this.AusdruckPunkt();
        if (monadMinus) {
            benutzt = 0;
            if (summand1 instanceof ATTRIBUTGELADEN) {
                ++this.akthilfsplatz;
                if (this.akthilfsplatz > this.maxhilfsplatz) {
                    this.maxhilfsplatz = this.akthilfsplatz;
                }
                this.ausgabe.BefehlEintragen(null, "STORE", "hi$" + this.akthilfsplatz);
                summand1 = new ATTRIBUTVARIABLE("hi$" + this.akthilfsplatz);
                benutzt = 1;
            }
            this.ausgabe.BefehlEintragen(null, "LOADI", "0");
            summand1.Operation(this.ausgabe, "SUB");
            summand1 = new ATTRIBUTGELADEN();
            this.akthilfsplatz -= benutzt;
        }
        while (this.aktToken == 34 || this.aktToken == 35) {
            String operand = "";
            if (this.aktToken == 34) {
                operand = "ADD";
            } else if (this.aktToken == 35) {
                operand = "SUB";
            }
            benutzt = 0;
            if (summand1 instanceof ATTRIBUTGELADEN) {
                ++this.akthilfsplatz;
                if (this.akthilfsplatz > this.maxhilfsplatz) {
                    this.maxhilfsplatz = this.akthilfsplatz;
                }
                this.ausgabe.BefehlEintragen(null, "STORE", "hi$" + this.akthilfsplatz);
                summand1 = new ATTRIBUTVARIABLE("hi$" + this.akthilfsplatz);
                benutzt = 1;
            }
            this.aktToken = this.scanner.NaechstesToken();
            ATTRIBUT summand2 = this.AusdruckPunkt();
            if (summand2 instanceof ATTRIBUTGELADEN) {
                ++this.akthilfsplatz;
                if (this.akthilfsplatz > this.maxhilfsplatz) {
                    this.maxhilfsplatz = this.akthilfsplatz;
                }
                this.ausgabe.BefehlEintragen(null, "STORE", "hi$" + this.akthilfsplatz);
                summand2 = new ATTRIBUTVARIABLE("hi$" + this.akthilfsplatz);
                ++benutzt;
            }
            summand1.Laden(this.ausgabe);
            summand2.Operation(this.ausgabe, operand);
            summand1 = new ATTRIBUTGELADEN();
            this.akthilfsplatz -= benutzt;
        }
        return summand1;
    }

    private ATTRIBUT AusdruckPunkt() {
        ATTRIBUT faktor1 = this.Faktor();
        while (this.aktToken == 36 || this.aktToken == 37 || this.aktToken == 38) {
            String operand = "";
            if (this.aktToken == 36) {
                operand = "MUL";
            } else if (this.aktToken == 37) {
                operand = "DIV";
            } else if (this.aktToken == 38) {
                operand = "MOD";
            }
            int benutzt = 0;
            if (faktor1 instanceof ATTRIBUTGELADEN) {
                ++this.akthilfsplatz;
                if (this.akthilfsplatz > this.maxhilfsplatz) {
                    this.maxhilfsplatz = this.akthilfsplatz;
                }
                this.ausgabe.BefehlEintragen(null, "STORE", "hi$" + this.akthilfsplatz);
                faktor1 = new ATTRIBUTVARIABLE("hi$" + this.akthilfsplatz);
                benutzt = 1;
            }
            this.aktToken = this.scanner.NaechstesToken();
            ATTRIBUT faktor2 = this.Faktor();
            if (faktor2 instanceof ATTRIBUTGELADEN) {
                ++this.akthilfsplatz;
                if (this.akthilfsplatz > this.maxhilfsplatz) {
                    this.maxhilfsplatz = this.akthilfsplatz;
                }
                this.ausgabe.BefehlEintragen(null, "STORE", "hi$" + this.akthilfsplatz);
                faktor2 = new ATTRIBUTVARIABLE("hi$" + this.akthilfsplatz);
                ++benutzt;
            }
            faktor1.Laden(this.ausgabe);
            faktor2.Operation(this.ausgabe, operand);
            faktor1 = new ATTRIBUTGELADEN();
            this.akthilfsplatz -= benutzt;
        }
        return faktor1;
    }

    private ATTRIBUT Faktor() {
        ATTRIBUT ergebnis;
        if (this.aktToken == 2) {
            ergebnis = new ATTRIBUTVARIABLE(this.scanner.BezeichnerGeben());
            this.aktToken = this.scanner.NaechstesToken();
        } else if (this.aktToken == 3) {
            ergebnis = new ATTRIBUTKONSTANT(this.scanner.ZahlGeben());
            this.aktToken = this.scanner.NaechstesToken();
        } else if (this.aktToken == 45) {
            this.aktToken = this.scanner.NaechstesToken();
            ergebnis = this.AusdruckStrich();
            if (this.aktToken == 46) {
                this.aktToken = this.scanner.NaechstesToken();
            } else {
                this.fehler.FehlerEintragen("')' erwartet", this.scanner.PositionGeben());
                if (!this.BlockendeTesten() && this.aktToken != 30) {
                    this.aktToken = this.scanner.NaechstesToken();
                }
            }
        } else {
            this.fehler.FehlerEintragen("Bezeichner, Zahl oder '(' erwartet", this.scanner.PositionGeben());
            ergebnis = new ATTRIBUTKONSTANT(0);
            if (!this.BlockendeTesten()) {
                this.aktToken = this.scanner.NaechstesToken();
            }
        }
        return ergebnis;
    }

    private void Bedingung(int marke) {
        ATTRIBUT ausdruck1 = this.AusdruckStrich();
        String operand = "";
        if (this.aktToken == 39) {
            operand = "JMPNZ";
        } else if (this.aktToken == 40) {
            operand = "JMPZ";
        } else if (this.aktToken == 41) {
            operand = "JMPNN";
        } else if (this.aktToken == 42) {
            operand = "JMPP";
        } else if (this.aktToken == 43) {
            operand = "JMPNP";
        } else if (this.aktToken == 44) {
            operand = "JMPN";
        } else {
            this.fehler.FehlerEintragen("'=', '<>', '>', '>=', '<' oder '<=' erwartet", this.scanner.PositionGeben());
        }
        int benutzt = 0;
        if (ausdruck1 instanceof ATTRIBUTGELADEN) {
            ++this.akthilfsplatz;
            if (this.akthilfsplatz > this.maxhilfsplatz) {
                this.maxhilfsplatz = this.akthilfsplatz;
            }
            this.ausgabe.BefehlEintragen(null, "STORE", "hi$" + this.akthilfsplatz);
            ausdruck1 = new ATTRIBUTVARIABLE("hi$" + this.akthilfsplatz);
            benutzt = 1;
        }
        this.aktToken = this.scanner.NaechstesToken();
        ATTRIBUT ausdruck2 = this.AusdruckStrich();
        if (ausdruck2 instanceof ATTRIBUTGELADEN) {
            ++this.akthilfsplatz;
            if (this.akthilfsplatz > this.maxhilfsplatz) {
                this.maxhilfsplatz = this.akthilfsplatz;
            }
            this.ausgabe.BefehlEintragen(null, "STORE", "hi$" + this.akthilfsplatz);
            ausdruck2 = new ATTRIBUTVARIABLE("hi$" + this.akthilfsplatz);
            ++benutzt;
        }
        ausdruck1.Laden(this.ausgabe);
        ausdruck2.Operation(this.ausgabe, "CMP");
        this.akthilfsplatz -= benutzt;
        this.ausgabe.BefehlEintragen(null, operand, "M$" + marke);
    }

    private void BedingteAnweisung() {
        ++this.markenNummer;
        int markeElse = this.markenNummer++;
        int markeEnde = this.markenNummer;
        this.aktToken = this.scanner.NaechstesToken();
        this.Bedingung(markeElse);
        if (this.aktToken == 15) {
            this.aktToken = this.scanner.NaechstesToken();
        } else {
            this.fehler.FehlerEintragen("'THEN' erwartet", this.scanner.PositionGeben());
        }
        this.Block();
        if (this.aktToken == 16) {
            this.aktToken = this.scanner.NaechstesToken();
            this.ausgabe.BefehlEintragen(null, "JMP", "M$" + markeEnde);
            this.ausgabe.BefehlEintragen("M$" + markeElse, null, null);
            this.Block();
            this.ausgabe.BefehlEintragen("M$" + markeEnde, null, null);
        } else {
            this.ausgabe.BefehlEintragen("M$" + markeElse, null, null);
        }
        if (this.aktToken == 12) {
            this.aktToken = this.scanner.NaechstesToken();
        } else {
            this.fehler.FehlerEintragen("'END' erwartet", this.scanner.PositionGeben());
        }
    }

    private void WiederholungEingang() {
        ++this.markenNummer;
        int markeStart = this.markenNummer++;
        int markeEnde = this.markenNummer;
        this.ausgabe.BefehlEintragen("M$" + markeStart, null, null);
        this.aktToken = this.scanner.NaechstesToken();
        this.Bedingung(markeEnde);
        if (this.aktToken == 18) {
            this.aktToken = this.scanner.NaechstesToken();
        } else {
            this.fehler.FehlerEintragen("'DO' erwartet", this.scanner.PositionGeben());
        }
        this.Block();
        this.ausgabe.BefehlEintragen(null, "JMP", "M$" + markeStart);
        this.ausgabe.BefehlEintragen("M$" + markeEnde, null, null);
        if (this.aktToken == 12) {
            this.aktToken = this.scanner.NaechstesToken();
        } else {
            this.fehler.FehlerEintragen("'END' erwartet", this.scanner.PositionGeben());
        }
    }

    private void WiederholungEnde() {
        int markeStart = ++this.markenNummer;
        this.ausgabe.BefehlEintragen("M$" + markeStart, null, null);
        this.aktToken = this.scanner.NaechstesToken();
        this.Block();
        if (this.aktToken == 20) {
            this.aktToken = this.scanner.NaechstesToken();
        } else {
            this.fehler.FehlerEintragen("'UNTIL' erwartet", this.scanner.PositionGeben());
        }
        this.Bedingung(markeStart);
    }

    private void WiederholungZaehl() {
        int schritt;
        String variable;
        ++this.markenNummer;
        int markeStart = this.markenNummer++;
        int markeEnde = this.markenNummer;
        ++this.akthilfsplatz;
        if (this.akthilfsplatz > this.maxhilfsplatz) {
            this.maxhilfsplatz = this.akthilfsplatz;
        }
        String endwert = "hi$" + this.akthilfsplatz;
        this.aktToken = this.scanner.NaechstesToken();
        if (this.aktToken == 2) {
            variable = this.scanner.BezeichnerGeben();
            this.aktToken = this.scanner.NaechstesToken();
        } else {
            this.fehler.FehlerEintragen("Bezeichner erwartet", this.scanner.PositionGeben());
            variable = "dummy";
        }
        if (this.aktToken == 33) {
            this.aktToken = this.scanner.NaechstesToken();
        } else {
            this.fehler.FehlerEintragen("':=' erwartet", this.scanner.PositionGeben());
            if (this.aktToken == 39 || this.aktToken != 1) {
                this.aktToken = this.scanner.NaechstesToken();
            }
        }
        ATTRIBUT wert = this.AusdruckStrich();
        wert.Laden(this.ausgabe);
        this.ausgabe.BefehlEintragen(null, "STORE", variable);
        if (this.aktToken == 22) {
            this.aktToken = this.scanner.NaechstesToken();
        } else {
            this.fehler.FehlerEintragen("'TO' erwartet", this.scanner.PositionGeben());
        }
        wert = this.AusdruckStrich();
        wert.Laden(this.ausgabe);
        this.ausgabe.BefehlEintragen(null, "STORE", endwert);
        if (this.aktToken == 23) {
            this.aktToken = this.scanner.NaechstesToken();
            boolean negativ = false;
            if (this.aktToken == 34) {
                this.aktToken = this.scanner.NaechstesToken();
            } else if (this.aktToken == 35) {
                this.aktToken = this.scanner.NaechstesToken();
                negativ = true;
            }
            if (this.aktToken == 3) {
                schritt = this.scanner.ZahlGeben();
                this.aktToken = this.scanner.NaechstesToken();
            } else {
                this.fehler.FehlerEintragen("Zahl erwartet", this.scanner.PositionGeben());
                schritt = 1;
            }
            if (negativ) {
                schritt = -schritt;
            }
            if (schritt == 0) {
                this.fehler.FehlerEintragen("Die Schrittweite darf nicht 0 sein", this.scanner.PositionGeben());
                schritt = 1;
            }
        } else {
            schritt = 1;
        }
        if (this.aktToken == 18) {
            this.aktToken = this.scanner.NaechstesToken();
        } else {
            this.fehler.FehlerEintragen("'DO' erwartet", this.scanner.PositionGeben());
        }
        this.ausgabe.BefehlEintragen("M$" + markeStart, null, null);
        this.ausgabe.BefehlEintragen(null, "LOAD", variable);
        this.ausgabe.BefehlEintragen(null, "CMP", endwert);
        if (schritt > 0) {
            this.ausgabe.BefehlEintragen(null, "JMPP", "M$" + markeEnde);
        } else {
            this.ausgabe.BefehlEintragen(null, "JMPN", "M$" + markeEnde);
        }
        this.Block();
        this.ausgabe.BefehlEintragen(null, "LOAD", variable);
        this.ausgabe.BefehlEintragen(null, "ADDI", "" + schritt);
        this.ausgabe.BefehlEintragen(null, "JMPV", "M$" + markeEnde);
        this.ausgabe.BefehlEintragen(null, "STORE", variable);
        this.ausgabe.BefehlEintragen(null, "JMP", "M$" + markeStart);
        this.ausgabe.BefehlEintragen("M$" + markeEnde, null, null);
        if (this.aktToken == 12) {
            this.aktToken = this.scanner.NaechstesToken();
        } else {
            this.fehler.FehlerEintragen("'END' erwartet", this.scanner.PositionGeben());
        }
        --this.akthilfsplatz;
    }

    private boolean BlockendeTesten() {
        return this.aktToken == 12 || this.aktToken == 16 || this.aktToken == 20;
    }

    private void SkipBisStrichpunkt() {
        while (this.aktToken != 30 && this.aktToken != 30) {
            this.aktToken = this.scanner.NaechstesToken();
        }
    }

    private void VariableAusgeben() {
        for (String name : this.variable) {
            this.ausgabe.BefehlEintragen(name, "WORD", "0");
        }
        for (int i = 1; i <= this.maxhilfsplatz; ++i) {
            this.ausgabe.BefehlEintragen("hi$" + i, "WORD", "0");
        }
    }
}

