/*
 * Decompiled with CFR 0.152.
 */
package MODEL;

import MODEL.ASSEMBLERBEFEHLE;
import MODEL.FEHLERVERWALTUNG;
import MODEL.SCANNER;
import MODEL.SPEICHER;
import java.util.HashMap;
import java.util.Map;

class PARSER {
    private SCANNER scanner;
    private SPEICHER speicher;
    private FEHLERVERWALTUNG fehler;
    private ASSEMBLERBEFEHLE befehle;
    private int aktToken;
    private int pc;
    private HashMap<String, Integer> marken;
    private HashMap<Integer, String> fixierungen;

    PARSER(SCANNER s, SPEICHER sp, FEHLERVERWALTUNG f) {
        this.scanner = s;
        this.speicher = sp;
        this.fehler = f;
        this.pc = 0;
        this.befehle = ASSEMBLERBEFEHLE.AssemblerbefehleGeben();
        this.marken = new HashMap(40);
        this.fixierungen = new HashMap(80);
        this.aktToken = this.scanner.NaechstesToken();
    }

    void Parse() {
        while (this.aktToken != 0) {
            while (this.aktToken == 5) {
                this.aktToken = this.scanner.NaechstesToken();
            }
            if (this.aktToken == 2) {
                String name = this.scanner.BezeichnerGeben();
                int posBefehl = this.scanner.PositionGeben();
                this.aktToken = this.scanner.NaechstesToken();
                if (this.aktToken == 4) {
                    if (this.marken.containsKey(name)) {
                        this.fehler.FehlerEintragen("Marke doppelt vereinbart", this.scanner.PositionGeben());
                    } else {
                        this.marken.put(name, this.pc);
                    }
                    this.aktToken = this.scanner.NaechstesToken();
                    if (this.aktToken == 2) {
                        name = this.scanner.BezeichnerGeben();
                        posBefehl = this.scanner.PositionGeben();
                        this.aktToken = this.scanner.NaechstesToken();
                    } else {
                        if (this.aktToken == 0 || this.aktToken == 5) continue;
                        this.fehler.FehlerEintragen("Bezeichner erwartet", this.scanner.PositionGeben());
                    }
                }
                if (this.befehle.BezeichnerTesten(name)) {
                    int adresse;
                    int vz;
                    int opcode = this.befehle.OpcodeGeben(name);
                    int adrmodus = 0;
                    if (opcode < 0) {
                        vz = 1;
                        if (this.aktToken == 7) {
                            vz = -1;
                            this.aktToken = this.scanner.NaechstesToken();
                        } else if (this.aktToken == 6) {
                            this.aktToken = this.scanner.NaechstesToken();
                        }
                        if (this.aktToken == 3) {
                            this.speicher.WortSetzen(this.pc, vz * this.scanner.ZahlGeben());
                            ++this.pc;
                            this.aktToken = this.scanner.NaechstesToken();
                        } else {
                            this.speicher.WortSetzen(this.pc, 0);
                            ++this.pc;
                            this.fehler.FehlerEintragen("Zahl erwartet", this.scanner.PositionGeben());
                        }
                    } else if (opcode >= 300) {
                        adresse = 0;
                        adrmodus = 2;
                        opcode -= 300;
                        vz = 1;
                        if (this.aktToken == 7) {
                            vz = -1;
                            this.aktToken = this.scanner.NaechstesToken();
                        } else if (this.aktToken == 6) {
                            this.aktToken = this.scanner.NaechstesToken();
                        }
                        if (this.aktToken == 3) {
                            adresse = vz * this.scanner.ZahlGeben();
                            this.aktToken = this.scanner.NaechstesToken();
                        } else {
                            this.fehler.FehlerEintragen("Zahl erwartet", this.scanner.PositionGeben());
                        }
                        this.speicher.WortSetzen(this.pc, adrmodus * 256 + opcode);
                        ++this.pc;
                        this.speicher.WortSetzen(this.pc, adresse);
                        ++this.pc;
                    } else {
                        adresse = 0;
                        adrmodus = 0;
                        if (this.aktToken == 2) {
                            adrmodus = 1;
                            name = this.scanner.BezeichnerGeben();
                            if (this.marken.containsKey(name)) {
                                adresse = this.marken.get(name);
                            } else {
                                this.fixierungen.put(this.pc + 1, name);
                            }
                            this.aktToken = this.scanner.NaechstesToken();
                        } else if (this.aktToken == 3) {
                            adrmodus = 1;
                            adresse = this.scanner.ZahlGeben();
                            this.aktToken = this.scanner.NaechstesToken();
                        } else if (this.aktToken == 8) {
                            adrmodus = 2;
                            this.aktToken = this.scanner.NaechstesToken();
                            vz = 1;
                            if (this.aktToken == 7) {
                                vz = -1;
                                this.aktToken = this.scanner.NaechstesToken();
                            } else if (this.aktToken == 6) {
                                this.aktToken = this.scanner.NaechstesToken();
                            }
                            if (this.aktToken == 3) {
                                adresse = vz * this.scanner.ZahlGeben();
                                this.aktToken = this.scanner.NaechstesToken();
                            } else {
                                this.fehler.FehlerEintragen("Zahl erwartet", this.scanner.PositionGeben());
                            }
                        }
                        this.speicher.WortSetzen(this.pc, adrmodus * 256 + opcode);
                        ++this.pc;
                        this.speicher.WortSetzen(this.pc, adresse);
                        ++this.pc;
                    }
                    switch (opcode) {
                        case 1: 
                        case 99: {
                            if (adrmodus == 0) break;
                            this.fehler.FehlerEintragen("Unzul\u00e4ssige Adressteile", this.scanner.PositionGeben());
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 15: 
                        case 20: {
                            if (adrmodus != 0) break;
                            this.fehler.FehlerEintragen("Fehlernder Adressteil", this.scanner.PositionGeben());
                            break;
                        }
                        case 21: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: {
                            if (adrmodus == 0) {
                                this.fehler.FehlerEintragen("Fehlernder Adressteil", this.scanner.PositionGeben());
                                break;
                            }
                            if (adrmodus != 2) break;
                            this.fehler.FehlerEintragen("Unzul\u00e4ssige Adressart", this.scanner.PositionGeben());
                        }
                    }
                    if (this.aktToken == 0 || this.aktToken == 5) continue;
                    this.fehler.FehlerEintragen("\u00dcberfl\u00fcssige Adressteile", this.scanner.PositionGeben());
                    continue;
                }
                this.fehler.FehlerEintragen("Kein g\u00fcltiger Befehl: " + name, posBefehl);
                this.Ueberspringen();
                continue;
            }
            if (this.aktToken == 0) continue;
            this.fehler.FehlerEintragen("Bezeichner erwartet", this.scanner.PositionGeben());
            this.Ueberspringen();
        }
        if (this.pc > 65536) {
            this.fehler.FehlerEintragen("Programm zu lang", this.scanner.PositionGeben());
        }
        for (Map.Entry<Integer, String> entry : this.fixierungen.entrySet()) {
            if (this.marken.containsKey(entry.getValue())) {
                this.speicher.WortSetzen(entry.getKey(), this.marken.get(entry.getValue()));
                continue;
            }
            this.fehler.FehlerEintragen("Marke nicht definiert: " + entry.getValue(), this.scanner.PositionGeben());
        }
        if (this.fehler.FehlerAufgetreten()) {
            if (this.pc > 65536) {
                this.pc = 65534;
                this.speicher.WortSetzen(65534, -1);
                this.speicher.WortSetzen(65535, -1);
            }
            for (int i = 0; i < this.pc; ++i) {
                this.speicher.WortSetzen(i, 0);
            }
        }
    }

    private void Ueberspringen() {
        while (this.aktToken != 0 && this.aktToken != 5) {
            this.aktToken = this.scanner.NaechstesToken();
        }
    }
}

