/*
 * Decompiled with CFR 0.152.
 */
import MODEL.SPEICHERBEOBACHTER;
import MODEL.SPEICHERLESEN;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

class SPEICHERANZEIGE
extends ANZEIGE
implements SPEICHERBEOBACHTER {
    private JScrollPane scroll;
    private TableModel dataModel;
    private JTable table;
    private JTable tableGross;
    private JScrollPane scrollpane;
    private JScrollPane scrollpaneGross;
    private int geaendert = -1;
    private boolean editierbar = false;
    private JCheckBoxMenuItem editItem;
    private JCheckBoxMenuItem hexaItem;
    private boolean hexaDarstellung = false;
    private JPanel content;

    SPEICHERANZEIGE(KONTROLLEURINTERFACE kontrolleur) {
        super(kontrolleur);
        this.MenuesErzeugen();
        this.AnzeigeAufbauen();
    }

    private void AnzeigeAufbauen() {
        int i;
        this.fenster = new JFrame("Speicheranzeige");
        this.fenster.setJMenuBar(this.menueZeile);
        this.fenster.setVisible(true);
        this.content = (JPanel)this.fenster.getContentPane();
        this.content.setLayout(new BorderLayout());
        this.dataModel = new AbstractTableModel(){

            public String getColumnName(int col) {
                return col == 0 ? "" : "" + (col - 1);
            }

            public int getColumnCount() {
                return 11;
            }

            public int getRowCount() {
                return 6555;
            }

            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return new Integer(row * 10);
                }
                int adr = row * 10 + (col - 1);
                if (adr < 65536) {
                    if (SPEICHERANZEIGE.this.hexaDarstellung) {
                        String text = "0000" + Integer.toHexString(SPEICHERLESEN.WortOhneVorzeichenGeben(adr)).toUpperCase();
                        return text.substring(text.length() - 4);
                    }
                    return new Integer(SPEICHERLESEN.WortMitVorzeichenGeben(adr));
                }
                return "";
            }

            public boolean isCellEditable(int row, int col) {
                return SPEICHERANZEIGE.this.editierbar && col != 0;
            }

            public void setValueAt(Object avalue, int row, int col) {
                if (avalue instanceof String) {
                    try {
                        int val;
                        String text = (String)avalue;
                        if (SPEICHERANZEIGE.this.hexaDarstellung) {
                            if (text.startsWith("0x")) {
                                text = text.substring(2);
                            }
                            val = Integer.parseInt(text, 16);
                        } else {
                            val = Integer.parseInt(text);
                        }
                        if (Short.MIN_VALUE <= val && val <= 65535) {
                            SPEICHERANZEIGE.this.geaendert = -1;
                            SPEICHERLESEN.WortSetzen(row * 10 + (col - 1), val);
                            SPEICHERANZEIGE.this.geaendert = -1;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        };
        this.table = new JTable(this.dataModel);
        for (i = 0; i < 11; ++i) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(50);
        }
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private Font f = null;
            private Font fbold = null;

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (this.f == null) {
                    this.f = c.getFont();
                    this.fbold = this.f.deriveFont(1);
                }
                if (column == 0) {
                    c.setBackground(Color.gray);
                    c.setFont(this.fbold);
                } else {
                    c.setBackground(Color.lightGray);
                    c.setFont(this.f);
                    if (row * 10 + (column - 1) == SPEICHERANZEIGE.this.geaendert) {
                        c.setForeground(Color.red);
                    } else {
                        c.setForeground(Color.black);
                    }
                }
                return c;
            }
        });
        this.table.getTableHeader().setFont(this.table.getTableHeader().getFont().deriveFont(1));
        this.scrollpane = new JScrollPane(this.table);
        this.tableGross = new JTable(this.dataModel);
        this.tableGross.setRowHeight(30);
        for (i = 0; i < 11; ++i) {
            this.tableGross.getColumnModel().getColumn(i).setPreferredWidth(100);
        }
        this.tableGross.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private Font f = null;
            private Font fbold = null;

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (this.f == null) {
                    this.f = c.getFont();
                    this.f = new Font(this.f.getName(), this.f.getStyle(), 24);
                    this.fbold = this.f.deriveFont(1);
                }
                if (column == 0) {
                    c.setBackground(Color.gray);
                    c.setFont(this.fbold);
                } else {
                    c.setBackground(Color.lightGray);
                    c.setFont(this.f);
                    if (row * 10 + (column - 1) == SPEICHERANZEIGE.this.geaendert) {
                        c.setForeground(Color.red);
                    } else {
                        c.setForeground(Color.black);
                    }
                }
                return c;
            }
        });
        Font f = this.tableGross.getTableHeader().getFont();
        this.tableGross.getTableHeader().setFont(new Font(f.getName(), 1, 24));
        this.scrollpaneGross = new JScrollPane(this.tableGross);
        this.content.add((Component)this.scrollpane, "Center");
        this.fenster.setSize(new Dimension(800, 500));
        this.fenster.setLocation(600, 50);
    }

    protected void MenuesErzeugen() {
        super.MenuesErzeugen();
        this.schliessenItem.setEnabled(false);
        this.sichernItem.setEnabled(false);
        this.sichernUnterItem.setEnabled(false);
        this.druckenItem.setEnabled(false);
        JMenuItem item = new JMenuItem("Widerrufen", 90);
        item.setAccelerator(KeyStroke.getKeyStroke(90, kommando));
        item.setEnabled(false);
        this.bearbeitenMenue.add(item);
        item = new JMenuItem("Wiederholen");
        item.setAccelerator(KeyStroke.getKeyStroke(90, 64 + kommando));
        item.setEnabled(false);
        this.bearbeitenMenue.add(item);
        this.bearbeitenMenue.addSeparator();
        item = new JMenuItem("Ausschneiden", 88);
        item.setAccelerator(KeyStroke.getKeyStroke(88, kommando));
        item.setEnabled(false);
        this.bearbeitenMenue.add(item);
        item = new JMenuItem("Kopieren", 67);
        item.setAccelerator(KeyStroke.getKeyStroke(67, kommando));
        item.setEnabled(false);
        this.bearbeitenMenue.add(item);
        item = new JMenuItem("Einf\u00fcgen", 86);
        item.setAccelerator(KeyStroke.getKeyStroke(86, kommando));
        item.setEnabled(false);
        this.bearbeitenMenue.add(item);
        item = new JMenuItem("Alles ausw\u00e4hlen", 65);
        item.setAccelerator(KeyStroke.getKeyStroke(65, kommando));
        item.setEnabled(false);
        this.bearbeitenMenue.add(item);
        this.werkzeugMenue.addSeparator();
        this.groesseItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SPEICHERANZEIGE.this.groesseItem.isSelected()) {
                    SPEICHERANZEIGE.this.content.remove(SPEICHERANZEIGE.this.scrollpane);
                    SPEICHERANZEIGE.this.content.add((Component)SPEICHERANZEIGE.this.scrollpaneGross, "Center");
                    SPEICHERANZEIGE.this.scrollpaneGross.invalidate();
                    SPEICHERANZEIGE.this.scrollpaneGross.repaint();
                } else {
                    SPEICHERANZEIGE.this.content.remove(SPEICHERANZEIGE.this.scrollpaneGross);
                    SPEICHERANZEIGE.this.content.add((Component)SPEICHERANZEIGE.this.scrollpane, "Center");
                    SPEICHERANZEIGE.this.scrollpane.invalidate();
                    SPEICHERANZEIGE.this.scrollpane.repaint();
                }
                SPEICHERANZEIGE.this.content.revalidate();
            }
        });
        item = new JMenuItem("Speicher l\u00f6schen", 65);
        item.setEnabled(true);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SPEICHERANZEIGE.this.kontrolleur.SpeicherLoeschen();
            }
        });
        this.werkzeugMenue.add(item);
        this.werkzeugMenue.addSeparator();
        this.hexaItem = new JCheckBoxMenuItem("Darstellung hexadezimal");
        this.hexaItem.setEnabled(true);
        this.hexaItem.setSelected(false);
        this.hexaItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SPEICHERANZEIGE.this.hexaDarstellung = SPEICHERANZEIGE.this.hexaItem.isSelected();
                SPEICHERANZEIGE.this.scrollpane.invalidate();
                SPEICHERANZEIGE.this.scrollpane.repaint();
            }
        });
        this.werkzeugMenue.add(this.hexaItem);
        this.werkzeugMenue.addSeparator();
        this.editItem = new JCheckBoxMenuItem("Speicher editieren");
        this.editItem.setEnabled(true);
        this.editItem.setSelected(false);
        this.editItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SPEICHERANZEIGE.this.editierbar = SPEICHERANZEIGE.this.editItem.isSelected();
            }
        });
        this.werkzeugMenue.add(this.editItem);
    }

    public void SpeicherGeaendertMelden(int geaendert) {
        this.geaendert = geaendert;
        this.scrollpane.invalidate();
        this.scrollpane.repaint();
        this.scrollpaneGross.invalidate();
        this.scrollpaneGross.repaint();
    }
}

