/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class Matrix3 {
    private static final float DEGREE_TO_RAD = (float)Math.PI / 180;
    float[] vals = new float[9];

    public Matrix3() {
        this.idt();
    }

    public Matrix3 idt() {
        this.vals[0] = 1.0f;
        this.vals[1] = 0.0f;
        this.vals[2] = 0.0f;
        this.vals[3] = 0.0f;
        this.vals[4] = 1.0f;
        this.vals[5] = 0.0f;
        this.vals[6] = 0.0f;
        this.vals[7] = 0.0f;
        this.vals[8] = 1.0f;
        return this;
    }

    public Matrix3 mul(Matrix3 m) {
        float v00 = this.vals[0] * m.vals[0] + this.vals[3] * m.vals[1] + this.vals[6] * m.vals[2];
        float v01 = this.vals[0] * m.vals[3] + this.vals[3] * m.vals[4] + this.vals[6] * m.vals[5];
        float v02 = this.vals[0] * m.vals[6] + this.vals[3] * m.vals[7] + this.vals[6] * m.vals[8];
        float v10 = this.vals[1] * m.vals[0] + this.vals[4] * m.vals[1] + this.vals[7] * m.vals[2];
        float v11 = this.vals[1] * m.vals[3] + this.vals[4] * m.vals[4] + this.vals[7] * m.vals[5];
        float v12 = this.vals[1] * m.vals[6] + this.vals[4] * m.vals[7] + this.vals[7] * m.vals[8];
        float v20 = this.vals[2] * m.vals[0] + this.vals[5] * m.vals[1] + this.vals[8] * m.vals[2];
        float v21 = this.vals[2] * m.vals[3] + this.vals[5] * m.vals[4] + this.vals[8] * m.vals[5];
        float v22 = this.vals[2] * m.vals[6] + this.vals[5] * m.vals[7] + this.vals[8] * m.vals[8];
        this.vals[0] = v00;
        this.vals[1] = v10;
        this.vals[2] = v20;
        this.vals[3] = v01;
        this.vals[4] = v11;
        this.vals[5] = v21;
        this.vals[6] = v02;
        this.vals[7] = v12;
        this.vals[8] = v22;
        return this;
    }

    public Matrix3 setToRotation(float angle) {
        float cos = (float)Math.cos(angle *= (float)Math.PI / 180);
        float sin = (float)Math.sin(angle);
        this.vals[0] = cos;
        this.vals[1] = sin;
        this.vals[2] = 0.0f;
        this.vals[3] = -sin;
        this.vals[4] = cos;
        this.vals[5] = 0.0f;
        this.vals[6] = 0.0f;
        this.vals[7] = 0.0f;
        this.vals[8] = 1.0f;
        return this;
    }

    public Matrix3 setToTranslation(float x, float y) {
        this.vals[0] = 1.0f;
        this.vals[1] = 0.0f;
        this.vals[2] = 0.0f;
        this.vals[3] = 0.0f;
        this.vals[4] = 1.0f;
        this.vals[5] = 0.0f;
        this.vals[6] = x;
        this.vals[7] = y;
        this.vals[8] = 1.0f;
        return this;
    }

    public Matrix3 setToScaling(float sx, float sy) {
        this.vals[0] = sx;
        this.vals[1] = 0.0f;
        this.vals[2] = 0.0f;
        this.vals[3] = 0.0f;
        this.vals[4] = sy;
        this.vals[5] = 0.0f;
        this.vals[6] = 0.0f;
        this.vals[7] = 0.0f;
        this.vals[8] = 1.0f;
        return this;
    }

    public String toString() {
        return "[" + this.vals[0] + "|" + this.vals[3] + "|" + this.vals[6] + "]\n" + "[" + this.vals[1] + "|" + this.vals[4] + "|" + this.vals[7] + "]\n" + "[" + this.vals[2] + "|" + this.vals[5] + "|" + this.vals[8] + "]";
    }

    public float det() {
        return this.vals[0] * this.vals[4] * this.vals[8] + this.vals[3] * this.vals[7] * this.vals[2] + this.vals[6] * this.vals[1] * this.vals[5] - this.vals[0] * this.vals[7] * this.vals[5] - this.vals[3] * this.vals[1] * this.vals[8] - this.vals[6] * this.vals[4] * this.vals[2];
    }

    public Matrix3 inv() {
        float det = this.det();
        if (det == 0.0f) {
            throw new GdxRuntimeException("Can't invert a singular matrix");
        }
        throw new GdxRuntimeException("Not implemented yet");
    }

    public static void main(String[] argv) {
        float refX = 50.0f;
        float refY = -50.0f;
        float scaleX = 2.0f;
        float scaleY = 1.0f;
        float rotation = 45.0f;
        float x = -232.0f;
        float y = 123.0f;
        Matrix3 transform = new Matrix3();
        Matrix3 tmp = new Matrix3();
        tmp.vals = new float[]{-2.0f, -1.0f, 2.0f, 2.0f, 1.0f, 0.0f, -3.0f, 3.0f, -1.0f};
        System.out.println(tmp.det());
        transform.idt();
        transform.setToTranslation(-refX, -refY);
        transform.mul(tmp.setToScaling(scaleX, scaleY));
        transform.mul(tmp.setToRotation(rotation));
        transform.mul(tmp.setToTranslation(refX, refY));
        transform.mul(tmp.setToTranslation(x, y));
        System.out.println(new Vector2().mul(transform));
        Matrix4 transform4 = new Matrix4();
        Matrix4 tmp4 = new Matrix4();
        transform4.idt();
        transform4.setToTranslation(-refX, -refY, 0.0f);
        transform4.mul(tmp4.setToScaling(scaleX, scaleY, 1.0f));
        transform4.mul(tmp4.setToRotation(new Vector3(0.0f, 0.0f, 1.0f), rotation));
        transform4.mul(tmp4.setToTranslation(refX, refY, 0.0f));
        transform4.mul(tmp4.setToTranslation(x, y, 0.0f));
        System.out.println(new Vector3().mul(transform4));
    }

    public Matrix3 set(Matrix3 mat) {
        this.vals[0] = mat.vals[0];
        this.vals[1] = mat.vals[1];
        this.vals[2] = mat.vals[2];
        this.vals[3] = mat.vals[3];
        this.vals[4] = mat.vals[4];
        this.vals[5] = mat.vals[5];
        this.vals[6] = mat.vals[6];
        this.vals[7] = mat.vals[7];
        this.vals[8] = mat.vals[8];
        return this;
    }

    public float[] getValues() {
        return this.vals;
    }
}

