/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Vector3;
import java.io.Serializable;

public final class Quaternion
implements Serializable {
    private static final long serialVersionUID = -7661875440774897168L;
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    Quaternion() {
    }

    public Quaternion(Quaternion quaternion) {
        this.set(quaternion);
    }

    public Quaternion(Vector3 axis, float angle) {
        this.set(axis, angle);
    }

    public Quaternion set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Quaternion set(Quaternion quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Quaternion set(Vector3 axis, float angle) {
        float l_ang = (float)Math.toRadians(angle);
        float l_sin = (float)Math.sin(l_ang / 2.0f);
        float l_cos = (float)Math.cos(l_ang / 2.0f);
        return this.set(axis.x * l_sin, axis.y * l_sin, axis.z * l_sin, l_cos).nor();
    }

    public Quaternion cpy() {
        return new Quaternion(this);
    }

    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public Quaternion nor() {
        float l_len = this.len();
        return this.set(this.x / l_len, this.y / l_len, this.z / l_len, this.w / l_len);
    }

    public String toString() {
        return "[" + this.x + "|" + this.y + "|" + this.z + "|" + this.w + "]";
    }

    public Quaternion setEulerAngles(float yaw, float pitch, float roll) {
        yaw = (float)Math.toRadians(yaw);
        pitch = (float)Math.toRadians(pitch);
        roll = (float)Math.toRadians(roll);
        float num9 = roll * 0.5f;
        float num6 = (float)Math.sin(num9);
        float num5 = (float)Math.cos(num9);
        float num8 = pitch * 0.5f;
        float num4 = (float)Math.sin(num8);
        float num3 = (float)Math.cos(num8);
        float num7 = yaw * 0.5f;
        float num2 = (float)Math.sin(num7);
        float num = (float)Math.cos(num7);
        this.x = num * num4 * num5 + num2 * num3 * num6;
        this.y = num2 * num3 * num5 - num * num4 * num6;
        this.z = num * num3 * num6 - num2 * num4 * num5;
        this.w = num * num3 * num5 + num2 * num4 * num6;
        return this;
    }
}

