/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.WorldManifold;

public class Contact {
    protected long addr;
    protected World world;
    protected final WorldManifold worldManifold = new WorldManifold();
    private final float[] tmp = new float[6];

    protected Contact(World world, long addr) {
        this.addr = addr;
        this.world = world;
    }

    public WorldManifold GetWorldManifold() {
        int numContactPoints;
        this.worldManifold.numContactPoints = numContactPoints = this.jniGetWorldManifold(this.addr, this.tmp);
        this.worldManifold.normal.set(this.tmp[0], this.tmp[1]);
        int i = 0;
        while (i < numContactPoints) {
            Vector2 point = this.worldManifold.points[i];
            point.x = this.tmp[2 + i * 2];
            point.y = this.tmp[2 + i * 2 + 1];
            ++i;
        }
        return this.worldManifold;
    }

    private native int jniGetWorldManifold(long var1, float[] var3);

    public boolean isTouching() {
        return this.jniIsTouching(this.addr);
    }

    private native boolean jniIsTouching(long var1);

    public void setEnabled(boolean flag) {
        this.jniSetEnabled(this.addr, flag);
    }

    private native void jniSetEnabled(long var1, boolean var3);

    public boolean isEnabled() {
        return this.jniIsEnabled(this.addr);
    }

    private native boolean jniIsEnabled(long var1);

    public Fixture getFixtureA() {
        return this.world.fixtures.get(this.jniGetFixtureA(this.addr));
    }

    private native long jniGetFixtureA(long var1);

    public Fixture getFixtureB() {
        return this.world.fixtures.get(this.jniGetFixtureB(this.addr));
    }

    private native long jniGetFixtureB(long var1);
}

