/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactFilter;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.DestructionListener;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.JointEdge;
import com.badlogic.gdx.physics.box2d.QueryCallback;
import com.badlogic.gdx.physics.box2d.joints.DistanceJoint;
import com.badlogic.gdx.physics.box2d.joints.DistanceJointDef;
import com.badlogic.gdx.physics.box2d.joints.FrictionJoint;
import com.badlogic.gdx.physics.box2d.joints.FrictionJointDef;
import com.badlogic.gdx.physics.box2d.joints.GearJoint;
import com.badlogic.gdx.physics.box2d.joints.GearJointDef;
import com.badlogic.gdx.physics.box2d.joints.LineJoint;
import com.badlogic.gdx.physics.box2d.joints.LineJointDef;
import com.badlogic.gdx.physics.box2d.joints.MouseJoint;
import com.badlogic.gdx.physics.box2d.joints.MouseJointDef;
import com.badlogic.gdx.physics.box2d.joints.PrismaticJoint;
import com.badlogic.gdx.physics.box2d.joints.PrismaticJointDef;
import com.badlogic.gdx.physics.box2d.joints.PulleyJoint;
import com.badlogic.gdx.physics.box2d.joints.PulleyJointDef;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJoint;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJointDef;
import com.badlogic.gdx.physics.box2d.joints.WeldJoint;
import com.badlogic.gdx.physics.box2d.joints.WeldJointDef;
import com.badlogic.gdx.utils.LongHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class World {
    private final long addr;
    protected final LongHashMap<Body> bodies = new LongHashMap(100);
    protected final LongHashMap<Fixture> fixtures = new LongHashMap(100);
    protected final LongHashMap<Joint> joints = new LongHashMap(100);
    protected ContactFilter contactFilter = null;
    protected ContactListener contactListener = null;
    final float[] tmpGravity = new float[2];
    final Vector2 gravity = new Vector2();
    private QueryCallback queryCallback = null;
    private long[] contactAddrs = new long[200];
    private final ArrayList<Contact> contacts = new ArrayList();
    private final ArrayList<Contact> freeContacts = new ArrayList();
    private final Contact contact = new Contact(this, 0L);

    static {
        System.loadLibrary("gdx");
    }

    public World(Vector2 gravity, boolean doSleep) {
        this.addr = this.newWorld(gravity.x, gravity.y, doSleep);
        int i = 0;
        while (i < 200) {
            this.freeContacts.add(new Contact(this, 0L));
            ++i;
        }
    }

    private native long newWorld(float var1, float var2, boolean var3);

    public void setDestructionListener(DestructionListener listener) {
    }

    public void setContactFilter(ContactFilter filter) {
        this.contactFilter = filter;
    }

    public void setContactListener(ContactListener listener) {
        this.contactListener = listener;
    }

    public Body createBody(BodyDef def) {
        Body body = new Body(this, this.jniCreateBody(this.addr, def.type.getValue(), def.position.x, def.position.y, def.angle, def.linearVelocity.x, def.linearVelocity.y, def.angularVelocity, def.linearDamping, def.angularDamping, def.allowSleep, def.awake, def.fixedRotation, def.bullet, def.active, def.inertiaScale));
        this.bodies.put(body.addr, body);
        return body;
    }

    private native long jniCreateBody(long var1, int var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, boolean var12, boolean var13, boolean var14, boolean var15, boolean var16, float var17);

    public void destroyBody(Body body) {
        this.bodies.remove(body.addr);
        int i = 0;
        while (i < body.getFixtureList().size()) {
            this.fixtures.remove(body.getFixtureList().get((int)i).addr);
            ++i;
        }
        i = 0;
        while (i < body.getJointList().size()) {
            this.joints.remove(body.getJointList().get((int)i).joint.addr);
            ++i;
        }
        this.jniDestroyBody(this.addr, body.addr);
    }

    private native void jniDestroyBody(long var1, long var3);

    public Joint createJoint(JointDef def) {
        long jointAddr = this.createProperJoint(def);
        Joint joint = null;
        if (def.type == JointDef.JointType.DistanceJoint) {
            joint = new DistanceJoint(this, jointAddr);
        }
        if (def.type == JointDef.JointType.FrictionJoint) {
            joint = new FrictionJoint(this, jointAddr);
        }
        if (def.type == JointDef.JointType.GearJoint) {
            joint = new GearJoint(this, jointAddr);
        }
        if (def.type == JointDef.JointType.LineJoint) {
            joint = new LineJoint(this, jointAddr);
        }
        if (def.type == JointDef.JointType.MouseJoint) {
            joint = new MouseJoint(this, jointAddr);
        }
        if (def.type == JointDef.JointType.PrismaticJoint) {
            joint = new PrismaticJoint(this, jointAddr);
        }
        if (def.type == JointDef.JointType.PulleyJoint) {
            joint = new PulleyJoint(this, jointAddr);
        }
        if (def.type == JointDef.JointType.RevoluteJoint) {
            joint = new RevoluteJoint(this, jointAddr);
        }
        if (def.type == JointDef.JointType.WeldJoint) {
            joint = new WeldJoint(this, jointAddr);
        }
        if (joint != null) {
            this.joints.put(joint.addr, joint);
        }
        JointEdge jointEdgeA = new JointEdge(def.bodyB, joint);
        JointEdge jointEdgeB = new JointEdge(def.bodyA, joint);
        joint.jointEdgeA = jointEdgeA;
        joint.jointEdgeB = jointEdgeB;
        def.bodyA.joints.add(jointEdgeA);
        def.bodyB.joints.add(jointEdgeB);
        return joint;
    }

    private long createProperJoint(JointDef def) {
        if (def.type == JointDef.JointType.DistanceJoint) {
            DistanceJointDef d = (DistanceJointDef)def;
            return this.jniCreateDistanceJoint(this.addr, d.bodyA.addr, d.bodyB.addr, d.collideConnected, d.localAnchorA.x, d.localAnchorA.y, d.localAnchorB.x, d.localAnchorB.y, d.length, d.frequencyHz, d.dampingRatio);
        }
        if (def.type == JointDef.JointType.FrictionJoint) {
            FrictionJointDef d = (FrictionJointDef)def;
            return this.jniCreateFrictionJoint(this.addr, d.bodyA.addr, d.bodyB.addr, d.collideConnected, d.localAnchorA.x, d.localAnchorA.y, d.localAnchorB.x, d.localAnchorB.y, d.maxForce, d.maxTorque);
        }
        if (def.type == JointDef.JointType.GearJoint) {
            GearJointDef d = (GearJointDef)def;
            return this.jniCreateGearJoint(this.addr, d.bodyA.addr, d.bodyB.addr, d.collideConnected, d.joint1.addr, d.joint2.addr, d.ratio);
        }
        if (def.type == JointDef.JointType.LineJoint) {
            LineJointDef d = (LineJointDef)def;
            return this.jniCreateLineJoint(this.addr, d.bodyA.addr, d.bodyB.addr, d.collideConnected, d.localAnchorA.x, d.localAnchorA.y, d.localAnchorB.x, d.localAnchorB.y, d.localAxisA.x, d.localAxisA.y, d.enableLimit, d.lowerTranslation, d.upperTranslation, d.enableMotor, d.maxMotorForce, d.motorSpeed);
        }
        if (def.type == JointDef.JointType.MouseJoint) {
            MouseJointDef d = (MouseJointDef)def;
            return this.jniCreateMouseJoint(this.addr, d.bodyA.addr, d.bodyB.addr, d.collideConnected, d.target.x, d.target.y, d.maxForce, d.frequencyHz, d.dampingRatio);
        }
        if (def.type == JointDef.JointType.PrismaticJoint) {
            PrismaticJointDef d = (PrismaticJointDef)def;
            return this.jniCreatePrismaticJoint(this.addr, d.bodyA.addr, d.bodyB.addr, d.collideConnected, d.localAnchorA.x, d.localAnchorA.y, d.localAnchorB.x, d.localAnchorB.y, d.localAxis1.x, d.localAxis1.y, d.referenceAngle, d.enableLimit, d.lowerTranslation, d.upperTranslation, d.enableMotor, d.maxMotorForce, d.motorSpeed);
        }
        if (def.type == JointDef.JointType.PulleyJoint) {
            PulleyJointDef d = (PulleyJointDef)def;
            return this.jniCreatePulleyJoint(this.addr, d.bodyA.addr, d.bodyB.addr, d.collideConnected, d.groundAnchorA.x, d.groundAnchorA.y, d.groundAnchorB.x, d.groundAnchorB.y, d.localAnchorA.x, d.localAnchorA.y, d.localAnchorB.x, d.localAnchorB.y, d.lengthA, d.maxLengthA, d.lengthB, d.maxLengthB, d.ratio);
        }
        if (def.type == JointDef.JointType.RevoluteJoint) {
            RevoluteJointDef d = (RevoluteJointDef)def;
            return this.jniCreateRevoluteJoint(this.addr, d.bodyA.addr, d.bodyB.addr, d.collideConnected, d.localAnchorA.x, d.localAnchorA.y, d.localAnchorB.x, d.localAnchorB.y, d.referenceAngle, d.enableLimit, d.lowerAngle, d.upperAngle, d.enableMotor, d.motorSpeed, d.maxMotorTorque);
        }
        if (def.type == JointDef.JointType.WeldJoint) {
            WeldJointDef d = (WeldJointDef)def;
            return this.jniCreateWeldJoint(this.addr, d.bodyA.addr, d.bodyB.addr, d.collideConnected, d.localAnchorA.x, d.localAnchorA.y, d.localAnchorB.x, d.localAnchorB.y, d.referenceAngle);
        }
        return 0L;
    }

    private native long jniCreateDistanceJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14);

    private native long jniCreateFrictionJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, float var13);

    private native long jniCreateGearJoint(long var1, long var3, long var5, boolean var7, long var8, long var10, float var12);

    private native long jniCreateLineJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, float var13, boolean var14, float var15, float var16, boolean var17, float var18, float var19);

    private native long jniCreateMouseJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12);

    private native long jniCreatePrismaticJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, boolean var15, float var16, float var17, boolean var18, float var19, float var20);

    private native long jniCreatePulleyJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20);

    private native long jniCreateRevoluteJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12, boolean var13, float var14, float var15, boolean var16, float var17, float var18);

    private native long jniCreateWeldJoint(long var1, long var3, long var5, boolean var7, float var8, float var9, float var10, float var11, float var12);

    public void destroyJoint(Joint joint) {
        this.joints.remove(joint.addr);
        joint.jointEdgeA.other.joints.remove(joint.jointEdgeB);
        joint.jointEdgeB.other.joints.remove(joint.jointEdgeA);
        this.jniDestroyJoint(this.addr, joint.addr);
    }

    private native void jniDestroyJoint(long var1, long var3);

    public void step(float timeStep, int velocityIterations, int positionIterations) {
        this.jniStep(this.addr, timeStep, velocityIterations, positionIterations);
    }

    private native void jniStep(long var1, float var3, int var4, int var5);

    public void clearForces() {
        this.jniClearForces(this.addr);
    }

    private native void jniClearForces(long var1);

    public void setWarmStarting(boolean flag) {
        this.jniSetWarmStarting(this.addr, flag);
    }

    private native void jniSetWarmStarting(long var1, boolean var3);

    public void setContinuousPhysics(boolean flag) {
        this.jniSetContiousPhysics(this.addr, flag);
    }

    private native void jniSetContiousPhysics(long var1, boolean var3);

    public int getProxyCount() {
        return this.jniGetProxyCount(this.addr);
    }

    private native int jniGetProxyCount(long var1);

    public int getBodyCount() {
        return this.jniGetBodyCount(this.addr);
    }

    private native int jniGetBodyCount(long var1);

    public int getJointCount() {
        return this.jniGetJointcount(this.addr);
    }

    private native int jniGetJointcount(long var1);

    public int getContactCount() {
        return this.jniGetContactCount(this.addr);
    }

    private native int jniGetContactCount(long var1);

    public void setGravity(Vector2 gravity) {
        this.jniSetGravity(this.addr, gravity.x, gravity.y);
    }

    private native void jniSetGravity(long var1, float var3, float var4);

    public Vector2 getGravity() {
        this.jniGetGravity(this.addr, this.tmpGravity);
        this.gravity.x = this.tmpGravity[0];
        this.gravity.y = this.tmpGravity[1];
        return this.gravity;
    }

    private native void jniGetGravity(long var1, float[] var3);

    public boolean isLocked() {
        return this.jniIsLocked(this.addr);
    }

    private native boolean jniIsLocked(long var1);

    public void setAutoClearForces(boolean flag) {
        this.jniSetAutoClearForces(this.addr, flag);
    }

    private native void jniSetAutoClearForces(long var1, boolean var3);

    public boolean getAutoClearForces() {
        return this.jniGetAutoClearForces(this.addr);
    }

    private native boolean jniGetAutoClearForces(long var1);

    public void QueryAABB(QueryCallback callback, float lowerX, float lowerY, float upperX, float upperY) {
        this.queryCallback = callback;
        this.jniQueryAABB(this.addr, lowerX, lowerY, upperX, upperY);
    }

    private native void jniQueryAABB(long var1, float var3, float var4, float var5, float var6);

    public List<Contact> getContactList() {
        int numContacts = this.getContactCount();
        if (numContacts > this.contactAddrs.length) {
            this.contactAddrs = new long[numContacts];
        }
        if (numContacts > this.freeContacts.size()) {
            int freeConts = this.freeContacts.size();
            int i = 0;
            while (i < numContacts - freeConts) {
                this.freeContacts.add(new Contact(this, 0L));
                ++i;
            }
        }
        this.jniGetContactList(this.addr, this.contactAddrs);
        this.contacts.clear();
        int i = 0;
        while (i < numContacts) {
            Contact contact = this.freeContacts.get(i);
            contact.addr = this.contactAddrs[i];
            this.contacts.add(contact);
            ++i;
        }
        return this.contacts;
    }

    public Iterator<Body> getBodies() {
        return this.bodies.values();
    }

    public Iterator<Joint> getJoints() {
        return this.joints.values();
    }

    private native void jniGetContactList(long var1, long[] var3);

    public void dispose() {
        this.jniDispose(this.addr);
    }

    private native void jniDispose(long var1);

    private boolean contactFilter(long fixtureA, long fixtureB) {
        if (this.contactFilter != null) {
            return this.contactFilter.shouldCollide(this.fixtures.get(fixtureA), this.fixtures.get(fixtureB));
        }
        Filter filterA = this.fixtures.get(fixtureA).getFilterData();
        Filter filterB = this.fixtures.get(fixtureB).getFilterData();
        if (filterA.groupIndex == filterB.groupIndex && filterA.groupIndex != 0) {
            return filterA.groupIndex > 0;
        }
        boolean collide = (filterA.maskBits & filterB.categoryBits) != 0 && (filterA.categoryBits & filterB.maskBits) != 0;
        return collide;
    }

    private void beginContact(long contactAddr) {
        this.contact.addr = contactAddr;
        if (this.contactListener != null) {
            this.contactListener.beginContact(this.contact);
        }
    }

    private void endContact(long contactAddr) {
        this.contact.addr = contactAddr;
        this.contact.GetWorldManifold();
        if (this.contactListener != null) {
            this.contactListener.endContact(this.contact);
        }
    }

    private boolean reportFixture(long addr) {
        if (this.queryCallback != null) {
            return this.queryCallback.reportFixture(this.fixtures.get(addr));
        }
        return false;
    }
}

