/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.MathUtils;
import java.util.Iterator;

public class LongHashMap<T> {
    public int size;
    Entry[] table;
    private float loadFactor;
    private int mask;
    private int capacity;
    private int threshold;
    private Entries entries;
    private Values values;
    private Keys keys;

    public LongHashMap() {
        this(16, 0.75f);
    }

    public LongHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        this.capacity = MathUtils.nextPowerOfTwo(initialCapacity);
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    public T put(long key, T value) {
        int index = (int)(key & (long)this.mask);
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.table[index] = new Entry<T>(key, value, this.table[index]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.capacity);
        }
        return null;
    }

    public T get(long key) {
        int index = (int)(key & (long)this.mask);
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Iterator entries() {
        if (this.entries == null) {
            this.entries = new Entries();
        } else {
            this.entries.reset();
        }
        return this.entries;
    }

    public Iterator values() {
        if (this.values == null) {
            this.values = new Values();
        } else {
            this.values.reset();
        }
        return this.values;
    }

    public Keys keys() {
        if (this.keys == null) {
            this.keys = new Keys();
        } else {
            this.keys.reset();
        }
        return this.keys;
    }

    public boolean containsValue(Object value) {
        Entry[] table = this.table;
        int i = table.length;
        while (i-- > 0) {
            Entry e = table[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        int index = (int)(key & (long)this.mask);
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public T remove(long key) {
        Entry prev;
        int index = (int)(key & (long)this.mask);
        Entry e = prev = this.table[index];
        while (e != null) {
            Entry next = e.next;
            if (e.key == key) {
                --this.size;
                if (prev == e) {
                    this.table[index] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    public void clear() {
        Entry[] table = this.table;
        int index = table.length;
        while (--index >= 0) {
            table[index] = null;
        }
        this.size = 0;
    }

    public void ensureCapacity(int additionalCapacity) {
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo(sizeNeeded));
        }
    }

    private void resize(int newSize) {
        Entry[] newTable = new Entry[newSize];
        Entry[] table = this.table;
        int bucketmask = newSize - 1;
        int i = 0;
        while (i < table.length) {
            Entry entry = table[i];
            if (entry != null) {
                Entry next;
                table[i] = null;
                do {
                    next = entry.next;
                    int index = (int)(entry.key & (long)bucketmask);
                    entry.next = newTable[index];
                    newTable[index] = entry;
                } while ((entry = next) != null);
            }
            ++i;
        }
        this.table = newTable;
        this.capacity = newSize;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = this.capacity - 1;
    }

    public String toString() {
        Entry e;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        Entry[] table = this.table;
        int i = table.length;
        while (i-- > 0) {
            e = table[i];
            if (e == null) continue;
            buffer.append(e.key);
            buffer.append('=');
            buffer.append(e.value);
            e = e.next;
            while (e != null) {
                buffer.append(", ");
                buffer.append(e.key);
                buffer.append('=');
                buffer.append(e.value);
                e = e.next;
            }
            break block0;
        }
        while (i-- > 0) {
            e = table[i];
            while (e != null) {
                buffer.append(", ");
                buffer.append(e.key);
                buffer.append('=');
                buffer.append(e.value);
                e = e.next;
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    class Entries
    implements Iterator {
        private int index = -1;
        Entry<T> entry = null;

        Entries() {
        }

        @Override
        public boolean hasNext() {
            if (this.entry != null && this.entry.next != null) {
                this.entry = this.entry.next;
                return true;
            }
            do {
                ++this.index;
                if (this.index < LongHashMap.this.table.length) continue;
                return false;
            } while (LongHashMap.this.table[this.index] == null);
            this.entry = LongHashMap.this.table[this.index];
            return true;
        }

        public Object next() {
            return this.entry;
        }

        @Override
        public void remove() {
            Entry prev;
            Entry e = prev = LongHashMap.this.table[this.index];
            while (e != null) {
                Entry next = e.next;
                if (e == this.entry) {
                    --LongHashMap.this.size;
                    if (prev == e) {
                        LongHashMap.this.table[this.index] = next;
                    } else {
                        prev.next = next;
                    }
                    return;
                }
                prev = e;
                e = next;
            }
        }

        void reset() {
            this.index = -1;
            this.entry = null;
        }
    }

    public static class Entry<T> {
        public final long key;
        public T value;
        Entry next;

        Entry(long k, T v, Entry n) {
            this.key = k;
            this.value = v;
            this.next = n;
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + this.value;
        }
    }

    class Keys {
        private int index = -1;
        Entry<T> entry = null;

        Keys() {
        }

        public boolean hasNext() {
            if (this.entry != null && this.entry.next != null) {
                this.entry = this.entry.next;
                return true;
            }
            do {
                ++this.index;
                if (this.index < LongHashMap.this.table.length) continue;
                return false;
            } while (LongHashMap.this.table[this.index] == null);
            this.entry = LongHashMap.this.table[this.index];
            return true;
        }

        public long next() {
            return this.entry.key;
        }

        public void remove() {
            Entry prev;
            Entry e = prev = LongHashMap.this.table[this.index];
            while (e != null) {
                Entry next = e.next;
                if (e == this.entry) {
                    --LongHashMap.this.size;
                    if (prev == e) {
                        LongHashMap.this.table[this.index] = next;
                    } else {
                        prev.next = next;
                    }
                    return;
                }
                prev = e;
                e = next;
            }
        }

        void reset() {
            this.index = -1;
            this.entry = null;
        }
    }

    class Values
    extends Entries {
        Values() {
        }

        public T next() {
            return this.entry.value;
        }
    }
}

