/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

public class MathUtils {
    public static final float PI = (float)Math.PI;
    private static final int SIN_BITS = 13;
    private static final int SIN_MASK = 8191;
    private static final int SIN_COUNT = 8192;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 1303.7972f;
    private static final float degToIndex = 22.755556f;
    public static final float radiansToDegrees = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float[] sin = new float[8192];
    public static final float[] cos = new float[8192];
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    private static final int ATAN2_DIM;
    private static final float INV_ATAN2_DIM_MINUS_1;
    private static final float[] atan2;
    private static int randomSeed;
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double BIG_ENOUGH_CEIL = 16384.5;

    static {
        int i = 0;
        while (i < 8192) {
            float a = ((float)i + 0.5f) / 8192.0f * ((float)Math.PI * 2);
            MathUtils.sin[i] = (float)Math.sin(a);
            MathUtils.cos[i] = (float)Math.cos(a);
            ++i;
        }
        ATAN2_DIM = (int)Math.sqrt(16384.0);
        INV_ATAN2_DIM_MINUS_1 = 1.0f / (float)(ATAN2_DIM - 1);
        atan2 = new float[16384];
        i = 0;
        while (i < ATAN2_DIM) {
            int j = 0;
            while (j < ATAN2_DIM) {
                float x0 = (float)i / (float)ATAN2_DIM;
                float y0 = (float)j / (float)ATAN2_DIM;
                MathUtils.atan2[j * MathUtils.ATAN2_DIM + i] = (float)Math.atan2(y0, x0);
                ++j;
            }
            ++i;
        }
        randomSeed = (int)System.currentTimeMillis();
    }

    public static final float sin(float rad) {
        return sin[(int)(rad * 1303.7972f) & 0x1FFF];
    }

    public static final float cos(float rad) {
        return cos[(int)(rad * 1303.7972f) & 0x1FFF];
    }

    public static final float sinDeg(float deg) {
        return sin[(int)(deg * 22.755556f) & 0x1FFF];
    }

    public static final float cosDeg(float deg) {
        return cos[(int)(deg * 22.755556f) & 0x1FFF];
    }

    public static final float atan2(float y, float x) {
        float add;
        float mul;
        if (x < 0.0f) {
            if (y < 0.0f) {
                y = -y;
                mul = 1.0f;
            } else {
                mul = -1.0f;
            }
            x = -x;
            add = (float)(-Math.PI);
        } else {
            if (y < 0.0f) {
                y = -y;
                mul = -1.0f;
            } else {
                mul = 1.0f;
            }
            add = 0.0f;
        }
        float invDiv = 1.0f / ((x < y ? y : x) * INV_ATAN2_DIM_MINUS_1);
        int xi = (int)(x * invDiv);
        int yi = (int)(y * invDiv);
        return (atan2[yi * ATAN2_DIM + xi] + add) * mul;
    }

    public static final int random(int range) {
        int seed;
        randomSeed = seed = randomSeed * 1103515245 + 12345;
        return (seed >>> 15) * (range + 1) >>> 17;
    }

    public static final int random(int start, int end) {
        int seed;
        randomSeed = seed = randomSeed * 1103515245 + 12345;
        return ((seed >>> 15) * (end - start + 1) >>> 17) + start;
    }

    public static final boolean randomBoolean() {
        int seed;
        randomSeed = seed = randomSeed * 1103515245 + 12345;
        return seed > 0;
    }

    public static final float random() {
        int seed;
        randomSeed = seed = randomSeed * 1103515245 + 12345;
        return (float)(seed >>> 8) * 1.0f / 1.6777216E7f;
    }

    public static final float random(float range) {
        int seed;
        randomSeed = seed = randomSeed * 1103515245 + 12345;
        return (float)(seed >>> 8) * 1.0f / 1.6777216E7f * range;
    }

    public static final float random(float start, float end) {
        int seed;
        randomSeed = seed = randomSeed * 1103515245 + 12345;
        return start + (float)(seed >>> 8) * 1.0f / 1.6777216E7f * (end - start);
    }

    public static int nextPowerOfTwo(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int floor(float x) {
        return (int)((double)x + 16384.0) - 16384;
    }

    public static int ceil(float x) {
        return (int)((double)x + 16384.5) - 16384;
    }
}

