/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.graphics.Typeface;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import com.e3roid.E3Engine;
import com.e3roid.E3Scene;
import com.e3roid.event.SceneEventListener;
import com.e3roid.event.SceneOnKeyListener;
import com.e3roid.opengl.RenderSurfaceView;

public abstract class E3Activity
extends Activity
implements SceneEventListener {
    public static final int ORIENTATION_LANDSCAPE = 0;
    public static final int ORIENTATION_PORTRAIT = 1;
    public static final int ORIENTATION_SQUARE = 2;
    public static final int ORIENTATION_UNDEFINED = 3;
    protected E3Engine engine;
    protected RenderSurfaceView surfaceView;
    protected boolean paused = false;
    protected boolean loaded = false;
    protected boolean focused = false;
    protected int[] viewLocation = new int[2];
    protected SceneOnKeyListener sceneOnKeyListener;
    protected boolean overrideOnKeyEvent = false;

    protected void onSetContentView() {
        this.surfaceView = this.onLoadSurfaceView();
        this.surfaceView.setRenderer(this.engine);
        this.setContentView((View)this.surfaceView, (ViewGroup.LayoutParams)this.onLayoutParams());
    }

    protected void onApplyEngineOptions() {
        this.applyScreenOrientation();
        if (this.engine.isFullScreen()) {
            this.requestFullScreen();
        }
    }

    protected RenderSurfaceView onLoadSurfaceView() {
        return new RenderSurfaceView((Context)this);
    }

    public RenderSurfaceView getView() {
        return this.surfaceView;
    }

    protected FrameLayout.LayoutParams onLayoutParams() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        return layoutParams;
    }

    protected void applyScreenOrientation() {
        if (this.engine.isScreenOrientationLandscape()) {
            this.setRequestedOrientation(0);
        } else if (this.engine.isScreenOrientationPortrait()) {
            this.setRequestedOrientation(1);
        }
    }

    protected void requestFullScreen() {
        Window window = this.getWindow();
        window.addFlags(1024);
        window.clearFlags(2048);
        window.requestFeature(1);
    }

    protected void pause() {
        this.paused = true;
        this.engine.onPause();
        this.surfaceView.onPause();
        this.onUserPaused();
    }

    protected void resume() {
        this.paused = false;
        if (!this.loaded) {
            this.onLoadResources();
            E3Scene scene = this.onLoadScene();
            this.engine.onLoadScene(scene);
            scene.onLoadEngine(this.engine);
            this.onLoadComplete();
            this.loaded = true;
        }
        this.engine.onResume();
        this.surfaceView.onResume();
        this.onUserResumed();
    }

    protected void dispose() {
        this.onUnloadResources();
        this.onUserDisposed();
        this.engine.onDispose();
        this.loaded = false;
        this.paused = false;
        this.focused = false;
    }

    public DisplayMetrics getDisplayMetrics() {
        DisplayMetrics metrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        return metrics;
    }

    public Typeface getTypeface(String path) {
        return Typeface.createFromAsset((AssetManager)this.getAssets(), (String)path);
    }

    public Context getContext() {
        return this;
    }

    public E3Engine getEngine() {
        return this.engine;
    }

    public int getWidth() {
        return this.engine.getWidth();
    }

    public int getHeight() {
        return this.engine.getHeight();
    }

    public void postUpdate(Runnable runnable) {
        this.engine.postUpdate(runnable);
    }

    public int getScreenOrientation() {
        Configuration config = this.getResources().getConfiguration();
        if (config.orientation == 2) {
            return 0;
        }
        if (config.orientation == 1) {
            return 1;
        }
        if (config.orientation == 3) {
            return 2;
        }
        return 3;
    }

    public int getTouchEventX(E3Scene scene, MotionEvent event) {
        return this.getTouchEventX(scene, event, 0);
    }

    public int getTouchEventX(E3Scene scene, MotionEvent event, int pointer) {
        this.surfaceView.getLocationOnScreen(this.viewLocation);
        return scene.getEventX(event, this.viewLocation[0], this.surfaceView.getMeasuredWidth(), pointer);
    }

    public int getTouchEventY(E3Scene scene, MotionEvent event) {
        return this.getTouchEventY(scene, event, 0);
    }

    public int getTouchEventY(E3Scene scene, MotionEvent event, int pointer) {
        this.surfaceView.getLocationOnScreen(this.viewLocation);
        return scene.getEventY(event, this.viewLocation[1], this.surfaceView.getMeasuredHeight(), pointer);
    }

    public boolean onKeyDown(E3Scene scene, int keyCode, KeyEvent event) {
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(E3Scene scene, int keyCode, KeyEvent event) {
        return super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(E3Scene scene, MotionEvent motionEvent) {
        return super.onTrackballEvent(motionEvent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.paused = true;
        this.engine = this.onLoadEngine();
        this.onApplyEngineOptions();
        this.onSetContentView();
    }

    protected void onResume() {
        super.onResume();
        if (this.paused && this.focused) {
            this.resume();
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus) {
            if (this.paused) {
                this.resume();
            }
        } else if (!this.paused) {
            this.pause();
        }
        this.focused = hasFocus;
    }

    protected void onPause() {
        super.onPause();
        if (!this.paused) {
            this.pause();
        }
    }

    protected void onDestroy() {
        this.dispose();
        super.onDestroy();
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean handled = false;
        if (this.engine != null) {
            handled = this.engine.onTouchEvent(event);
        }
        try {
            Thread.sleep(16L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handled;
    }

    public void setOnKeyListener(SceneOnKeyListener listener, boolean override) {
        this.overrideOnKeyEvent = override;
        this.sceneOnKeyListener = listener;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.sceneOnKeyListener != null) {
            boolean done = this.sceneOnKeyListener.onKeyDown(this.getEngine().getScene(), keyCode, event);
            if (this.overrideOnKeyEvent && done) {
                return done;
            }
        }
        return this.onKeyDown(this.getEngine().getScene(), keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean done;
        if (this.sceneOnKeyListener != null && (done = this.sceneOnKeyListener.onKeyUp(this.getEngine().getScene(), keyCode, event))) {
            return done;
        }
        return this.onKeyUp(this.getEngine().getScene(), keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return this.onTrackballEvent(this.getEngine().getScene(), motionEvent);
    }

    @Override
    public boolean onSceneTouchEvent(E3Scene scene, MotionEvent motionEvent) {
        return super.onTouchEvent(motionEvent);
    }

    public abstract E3Engine onLoadEngine();

    public abstract E3Scene onLoadScene();

    public abstract void onLoadResources();

    public void onUnloadResources() {
    }

    public void onLoadComplete() {
    }

    public void onUserPaused() {
    }

    public void onUserResumed() {
    }

    public void onUserDisposed() {
    }
}

