/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import com.e3roid.E3Activity;
import com.e3roid.E3Scene;
import com.e3roid.lifecycle.E3LifeCycle;
import com.e3roid.lifecycle.E3Service;
import com.e3roid.opengl.Camera;
import com.e3roid.opengl.GLHelper;
import com.e3roid.opengl.GLSurfaceView;
import com.e3roid.opengl.RenderSurfaceView;
import com.e3roid.util.Debug;
import com.e3roid.util.FPSCounter;
import com.e3roid.util.IntPair;
import java.util.ArrayList;
import java.util.HashMap;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.connectbot.service.TerminalManager;

public class E3Engine
implements E3LifeCycle,
GLSurfaceView.Renderer {
    public static final int REFRESH_DEFAULT = 0;
    public static final int REFRESH_LIMITED = 1;
    public static final int RESOLUTION_STRETCH_SCENE = 2;
    public static final int RESOLUTION_EXPAND_SCENE = 3;
    public static final int RESOLUTION_FIXED_RATIO = 4;
    public static final int RESOLUTION_EXACT = 5;
    public static final int RESOLUTION_FIXED_RATIO_WITH_ROTATION = 6;
    private final E3Activity context;
    private final DisplayMetrics displayMetrics;
    private E3Scene scene = null;
    private boolean fullScreen = false;
    private boolean screenOrientationLandscape = false;
    private boolean screenOrientationPortrait = false;
    private FPSCounter fpsCounter;
    private FPSCounter refreshFPSCounter;
    private Camera camera = new Camera();
    private boolean matrixChanged = false;
    private boolean useVBO = true;
    private boolean stopped = false;
    private TerminalManager terminalManager = null;
    private ArrayList<E3LifeCycle> lifeCycles = new ArrayList();
    protected ArrayList<Runnable> postedEvents = new ArrayList();
    protected HashMap<Long, Thread> services = new HashMap();
    private int refreshMode = 0;
    private int preferredFPS = 0;
    private int resolutionPolicy = 3;
    private int width;
    private int height;

    public E3Engine(E3Activity context, int width, int height) {
        this(context, width, height, 3);
    }

    public E3Engine(E3Activity context, int width, int height, int resolutionPolicy) {
        this.context = context;
        this.displayMetrics = context.getDisplayMetrics();
        this.resolutionPolicy = resolutionPolicy;
        this.updateResolution(width, height);
        this.initializeFPSCounter();
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        GLHelper.reset(gl);
        GLHelper.hintPerspectiveCorrectionAndNicest(gl);
        GLHelper.enableLighting(gl, false);
        GLHelper.enableDither(gl, false);
        GLHelper.enableMultiSample(gl, false);
        GLHelper.enableColorArray(gl, false);
        GLHelper.enableDepthTest(gl, false);
        GLHelper.enableTextures(gl, true);
        GLHelper.enableTexCoordArray(gl, true);
        GLHelper.enableBlend(gl, true);
        GLHelper.blendMode(gl, 770, 771);
        GLHelper.enableVertexArray(gl, true);
        GLHelper.enableCulling(gl, true);
        gl.glFrontFace(2305);
        gl.glCullFace(1029);
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int w, int h) {
        gl.glViewport(0, 0, w, h);
        this.updateResolution(this.width, this.height);
    }

    @Override
    public void onSurfaceLost() {
        this.fpsCounter.resetCount();
        this.refreshFPSCounter.resetCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDrawFrame(GL10 gl) {
        if (this.scene == null) {
            return;
        }
        if (this.stopped) {
            return;
        }
        if (this.matrixChanged) {
            this.camera.reloadMatrix(gl);
            this.matrixChanged = false;
        }
        this.refreshFPSCounter.onFrame();
        if (this.refreshMode == 1) {
            if (this.preferredFPS <= 0) {
                throw new IllegalArgumentException("preferredFPS must be set while refreshMode equals REFRESH_LIMITED.");
            }
            this.waitForFPS();
        }
        this.camera.look(gl);
        ArrayList<Runnable> arrayList = this.postedEvents;
        synchronized (arrayList) {
            if (!this.postedEvents.isEmpty()) {
                for (Runnable runnable : this.postedEvents) {
                    runnable.run();
                }
                this.postedEvents.clear();
            }
        }
        this.scene.onDraw(gl);
        this.fpsCounter.onFrame();
    }

    public void setSize(int width, int height) {
        this.setSize(width, height, this.resolutionPolicy);
    }

    public void setSize(int width, int height, int resolutionPolicy) {
        this.resolutionPolicy = resolutionPolicy;
        this.updateResolution(width, height);
    }

    public boolean isPerspective() {
        return this.camera.isPerspective();
    }

    public void enablePerspective(boolean enable) {
        this.enablePerspective(enable, true);
    }

    public void enablePerspective(boolean enable, boolean defaultLook) {
        if (this.isPerspective() == enable) {
            return;
        }
        this.camera.enablePerspective(enable);
        if (defaultLook) {
            this.camera.defaultLook();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postUpdate(Runnable runnable) {
        ArrayList<Runnable> arrayList = this.postedEvents;
        synchronized (arrayList) {
            this.postedEvents.add(runnable);
        }
    }

    protected void updateResolution(int w, int h) {
        IntPair dim = this.determineResolution(w, h);
        this.width = dim.getInt1();
        this.height = dim.getInt2();
        this.camera.setView(this.width, this.height);
        this.matrixChanged = true;
    }

    protected IntPair determineResolution(int w, int h) {
        float userAspect = (float)w / (float)h;
        float flipAspect = (float)h / (float)w;
        float realAspect = (float)this.displayMetrics.widthPixels / (float)this.displayMetrics.heightPixels;
        if (this.resolutionPolicy == 3) {
            if (realAspect != userAspect) {
                if (realAspect == flipAspect) {
                    return new IntPair(h, w);
                }
                if (realAspect < userAspect) {
                    h = (int)((float)w / realAspect);
                } else {
                    w = (int)((float)h * realAspect);
                }
            }
        } else if (this.resolutionPolicy == 6 && (realAspect < 1.0f && userAspect > 1.0f || realAspect > 1.0f && userAspect < 1.0f)) {
            int tmpHeight = h;
            h = w;
            w = tmpHeight;
        }
        return new IntPair(w, h);
    }

    public void onMeasure(RenderSurfaceView view, int widthMeasureSpec, int heightMeasureSpec) {
        float userAspect;
        if (this.resolutionPolicy == 5) {
            view.updateMeasuredDimension(this.width, this.height);
            return;
        }
        int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int specHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.resolutionPolicy == 4) {
            float realAspect = (float)specWidth / (float)specHeight;
            userAspect = (float)this.width / (float)this.height;
            if (realAspect < userAspect) {
                specHeight = Math.round((float)specWidth / userAspect);
            } else {
                specWidth = Math.round((float)specHeight * userAspect);
            }
        } else if (this.resolutionPolicy == 6) {
            userAspect = (float)this.width / (float)this.height;
            float realAspect = (float)specWidth / (float)specHeight;
            if (realAspect < 1.0f && userAspect > 1.0f || realAspect > 1.0f && userAspect < 1.0f) {
                userAspect = (float)this.height / (float)this.width;
            }
            if (realAspect < userAspect) {
                specHeight = Math.round((float)specWidth / userAspect);
            } else {
                specWidth = Math.round((float)specHeight * userAspect);
            }
        }
        IntPair spec = this.determineResolution(specWidth, specHeight);
        view.updateMeasuredDimension(spec.getInt1(), spec.getInt2());
    }

    private void waitForFPS() {
        try {
            if (this.refreshFPSCounter.getFPS() == 0.0f) {
                return;
            }
            if (this.refreshFPSCounter.getFrameCount() == 0) {
                return;
            }
            if (this.refreshFPSCounter.getFPS() > (float)this.preferredFPS) {
                float currentMSec = 1000.0f / this.refreshFPSCounter.getFPS();
                float preferredMSec = 1000.0f / (float)this.preferredFPS;
                float waitMsec = preferredMSec - currentMSec;
                Thread.sleep((long)waitMsec * (long)this.refreshFPSCounter.getFrameCount());
            } else {
                this.refreshFPSCounter.resetCount();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initializeFPSCounter() {
        this.fpsCounter = new FPSCounter();
        this.refreshFPSCounter = new FPSCounter();
        this.lifeCycles.add(this.fpsCounter);
        this.lifeCycles.add(this.refreshFPSCounter);
    }

    @Override
    public void onResume() {
        for (E3LifeCycle lifeCycle : this.lifeCycles) {
            lifeCycle.onResume();
        }
    }

    @Override
    public void onPause() {
        for (E3LifeCycle lifeCycle : this.lifeCycles) {
            lifeCycle.onPause();
        }
    }

    @Override
    public void onDispose() {
        for (E3LifeCycle lifeCycle : this.lifeCycles) {
            lifeCycle.onDispose();
        }
    }

    public void onLoadScene(E3Scene scene) {
        this.scene = scene;
        this.lifeCycles.add(scene);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.scene != null) {
            return this.scene.onTouchEvent(event);
        }
        return false;
    }

    public void requestFullScreen() {
        this.fullScreen = true;
    }

    public void requestLandscape() {
        this.screenOrientationLandscape = true;
        this.screenOrientationPortrait = false;
    }

    public void requestPortrait() {
        this.screenOrientationLandscape = false;
        this.screenOrientationPortrait = true;
    }

    public void setRefreshMode(int mode) {
        this.refreshMode = mode;
    }

    public void setPreferredFPS(int fps) {
        this.preferredFPS = fps;
    }

    public FPSCounter getFPSCounter() {
        return this.fpsCounter;
    }

    public E3Activity getContext() {
        return this.context;
    }

    public E3Scene getScene() {
        return this.scene;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.displayMetrics;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public boolean isScreenOrientationLandscape() {
        return this.screenOrientationLandscape;
    }

    public boolean isScreenOrientationPortrait() {
        return this.screenOrientationPortrait;
    }

    public void enableVBO(boolean enable) {
        this.useVBO = enable;
    }

    public boolean useVBO() {
        return this.useVBO;
    }

    public void stop() {
        this.stopped = true;
    }

    public void start() {
        this.stopped = false;
    }

    public long registerService(E3Service service) {
        Thread thc;
        long serviceId = service.getId();
        if (this.services.containsKey(serviceId) && (thc = this.services.get(serviceId)) != null && thc.isAlive()) {
            Debug.d(String.format("Requested service is already started: id=%d", service.getId()));
            return service.getId();
        }
        Thread th = new Thread(service);
        th.start();
        long id = th.getId();
        service.setId(id);
        this.services.put(id, th);
        this.lifeCycles.add(service);
        return id;
    }

    public boolean unregisterService(E3Service service) {
        long serviceId = service.getId();
        if (this.services.containsKey(serviceId)) {
            Thread th = this.services.get(serviceId);
            if (th.isAlive()) {
                th.interrupt();
            }
            this.services.remove(serviceId);
            service.onDispose();
            if (this.lifeCycles.contains(service)) {
                this.lifeCycles.remove(service);
            }
            return true;
        }
        return false;
    }

    public TerminalManager getTerminalManager(Context context) {
        if (this.terminalManager == null) {
            this.terminalManager = new TerminalManager(context);
            this.addLifeCycle(this.terminalManager);
        }
        return this.terminalManager;
    }

    public boolean addLifeCycle(E3LifeCycle lifeCycle) {
        if (this.lifeCycles.contains(lifeCycle)) {
            return false;
        }
        return this.lifeCycles.add(lifeCycle);
    }

    public boolean removeLifeCycle(E3LifeCycle lifeCycle) {
        return this.lifeCycles.remove(lifeCycle);
    }
}

