/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid;

import android.os.SystemClock;
import android.view.MotionEvent;
import com.e3roid.E3Engine;
import com.e3roid.drawable.Drawable;
import com.e3roid.drawable.Layer;
import com.e3roid.drawable.Menu;
import com.e3roid.drawable.Shape;
import com.e3roid.event.FrameListener;
import com.e3roid.event.SceneEventListener;
import com.e3roid.event.SceneUpdateListener;
import com.e3roid.lifecycle.E3LifeCycle;
import com.e3roid.opengl.GLHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.microedition.khronos.opengles.GL10;

public class E3Scene
implements E3LifeCycle {
    protected static final String MENU_LAYER = "com.e3roid.drawable.Menu";
    protected E3Engine engine;
    protected Layer backgroundLayer = new Layer();
    protected ArrayList<Layer> layers = new ArrayList();
    protected ArrayList<Layer> removedLayers = new ArrayList();
    protected ArrayList<Layer> loadableLayers = new ArrayList();
    protected ArrayList<Shape> huds = new ArrayList();
    protected ArrayList<Shape> removedHuds = new ArrayList();
    protected ArrayList<Shape> loadableHuds = new ArrayList();
    protected ArrayList<SceneEventListener> eventListeners = new ArrayList();
    protected HashMap<SceneUpdateListener, UpdateHandler> updateListeners = new HashMap();
    protected HashMap<String, Layer> namedLayers = new HashMap();
    protected ArrayList<FrameListener> frameListeners = new ArrayList();
    protected long lastUpdateMsec = 0L;
    protected long updateIntervalMsec = 0L;
    protected long pausedTimeElapsed = 0L;
    protected String currentLayerName;
    protected boolean paused = false;
    protected boolean reloadScene = false;
    protected boolean reloadHUD = false;
    protected float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public E3Scene() {
        this.addLayer(this.backgroundLayer);
    }

    public void onDraw(GL10 gl) {
        if (!this.frameListeners.isEmpty()) {
            for (FrameListener frameListener : this.frameListeners) {
                frameListener.beforeOnDraw(this, gl);
            }
        }
        if (!this.loadableLayers.isEmpty()) {
            for (Layer layer : this.loadableLayers) {
                layer.onLoadEngine(this.engine);
                layer.onLoadSurface(gl);
                this.layers.add(layer);
            }
            this.loadableLayers.clear();
        }
        if (!this.loadableHuds.isEmpty()) {
            for (Shape shape : this.loadableHuds) {
                shape.onLoadEngine(this.engine);
                shape.onLoadSurface(gl);
                this.huds.add(shape);
            }
            this.loadableHuds.clear();
        }
        if (this.reloadScene && this.reloadHUD) {
            for (Shape shape : this.huds) {
                shape.onLoadSurface(gl, true);
            }
            this.reloadScene = false;
            this.reloadHUD = false;
        }
        if (this.currentLayerName != null && this.namedLayers.containsKey(this.currentLayerName)) {
            this.prepareDraw(gl);
            Layer layer = this.namedLayers.get(this.currentLayerName);
            if (layer != null) {
                if (!layer.isLoaded() && !layer.isEngineLoaded()) {
                    layer.onLoadEngine(this.engine);
                    layer.onLoadSurface(gl);
                }
                if (!layer.isRemoved()) {
                    layer.onDraw(gl);
                } else {
                    this.namedLayers.remove(layer);
                }
            }
        } else if (!this.paused) {
            this.prepareDraw(gl);
            if (this.updateIntervalMsec > 0L && SystemClock.uptimeMillis() - this.lastUpdateMsec > this.updateIntervalMsec) {
                for (SceneUpdateListener sceneUpdateListener : this.updateListeners.keySet()) {
                    long now;
                    long elapsed;
                    UpdateHandler handler = this.updateListeners.get(sceneUpdateListener);
                    if (handler.interval() <= 0 || (elapsed = handler.elapsed(now = SystemClock.uptimeMillis())) <= (long)handler.interval()) continue;
                    sceneUpdateListener.onUpdateScene(this, elapsed);
                    handler.update(now);
                }
                this.lastUpdateMsec = SystemClock.uptimeMillis();
            }
            for (Layer layer : this.layers) {
                layer.onDraw(gl);
            }
            GLHelper.switchToProjectionMatrix(gl, true);
            this.engine.getCamera().switchToOrtho(gl);
            this.engine.getCamera().lookAtOrthoCenter(gl);
            GLHelper.switchToModelViewMatrix(gl, true);
            for (Shape shape : this.huds) {
                shape.onDraw(gl);
            }
        }
        if (!this.removedLayers.isEmpty()) {
            for (Layer layer : this.removedLayers) {
                layer.onDispose();
                this.layers.remove(layer);
            }
            this.removedLayers.clear();
        }
        if (!this.removedHuds.isEmpty()) {
            for (Shape shape : this.removedHuds) {
                shape.onDispose();
                this.huds.remove(shape);
            }
            this.removedHuds.clear();
        }
        if (!this.frameListeners.isEmpty()) {
            for (FrameListener frameListener : this.frameListeners) {
                frameListener.afterOnDraw(this, gl);
            }
        }
    }

    protected void prepareDraw(GL10 gl) {
        gl.glClearDepthf(1.0f);
        gl.glClear(16640);
        GLHelper.clearColor(gl, this.color[0], this.color[1], this.color[2], this.color[3]);
        GLHelper.switchToModelViewMatrix(gl);
    }

    public void resume() {
        for (Layer layer : this.layers) {
            layer.onResume();
        }
        for (Shape hud : this.huds) {
            hud.onResume();
        }
        for (Layer layer : this.namedLayers.values()) {
            layer.onResume();
        }
        this.lastUpdateMsec = SystemClock.uptimeMillis() - this.pausedTimeElapsed;
        this.paused = false;
    }

    public void pause() {
        for (Layer layer : this.layers) {
            layer.onPause();
        }
        for (Shape hud : this.huds) {
            hud.onPause();
        }
        for (Layer layer : this.namedLayers.values()) {
            layer.onPause();
        }
        this.pausedTimeElapsed = SystemClock.uptimeMillis() - this.lastUpdateMsec;
        this.paused = true;
    }

    public void forceReloadScene() {
        this.reloadScene = true;
        this.reloadLayers();
    }

    protected void reloadLayers() {
        if (this.reloadScene) {
            for (Layer layer : this.layers) {
                layer.setLoaded(false);
            }
            for (Layer layer : this.namedLayers.values()) {
                layer.setLoaded(false);
            }
            this.reloadHUD = true;
        }
    }

    @Override
    public void onResume() {
        this.reloadLayers();
    }

    @Override
    public void onPause() {
        this.reloadScene = true;
    }

    @Override
    public void onDispose() {
        for (Layer layer : this.layers) {
            layer.onDispose();
        }
        for (Shape hud : this.huds) {
            hud.onDispose();
        }
        for (Layer layer : this.namedLayers.values()) {
            layer.onDispose();
        }
    }

    public void addLayer(Layer layer) {
        this.loadableLayers.add(layer);
    }

    public void removeLayer(Layer layer) {
        layer.onRemove();
        this.removedLayers.add(layer);
    }

    public void addNamedLayer(String name, Layer layer) {
        this.namedLayers.put(name, layer);
    }

    public void removeNamedLayer(String name) {
        Layer layer = this.namedLayers.get(name);
        if (layer != null) {
            layer.onRemove();
        }
    }

    public void setCurrentLayerName(String name) {
        this.currentLayerName = name;
    }

    public void showMenu() {
        this.setCurrentLayerName(MENU_LAYER);
    }

    public void hideMenu() {
        this.resetNamedLayer();
    }

    public boolean isMenuVisible() {
        return MENU_LAYER.equals(this.getCurrentLayerName());
    }

    public String getCurrentLayerName() {
        return this.currentLayerName;
    }

    public void resetNamedLayer() {
        this.currentLayerName = null;
    }

    public Layer getBackgroundLayer() {
        return this.backgroundLayer;
    }

    public Layer getTopLayer() {
        if (this.layers.size() == 0) {
            return this.backgroundLayer;
        }
        return this.layers.get(this.layers.size() - 1);
    }

    public void addHUD(Shape shape) {
        this.loadableHuds.add(shape);
    }

    public void removeHUD(Shape shape) {
        shape.onRemove();
        this.removedHuds.add(shape);
    }

    public void setBackgroundColor(float red, float green, float blue, float alpha) {
        this.color[0] = red;
        this.color[1] = green;
        this.color[2] = blue;
        this.color[3] = alpha;
    }

    public void setBackgroundColor(float red, float green, float blue) {
        this.setBackgroundColor(red, green, blue, this.color[3]);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean handled = false;
        for (SceneEventListener listener : this.eventListeners) {
            handled = listener.onSceneTouchEvent(this, event);
            if (handled) break;
        }
        return handled;
    }

    public Drawable findDrawableAt(int x, int y) {
        for (Layer layer : this.layers) {
            Drawable drawable = layer.findDrawableAt(x, y);
            if (drawable == null) continue;
            return drawable;
        }
        return null;
    }

    public List<Drawable> findDrawablesAt(int x, int y) {
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        for (Layer layer : this.layers) {
            drawables.addAll(layer.findDrawablesAt(x, y));
        }
        return drawables;
    }

    public void onLoadEngine(E3Engine engine) {
        this.engine = engine;
    }

    public E3Engine getEngine() {
        return this.engine;
    }

    public int getWidth() {
        return this.engine.getWidth();
    }

    public int getHeight() {
        return this.engine.getHeight();
    }

    public int getEventX(MotionEvent event, int viewLocationX, float measuredWidth) {
        return this.getEventX(event, viewLocationX, measuredWidth, 0);
    }

    public int getEventX(MotionEvent event, int viewLocationX, float measuredWidth, int pointer) {
        float x = event.getX(pointer) - (float)viewLocationX;
        return (int)(x * ((float)this.engine.getWidth() / measuredWidth));
    }

    public int getEventY(MotionEvent event, int viewLocationY, float measuredHeight) {
        return this.getEventY(event, viewLocationY, measuredHeight, 0);
    }

    public int getEventY(MotionEvent event, int viewLocationY, float measuredHeight, int pointer) {
        float y = event.getY(pointer) - (float)viewLocationY;
        return (int)(y * ((float)this.engine.getHeight() / measuredHeight));
    }

    public void addEventListener(SceneEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeEventListener(SceneEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public void addMenu(Menu menuItem) {
        Layer layer = this.namedLayers.get(MENU_LAYER);
        if (layer == null) {
            layer = new Layer();
        }
        layer.add(menuItem);
        this.addNamedLayer(MENU_LAYER, layer);
    }

    public void removeMenu(Menu menuItem) {
        Layer layer = this.namedLayers.get(MENU_LAYER);
        if (layer != null) {
            layer.remove(menuItem);
            if (layer.size() == 0) {
                this.removeNamedLayer(MENU_LAYER);
            }
        }
    }

    public void addFrameListener(FrameListener listener) {
        this.frameListeners.add(listener);
    }

    public void removeFrameListener(FrameListener listener) {
        this.frameListeners.remove(listener);
    }

    public List<Shape> getHUDs() {
        return this.huds;
    }

    public void registerUpdateListener(int intervalMsec, SceneUpdateListener listener) {
        UpdateHandler handler = new UpdateHandler(intervalMsec);
        this.updateListeners.put(listener, handler);
        int interval = intervalMsec > 100 ? intervalMsec / 100 : 1;
        this.updateIntervalMsec = this.updateIntervalMsec == 0L ? (long)interval : Math.min(this.updateIntervalMsec, (long)interval);
    }

    public void unregisterUpdateListener(SceneUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    class UpdateHandler {
        private int intervalMsec = 0;
        private long lastTimeMillis = SystemClock.uptimeMillis();

        UpdateHandler(int interval) {
            this.intervalMsec = interval;
        }

        int interval() {
            return this.intervalMsec;
        }

        void update(long msec) {
            this.lastTimeMillis = msec;
        }

        long elapsed(long msec) {
            return msec - this.lastTimeMillis;
        }

        void reset() {
            this.lastTimeMillis = 0L;
        }
    }
}

