/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.audio;

import android.media.AudioRecord;
import com.e3roid.audio.AudioInputListener;
import com.e3roid.lifecycle.E3Service;
import com.e3roid.util.Debug;
import java.io.ByteArrayInputStream;

public class AudioInputService
extends E3Service {
    protected boolean canceled = false;
    protected boolean recording = false;
    protected AudioRecord recorder;
    protected final int readBufferSize;
    protected final byte[] readBuffer;
    protected final int audioSource;
    protected final int sampleRateInHz;
    protected final int channelConfig;
    protected final int audioFormat;
    protected AudioInputListener audioInputListener;

    public AudioInputService(int audioSource, int sampleRateInHz, int channelConfig, int audioFormat, AudioInputListener listener) {
        this(audioSource, sampleRateInHz, channelConfig, audioFormat, AudioInputService.getMinBufferSize(sampleRateInHz, channelConfig, audioFormat), listener);
    }

    public AudioInputService(int audioSource, int sampleRateInHz, int channelConfig, int audioFormat, int readBufferSize, AudioInputListener listener) {
        this.readBufferSize = readBufferSize;
        this.readBuffer = new byte[readBufferSize];
        this.audioSource = audioSource;
        this.sampleRateInHz = sampleRateInHz;
        this.channelConfig = channelConfig;
        this.audioFormat = audioFormat;
        this.audioInputListener = listener;
    }

    protected static int getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) {
        if (audioFormat == 3) {
            return 4096;
        }
        return AudioRecord.getMinBufferSize((int)sampleRateInHz, (int)channelConfig, (int)audioFormat) * 2;
    }

    protected AudioRecord createRecorder() {
        return new AudioRecord(this.audioSource, this.sampleRateInHz, this.channelConfig, this.audioFormat, this.readBufferSize);
    }

    @Override
    public void run() {
        try {
            this.recording = true;
            this.canceled = false;
            if (this.recorder == null || this.recorder.getState() != 1) {
                this.recorder = this.createRecorder();
            }
            this.recorder.startRecording();
            while (!this.canceled) {
                this.recorder.read(this.readBuffer, 0, this.readBufferSize);
                if (this.audioInputListener == null) continue;
                this.audioInputListener.onReadAudioInput(this, this.readBuffer);
            }
        }
        finally {
            this.onStop();
        }
    }

    public void setAudioInputListener(AudioInputListener listener) {
        this.audioInputListener = listener;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public synchronized void requestStop() {
        this.canceled = true;
    }

    public synchronized void onStop() {
        try {
            try {
                if (this.recording && this.recorder.getState() == 1) {
                    this.recorder.stop();
                    this.recorder.release();
                }
            }
            catch (Exception e) {
                Debug.e(e);
                this.recording = false;
                this.canceled = true;
            }
        }
        finally {
            this.recording = false;
            this.canceled = true;
        }
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onPause() {
        this.requestStop();
    }

    @Override
    public void onDispose() {
        this.onStop();
    }

    public boolean isRecording() {
        return this.recording;
    }

    public static double readAs16bitWave(ByteArrayInputStream bin) {
        byte b1 = (byte)bin.read();
        byte b2 = (byte)bin.read();
        return (double)(b2 << 8 | b1 & 0xFF) / 32767.0;
    }

    public static double readAs8bitWave(ByteArrayInputStream bin) {
        byte b = (byte)bin.read();
        return (double)(b - 128 << 8) / 32767.0;
    }
}

