/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable;

import android.content.Context;
import android.graphics.Bitmap;
import com.e3roid.drawable.Sprite;
import com.e3roid.drawable.texture.BitmapTexture;
import com.e3roid.drawable.texture.Texture;
import com.e3roid.drawable.texture.TiledTexture;

public class Background
extends Sprite {
    public Background(TiledTexture texture) {
        super(texture, 0, 0, texture.getTileWidth(), texture.getTileHeight());
    }

    public Background(Bitmap tile, int width, int height, Context context) {
        this(tile, width, height, BitmapTexture.TileOption.FILL, context);
    }

    public Background(Bitmap tile, int width, int height, BitmapTexture.TileOption tileOption, Context context) {
        this(tile, width, height, BitmapTexture.TileOption.FILL, Texture.Option.DEFAULT, context);
    }

    public Background(Bitmap tile, int width, int height, BitmapTexture.TileOption tileOption, Texture.Option textureOption, Context context) {
        BitmapTexture texture = BitmapTexture.createTextureFromTile(tile, width, height, tileOption, context);
        texture.recycleBitmap(false);
        texture.setOption(textureOption);
        this.setPosition(0, 0);
        this.setSize(width, height);
        this.useDefaultRotationAndScaleCenter();
        this.updateTexture(texture);
        this.createBuffers();
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }
}

