/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable;

import android.view.MotionEvent;
import com.e3roid.E3Engine;
import com.e3roid.E3Scene;
import com.e3roid.drawable.Background;
import com.e3roid.drawable.Drawable;
import com.e3roid.event.SceneEventListener;
import com.e3roid.opengl.GLHelper;
import java.util.ArrayList;
import java.util.List;
import javax.microedition.khronos.opengles.GL10;

public class Layer
implements Drawable,
SceneEventListener {
    private ArrayList<Drawable> drawables = new ArrayList();
    private ArrayList<Drawable> removedDrawables = new ArrayList();
    private ArrayList<Drawable> loadableDrawables = new ArrayList();
    private boolean removed = false;
    private boolean loaded = false;
    private E3Engine engine;
    private int[] translate = new int[3];

    @Override
    public void onDraw(GL10 gl) {
        if (!this.loadableDrawables.isEmpty()) {
            for (Drawable drawable : this.loadableDrawables) {
                drawable.onLoadEngine(this.engine);
                drawable.onLoadSurface(gl);
                if (drawable instanceof Background) {
                    if (this.drawables.size() > 0 && this.drawables.get(0) instanceof Background) {
                        if (this.drawables.get(0).equals(drawable)) {
                            ((Background)drawable).show();
                            continue;
                        }
                        if (this.drawables.contains(drawable)) {
                            ((Background)drawable).show();
                            continue;
                        }
                        ((Background)this.drawables.get(0)).hide();
                        this.drawables.add(0, drawable);
                        continue;
                    }
                    this.drawables.add(0, drawable);
                    continue;
                }
                this.drawables.add(drawable);
            }
            this.loadableDrawables.clear();
        }
        if (!this.isLoaded()) {
            for (Drawable drawable : this.drawables) {
                drawable.onLoadSurface(gl, true);
            }
            this.setLoaded(true);
        }
        GLHelper.switchToProjectionMatrix(gl);
        gl.glTranslatef((float)this.translate[0], (float)this.translate[1], (float)this.translate[2]);
        GLHelper.switchToModelViewMatrix(gl);
        for (Drawable drawable : this.drawables) {
            drawable.onDraw(gl);
        }
        if (!this.removedDrawables.isEmpty()) {
            for (Drawable drawable : this.removedDrawables) {
                this.drawables.remove(drawable);
                drawable.onDispose();
            }
            this.removedDrawables.clear();
        }
    }

    public int getX() {
        return this.translate[0];
    }

    public int getY() {
        return this.translate[1];
    }

    public int getZ() {
        return this.translate[2];
    }

    public void moveX(int x) {
        this.translate[0] = x;
    }

    public void moveY(int y) {
        this.translate[1] = y;
    }

    public void moveZ(int z) {
        this.translate[2] = z;
    }

    public void moveReset() {
        this.translate[0] = 0;
        this.translate[1] = 0;
        this.translate[2] = 0;
    }

    public void translate(int x, int y, int z) {
        this.translate[0] = x;
        this.translate[1] = y;
        this.translate[2] = z;
    }

    public void setBackground(Background drawable) {
        this.loadableDrawables.add(0, drawable);
    }

    public void add(Drawable drawable) {
        if (this.drawables.contains(drawable)) {
            return;
        }
        this.loadableDrawables.add(drawable);
    }

    public void remove(Drawable drawable) {
        drawable.onRemove();
        this.removedDrawables.add(drawable);
    }

    @Override
    public void onResume() {
        for (Drawable drawable : this.drawables) {
            drawable.onResume();
        }
    }

    @Override
    public void onPause() {
        for (Drawable drawable : this.drawables) {
            drawable.onPause();
        }
    }

    @Override
    public void onLoadSurface(GL10 gl) {
        this.onLoadSurface(gl, false);
    }

    @Override
    public void onLoadSurface(GL10 gl, boolean force) {
        this.loaded = true;
    }

    @Override
    public void onDispose() {
        for (Drawable drawable : this.drawables) {
            drawable.onDispose();
        }
    }

    @Override
    public void onLoadEngine(E3Engine engine) {
        this.engine = engine;
    }

    @Override
    public void onRemove() {
        for (Drawable drawable : this.drawables) {
            this.remove(drawable);
        }
        this.removed = true;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean isEngineLoaded() {
        return this.engine != null;
    }

    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    public void setDrawables(ArrayList<Drawable> drawables) {
        this.drawables = drawables;
    }

    public Drawable findDrawableAt(int x, int y) {
        for (Drawable drawable : this.drawables) {
            if (!drawable.contains(x, y)) continue;
            return drawable;
        }
        return null;
    }

    public List<Drawable> findDrawablesAt(int x, int y) {
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        for (Drawable drawable : drawables) {
            if (!drawable.contains(x, y)) continue;
            drawables.add(drawable);
        }
        return drawables;
    }

    public int size() {
        return this.drawables.size();
    }

    @Override
    public boolean onSceneTouchEvent(E3Scene scene, MotionEvent motionEvent) {
        return false;
    }
}

