/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable;

import com.e3roid.E3Activity;
import com.e3roid.E3Engine;
import com.e3roid.drawable.Drawable;
import com.e3roid.drawable.Sprite;
import java.util.ArrayList;
import javax.microedition.khronos.opengles.GL10;

public class Menu
implements Drawable {
    private ArrayList<Sprite> menuItems = new ArrayList();
    private ArrayList<Sprite> removedItems = new ArrayList();
    private ArrayList<Sprite> loadableItems = new ArrayList();
    private E3Engine engine;
    private boolean removed = false;
    private int totalHeight = 0;
    private int totalWidth = 0;

    public void add(Sprite menuItem) {
        this.loadableItems.add(menuItem);
        this.totalHeight += menuItem.getHeight();
        this.totalWidth += menuItem.getWidth();
    }

    public void remove(Sprite menuItem) {
        this.removedItems.add(menuItem);
        this.totalHeight -= menuItem.getHeight();
        this.totalWidth -= menuItem.getWidth();
    }

    public void layoutVerticalCenter(E3Activity context) {
        int startY = (context.getHeight() - this.totalHeight) / 2;
        startY = this.moveVerticalCenter(this.menuItems, startY, context);
        startY = this.moveVerticalCenter(this.loadableItems, startY, context);
    }

    private int moveVerticalCenter(ArrayList<Sprite> items, int startY, E3Activity context) {
        for (Sprite menuItem : items) {
            menuItem.move((context.getWidth() - menuItem.getWidth()) / 2, startY);
            startY += menuItem.getHeight();
        }
        return startY;
    }

    public void layoutHorizontalCenter(E3Activity context) {
        int startX = (context.getWidth() - this.totalWidth) / 2;
        startX = this.moveHorizontalCenter(this.menuItems, startX, context);
        startX = this.moveHorizontalCenter(this.loadableItems, startX, context);
    }

    private int moveHorizontalCenter(ArrayList<Sprite> items, int startX, E3Activity context) {
        for (Sprite menuItem : items) {
            menuItem.move(startX, (context.getHeight() - menuItem.getHeight()) / 2);
            startX += menuItem.getWidth();
        }
        return startX;
    }

    @Override
    public void onResume() {
        for (Sprite menuItem : this.menuItems) {
            menuItem.onResume();
        }
    }

    @Override
    public void onPause() {
        for (Sprite menuItem : this.menuItems) {
            menuItem.onPause();
        }
    }

    @Override
    public void onDispose() {
        for (Sprite menuItem : this.menuItems) {
            menuItem.onDispose();
        }
    }

    @Override
    public void onDraw(GL10 gl) {
        if (!this.loadableItems.isEmpty()) {
            for (Sprite menuItem : this.loadableItems) {
                menuItem.onLoadEngine(this.engine);
                menuItem.onLoadSurface(gl);
                this.menuItems.add(menuItem);
            }
            this.loadableItems.clear();
        }
        for (Sprite menuItem : this.menuItems) {
            menuItem.onDraw(gl);
        }
        if (!this.removedItems.isEmpty()) {
            for (Sprite menuItem : this.removedItems) {
                this.menuItems.remove(menuItem);
                menuItem.onDispose();
            }
            this.removedItems.clear();
        }
    }

    @Override
    public void onRemove() {
        this.removed = true;
    }

    @Override
    public void onLoadSurface(GL10 gl) {
        this.onLoadSurface(gl, false);
    }

    @Override
    public void onLoadSurface(GL10 gl, boolean force) {
        if (force) {
            for (Sprite menuItem : this.menuItems) {
                menuItem.onLoadSurface(gl, true);
            }
        }
    }

    @Override
    public void onLoadEngine(E3Engine engine) {
        this.engine = engine;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }
}

