/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable;

import android.graphics.Rect;
import android.view.MotionEvent;
import com.e3roid.E3Engine;
import com.e3roid.E3Scene;
import com.e3roid.drawable.Drawable;
import com.e3roid.drawable.modifier.ShapeModifier;
import com.e3roid.event.ModifierEventListener;
import com.e3roid.event.SceneEventListener;
import com.e3roid.event.ShapeEventListener;
import com.e3roid.opengl.FastFloatBuffer;
import com.e3roid.opengl.GLHelper;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11;

public class Shape
implements Drawable,
ShapeEventListener,
SceneEventListener,
ModifierEventListener {
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 2;
    protected int width = 0;
    protected int height = 0;
    protected boolean removed = false;
    protected boolean loaded = false;
    protected boolean visible = true;
    protected int x = 0;
    protected int y = 0;
    protected int z = 0;
    protected FastFloatBuffer vertexBuffer;
    protected ShortBuffer indiceBuffer;
    protected static final int RECTANGLE_POINTS = 4;
    protected static final short[] RECTANGLE_INDICE;
    protected final int[] GENERATED_HARDWAREID = new int[2];
    protected boolean useVBO = true;
    protected Rect rect = new Rect();
    protected ArrayList<ShapeEventListener> listeners = new ArrayList();
    protected ArrayList<ShapeModifier> modifiers = new ArrayList();
    protected ArrayList<ShapeModifier> loadableModifiers = new ArrayList();
    protected ArrayList<ShapeModifier> removedModifiers = new ArrayList();
    protected ArrayList<Shape> children = new ArrayList();
    protected float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected float[] translateParams = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] rotateParams = new float[]{0.0f, 0.0f, 0.0f, 2.0f};
    protected float[] scaleParams = new float[]{1.0f, 1.0f, 0.0f, 0.0f};
    protected float[] rotateCenter = new float[]{0.0f, 0.0f};
    protected float[] scaleCenter = new float[]{0.0f, 0.0f};

    static {
        short[] sArray = new short[4];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[3] = 3;
        RECTANGLE_INDICE = sArray;
    }

    public Shape() {
    }

    public Shape(int x, int y, int w, int h) {
        this.setPosition(x, y);
        this.setSize(w, h);
        this.useDefaultRotationAndScaleCenter();
        this.createBuffers();
    }

    @Override
    public void onLoadSurface(GL10 _gl) {
        this.onLoadSurface(_gl, false);
    }

    @Override
    public void onLoadSurface(GL10 _gl, boolean force) {
        GL11 gl = (GL11)_gl;
        if (!force && this.isLoaded()) {
            return;
        }
        if (force && this.isLoaded()) {
            this.unloadBuffer(gl);
        }
        for (Shape child : this.children) {
            child.onLoadSurface(_gl, force);
        }
        if (this.useVBO) {
            gl.glGenBuffers(this.GENERATED_HARDWAREID.length, this.GENERATED_HARDWAREID, 0);
        }
        this.loadVertexBuffer(gl);
        this.setLoaded(true);
    }

    protected void loadVertexBuffer(GL11 gl) {
        if (this.useVBO) {
            GLHelper.bindBuffer(gl, this.GENERATED_HARDWAREID[0]);
            GLHelper.bufferFloatData(gl, this.vertexBuffer.capacity(), this.vertexBuffer, 35044);
            GLHelper.bindElementBuffer(gl, this.GENERATED_HARDWAREID[1]);
            GLHelper.bufferElementShortData(gl, RECTANGLE_INDICE.length, this.indiceBuffer, 35044);
        }
    }

    protected void processModifiers(GL10 gl) {
        if (!this.loadableModifiers.isEmpty()) {
            for (ShapeModifier modifier : this.loadableModifiers) {
                modifier.onLoad(this, gl);
                this.modifiers.add(modifier);
            }
            this.loadableModifiers.clear();
        }
        if (!this.removedModifiers.isEmpty()) {
            for (ShapeModifier modifier : this.removedModifiers) {
                modifier.onUnload(this, gl);
                this.modifiers.remove(modifier);
            }
            this.removedModifiers.clear();
        }
        if (this.isRemoved() && !this.modifiers.isEmpty()) {
            for (ShapeModifier modifier : this.modifiers) {
                modifier.onUnload(this, gl);
            }
            this.modifiers.clear();
        }
    }

    protected void processBeforeModifiers(GL10 gl) {
        for (ShapeModifier modifier : this.modifiers) {
            modifier.onBeforeUpdate(this, gl);
        }
    }

    protected void processAfterModifiers(GL10 gl) {
        for (ShapeModifier modifier : this.modifiers) {
            modifier.onAfterUpdate(this, gl);
        }
    }

    protected void checkGLError(GL10 gl) {
        int error = gl.glGetError();
        if (error != 0) {
            throw new RuntimeException("GLError 0x" + Integer.toHexString(error));
        }
    }

    protected void unloadBuffer(GL11 gl) {
        if (this.GENERATED_HARDWAREID[0] > 0) {
            GLHelper.deleteBuffer(gl, this.GENERATED_HARDWAREID[0]);
        }
        if (this.GENERATED_HARDWAREID[1] > 0) {
            GLHelper.deleteElementBuffer(gl, this.GENERATED_HARDWAREID[1]);
        }
    }

    @Override
    public void onDraw(GL10 _gl) {
        GL11 gl = (GL11)_gl;
        if (!this.isLoaded()) {
            this.onLoadSurface(_gl);
        }
        for (Shape child : this.children) {
            child.onDraw(_gl);
        }
        this.processModifiers((GL10)gl);
        if (this.removed && this.loaded && this.useVBO) {
            this.unloadBuffer(gl);
            this.setLoaded(false);
            return;
        }
        if (!this.isVisible() || this.isRemoved()) {
            return;
        }
        GLHelper.enableTextures((GL10)gl, false);
        gl.glLoadIdentity();
        gl.glPushMatrix();
        this.processBeforeModifiers((GL10)gl);
        GLHelper.setColor((GL10)gl, this.color[0], this.color[1], this.color[2], this.color[3]);
        this.applyParams((GL10)gl);
        if (this.useVBO) {
            GLHelper.bindBuffer(gl, this.GENERATED_HARDWAREID[0]);
            GLHelper.bindElementBuffer(gl, this.GENERATED_HARDWAREID[1]);
            GLHelper.vertexZeroPointer(gl);
            gl.glDrawElements(6, 4, 5123, 0);
        } else {
            GLHelper.vertexPointer((GL10)gl, this.vertexBuffer);
            gl.glDrawElements(6, 4, 5123, (Buffer)this.indiceBuffer);
        }
        this.processAfterModifiers((GL10)gl);
        gl.glPopMatrix();
        GLHelper.checkError((GL10)gl);
        GLHelper.bindBuffer(gl, 0);
        GLHelper.bindElementBuffer(gl, 0);
        GLHelper.enableTextures((GL10)gl, true);
    }

    @Override
    public void onResume() {
        for (ShapeModifier modifier : this.modifiers) {
            modifier.onResume();
        }
        for (Shape child : this.children) {
            child.onResume();
        }
    }

    @Override
    public void onPause() {
        for (ShapeModifier modifier : this.modifiers) {
            modifier.onPause();
        }
        for (Shape child : this.children) {
            child.onPause();
        }
    }

    @Override
    public void onRemove() {
        this.removed = true;
        this.vertexBuffer = null;
        this.indiceBuffer = null;
        this.listeners.clear();
        this.loadableModifiers.clear();
        this.modifiers.clear();
        this.removedModifiers.clear();
        for (Shape child : this.children) {
            child.onRemove();
        }
    }

    @Override
    public void onLoadEngine(E3Engine engine) {
        this.useVBO = engine.useVBO();
        for (Shape child : this.children) {
            child.onLoadEngine(engine);
        }
    }

    @Override
    public void onDispose() {
        this.removed = true;
        this.loaded = false;
        for (Shape child : this.children) {
            child.onDispose();
        }
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setColor(float red, float green, float blue) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
    }

    public void setColor(float red, float green, float blue, float alpha) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
        this.setAlpha(alpha);
    }

    public void resetColor() {
        this.setRed(1.0f);
        this.setGreen(1.0f);
        this.setBlue(1.0f);
        this.setAlpha(1.0f);
    }

    public void setRed(float color) {
        this.color[0] = color;
        for (Shape child : this.children) {
            child.setRed(color);
        }
    }

    public void setGreen(float color) {
        this.color[1] = color;
        for (Shape child : this.children) {
            child.setGreen(color);
        }
    }

    public void setBlue(float color) {
        this.color[2] = color;
        for (Shape child : this.children) {
            child.setBlue(color);
        }
    }

    public void setAlpha(float alpha) {
        this.color[3] = alpha;
        for (Shape child : this.children) {
            child.setAlpha(alpha);
        }
    }

    protected void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getWidthScaled() {
        return (float)this.getWidth() * this.scaleParams[0];
    }

    public float getHeightScaled() {
        return (float)this.getHeight() * this.scaleParams[1];
    }

    public int getRawX() {
        return this.x;
    }

    public int getRawY() {
        return this.y;
    }

    public float[] getColor() {
        return this.color;
    }

    public float getRed() {
        return this.color[0];
    }

    public float getGreen() {
        return this.color[1];
    }

    public float getBlue() {
        return this.color[2];
    }

    public float getAlpha() {
        return this.color[3];
    }

    public boolean isTransparent() {
        return this.getAlpha() == 0.0f;
    }

    public void enableVBO(boolean enable) {
        this.useVBO = enable;
        for (Shape child : this.children) {
            child.enableVBO(enable);
        }
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
        for (Shape child : this.children) {
            child.setLoaded(loaded);
        }
    }

    public void setRotationAndScaleCenter(float localX, float localY) {
        this.setRotationCenter(localX, localY);
        this.setScaleCenter(localX, localY);
    }

    public void useDefaultRotationAndScaleCenter() {
        float[] coord = this.getLocalCenterCoordinates();
        this.setRotationAndScaleCenter(coord[0], coord[1]);
    }

    public float[] getLocalCenterCoordinates() {
        float[] coord = new float[]{(float)this.getWidth() * 0.5f, (float)this.getHeight() * 0.5f};
        return coord;
    }

    public float[] getGlobalCenterCoordinates() {
        float[] coord = this.getLocalCenterCoordinates();
        coord[0] = coord[0] + (float)this.getRealX();
        coord[1] = coord[1] + (float)this.getRealY();
        return coord;
    }

    public void setRotationCenter(float localX, float localY) {
        this.rotateCenter[0] = localX;
        this.rotateCenter[1] = localY;
    }

    public void setScaleCenter(float localX, float localY) {
        this.scaleCenter[0] = localX;
        this.scaleCenter[1] = localY;
    }

    public float getRotationCenterX() {
        return this.rotateCenter[0];
    }

    public float getRotationCenterY() {
        return this.rotateCenter[1];
    }

    public float getScaleCenterX() {
        return this.scaleCenter[0];
    }

    public float getScaleCenterY() {
        return this.scaleCenter[1];
    }

    public void translate(float x, float y, float z) {
        this.translateParams[0] = x;
        this.translateParams[1] = y;
        this.translateParams[2] = z;
    }

    public void rotate(float angle) {
        this.rotate(angle, 2);
    }

    public void rotate(float angle, int axis) {
        this.rotate(angle, this.rotateCenter[0], this.rotateCenter[1], axis);
    }

    public void rotate(float angle, float localX, float localY) {
        this.rotate(angle, localX, localY, 2);
    }

    public void rotate(float angle, float localX, float localY, int axis) {
        this.rotateParams[0] = angle;
        this.rotateParams[1] = (float)this.getRawX() + localX;
        this.rotateParams[2] = (float)this.getRawY() + localY;
        this.rotateParams[3] = axis;
    }

    public void standUp(float angle) {
        this.rotateParams[0] = angle;
        this.rotateParams[1] = this.getRawX();
        this.rotateParams[2] = this.getRawY() + this.getHeight();
        this.rotateParams[3] = 0.0f;
    }

    public void scale(float x, float y, float localX, float localY) {
        this.scaleParams[0] = x;
        this.scaleParams[1] = y;
        this.scaleParams[2] = (float)this.getRawX() + localX;
        this.scaleParams[3] = (float)this.getRawY() + localY;
    }

    public void scale(float x, float y) {
        this.scale(x, y, this.scaleCenter[0], this.scaleCenter[1]);
    }

    public void move(int x, int y) {
        for (Shape child : this.children) {
            child.moveRelative(x - this.getRealX(), y - this.getRealY());
        }
        this.translate(x - this.getRawX(), y - this.getRawY(), this.z);
    }

    public void moveX(int x) {
        for (Shape child : this.children) {
            child.moveRelativeX(x - this.getRealX());
        }
        this.translateParams[0] = x - this.getRawX();
    }

    public void moveY(int y) {
        for (Shape child : this.children) {
            child.moveRelativeY(y - this.getRealY());
        }
        this.translateParams[1] = y - this.getRawY();
    }

    public void moveZ(int z) {
        this.z = z;
    }

    public void moveRelative(int x, int y) {
        this.moveRelativeX(x);
        this.moveRelativeY(y);
    }

    public void moveRelativeX(int x) {
        this.moveX(x + this.getRealX());
    }

    public void moveRelativeY(int y) {
        this.moveY(y + this.getRealY());
    }

    protected void createBuffers() {
        float[] positions = new float[]{this.x, this.y, this.z, this.x, this.y + this.height, this.z, this.x + this.width, this.y + this.height, this.z, this.x + this.width, this.y, this.z};
        this.vertexBuffer = FastFloatBuffer.createBuffer(positions);
        this.indiceBuffer = ShortBuffer.wrap(RECTANGLE_INDICE);
    }

    protected void applyParams(GL10 gl) {
        gl.glTranslatef(this.translateParams[0], this.translateParams[1], this.translateParams[2]);
        gl.glTranslatef(this.rotateParams[1], this.rotateParams[2], 0.0f);
        if (this.rotateParams[3] == 0.0f) {
            gl.glRotatef(this.rotateParams[0], 1.0f, 0.0f, 0.0f);
        } else if (this.rotateParams[3] == 1.0f) {
            gl.glRotatef(this.rotateParams[0], 0.0f, 1.0f, 0.0f);
        } else {
            gl.glRotatef(this.rotateParams[0], 0.0f, 0.0f, 1.0f);
        }
        gl.glTranslatef(-this.rotateParams[1], -this.rotateParams[2], 0.0f);
        gl.glTranslatef(this.scaleParams[2], this.scaleParams[3], 0.0f);
        gl.glScalef(this.scaleParams[0], this.scaleParams[1], 1.0f);
        gl.glTranslatef(-this.scaleParams[2], -this.scaleParams[3], 0.0f);
        GLHelper.checkError(gl);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        for (Shape child : this.children) {
            child.setVisible(visible);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public float getAngle() {
        return this.rotateParams[0];
    }

    public float getScaleX() {
        return this.scaleParams[0];
    }

    public float getScaleY() {
        return this.scaleParams[1];
    }

    public int getRealX() {
        return this.getRawX() + (int)this.translateParams[0];
    }

    public int getRealY() {
        return this.getRawY() + (int)this.translateParams[1];
    }

    public Rect getRect() {
        this.rect.left = this.getRealX();
        this.rect.right = this.rect.left + this.getWidth();
        this.rect.top = this.getRealY();
        this.rect.bottom = this.rect.top + this.getHeight();
        return this.rect;
    }

    public Rect getCollisionRect() {
        return this.getRect();
    }

    public void hide() {
        this.visible = false;
        for (Shape child : this.children) {
            child.hide();
        }
    }

    public void show() {
        this.visible = true;
        for (Shape child : this.children) {
            child.show();
        }
    }

    public void addListener(ShapeEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ShapeEventListener listener) {
        this.listeners.remove(listener);
    }

    public boolean containsX(int globalX) {
        return globalX >= this.getRealX() && globalX <= this.getRealX() + this.getWidth();
    }

    public boolean containsY(int globalY) {
        return globalY >= this.getRealY() && globalY <= this.getRealY() + this.getHeight();
    }

    @Override
    public boolean contains(int globalX, int globalY) {
        return this.containsX(globalX) && this.containsY(globalY);
    }

    public boolean collidesWith(Shape shape) {
        return this.collidesWith(shape.getCollisionRect());
    }

    public boolean collidesWith(Rect rectB) {
        Rect rectA = this.getCollisionRect();
        return rectA.left < rectB.right && rectB.left < rectA.right && rectA.top < rectB.bottom && rectB.top < rectA.bottom;
    }

    public void addModifier(ShapeModifier modifier) {
        this.loadableModifiers.add(modifier);
    }

    public void removeModifier(ShapeModifier modifier) {
        this.removedModifiers.add(modifier);
    }

    public void clearModifier() {
        for (ShapeModifier modifier : this.modifiers) {
            this.removeModifier(modifier);
        }
    }

    public void addChild(Shape shape) {
        this.children.add(shape);
    }

    public void removeChild(Shape shape) {
        this.children.remove(shape);
    }

    @Override
    public boolean onSceneTouchEvent(E3Scene scene, MotionEvent motionEvent) {
        if (this.isRemoved() || this.isTransparent() || !this.isVisible()) {
            return false;
        }
        int pointerCount = motionEvent.getPointerCount();
        int i = 0;
        while (i < pointerCount) {
            int globalX = scene.getEngine().getContext().getTouchEventX(scene, motionEvent, i);
            int globalY = scene.getEngine().getContext().getTouchEventY(scene, motionEvent, i);
            int localX = globalX - this.getRealX();
            int localY = globalY - this.getRealY();
            if (this.contains(globalX, globalY)) {
                this.onTouchEvent(scene, this, motionEvent, localX, localY);
                for (ShapeEventListener listener : this.listeners) {
                    listener.onTouchEvent(scene, this, motionEvent, localX, localY);
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(E3Scene scene, Shape shape, MotionEvent motionEvent, int localX, int localY) {
        return false;
    }

    @Override
    public void onModifierStart(ShapeModifier modifer, Shape shape) {
    }

    @Override
    public void onModifierFinished(ShapeModifier modifier, Shape shape) {
    }
}

