/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable;

import com.e3roid.drawable.Shape;
import com.e3roid.drawable.texture.Texture;
import com.e3roid.opengl.FastFloatBuffer;
import com.e3roid.opengl.GLHelper;
import com.e3roid.util.Debug;
import java.nio.Buffer;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11;

public class Sprite
extends Shape {
    protected Texture texture;
    protected final int[] GENERATED_TEXTURE_BUFFER_ID = new int[1];
    protected FastFloatBuffer coordBuffer;

    protected Sprite() {
    }

    public Sprite(Texture texture) {
        this(texture, 0, 0);
    }

    public Sprite(Texture texture, int x, int y) {
        this.texture = texture;
        this.setSize(texture.getWidth(), texture.getHeight());
        this.setPosition(x, y);
        this.useDefaultRotationAndScaleCenter();
        this.createBuffers();
    }

    public Sprite(Texture texture, int x, int y, int w, int h) {
        this.texture = texture;
        this.setSize(w, h);
        this.setPosition(x, y);
        this.useDefaultRotationAndScaleCenter();
        this.createBuffers();
    }

    @Override
    public void onLoadSurface(GL10 _gl, boolean force) {
        if (!force && this.isLoaded()) {
            return;
        }
        super.onLoadSurface(_gl, force);
        GL11 gl = (GL11)_gl;
        if (force && this.texture.isLoaded()) {
            this.texture.unloadTexture((GL10)gl);
        }
        if (!this.texture.isLoaded()) {
            this.texture.loadTexture((GL10)gl);
        }
        if (this.useVBO) {
            gl.glGenBuffers(1, this.GENERATED_TEXTURE_BUFFER_ID, 0);
        }
        this.loadTextureBuffer(gl, this.coordBuffer);
    }

    protected void callRootOnLoadSurface(GL10 gl, boolean force) {
        super.onLoadSurface(gl, force);
    }

    @Override
    protected void createBuffers() {
        super.createBuffers();
        float[] SPRITE_COORDS = new float[]{this.texture.getCoordStartX(), this.texture.getCoordStartY(), this.texture.getCoordStartX(), this.texture.getCoordEndY(), this.texture.getCoordEndX(), this.texture.getCoordEndY(), this.texture.getCoordEndX(), this.texture.getCoordStartY()};
        this.coordBuffer = FastFloatBuffer.createBuffer(SPRITE_COORDS);
    }

    protected void loadTextureBuffer(GL11 gl) {
        this.loadTextureBuffer(gl, this.coordBuffer);
    }

    protected void loadTextureBuffer(GL11 gl, FastFloatBuffer coordBuffer) {
        if (this.useVBO) {
            GLHelper.bindBuffer(gl, this.GENERATED_TEXTURE_BUFFER_ID[0]);
            GLHelper.bufferFloatData(gl, coordBuffer.capacity(), coordBuffer, 35044);
        }
        this.coordBuffer = coordBuffer;
    }

    @Override
    public void onDraw(GL10 _gl) {
        GL11 gl = (GL11)_gl;
        for (Shape child : this.children) {
            child.onDraw(_gl);
        }
        this.processModifiers((GL10)gl);
        if (this.isRemoved() && this.isLoaded()) {
            this.unload((GL10)gl);
            return;
        }
        if (!this.isVisible() || this.isRemoved()) {
            return;
        }
        gl.glBindTexture(3553, this.texture.getTextureID());
        gl.glLoadIdentity();
        gl.glPushMatrix();
        this.processBeforeModifiers((GL10)gl);
        GLHelper.setColor((GL10)gl, this.color[0], this.color[1], this.color[2], this.color[3]);
        this.applyParams((GL10)gl);
        if (this.useVBO) {
            GLHelper.bindBuffer(gl, this.GENERATED_HARDWAREID[0]);
            GLHelper.vertexZeroPointer(gl);
            GLHelper.bindBuffer(gl, this.GENERATED_TEXTURE_BUFFER_ID[0]);
            GLHelper.texCoordZeroPointer(gl);
            GLHelper.bindElementBuffer(gl, this.GENERATED_HARDWAREID[1]);
            gl.glDrawElements(6, 4, 5123, 0);
        } else {
            GLHelper.vertexPointer((GL10)gl, this.vertexBuffer);
            GLHelper.texCoordPointer((GL10)gl, this.coordBuffer);
            gl.glDrawElements(6, 4, 5123, (Buffer)this.indiceBuffer);
        }
        this.processAfterModifiers((GL10)gl);
        gl.glPopMatrix();
        GLHelper.checkError((GL10)gl);
        GLHelper.bindBuffer(gl, 0);
        GLHelper.bindElementBuffer(gl, 0);
    }

    @Override
    public void onRemove() {
        super.onRemove();
        this.coordBuffer = null;
    }

    protected void unload(GL10 gl) {
        if (!this.texture.isReusable() && this.texture.isLoaded()) {
            this.texture.unloadTexture(gl);
            Debug.d(String.format("%s is unloaded.", this.texture.describe()));
        }
        this.setLoaded(false);
    }

    protected void updateTexture(Texture texture) {
        this.texture = texture;
    }
}

