/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.controls;

import com.e3roid.E3Scene;
import com.e3roid.drawable.controls.StickController;
import com.e3roid.drawable.texture.Texture;
import com.e3roid.event.ControllerEventListener;

public class DigitalController
extends StickController {
    public DigitalController(Texture baseTexture, Texture knobTexture, int x, int y, E3Scene scene) {
        this(baseTexture, knobTexture, x, y, scene, null);
    }

    public DigitalController(Texture baseTexture, Texture knobTexture, int x, int y, E3Scene scene, ControllerEventListener listener) {
        super(baseTexture, knobTexture, x, y, scene, listener);
    }

    @Override
    protected boolean updateControl() {
        if (this.moveX == this.knob.getRealX() && this.moveY == this.knob.getRealY()) {
            return false;
        }
        int relativeX = this.getRelativeKnobX();
        int relativeY = this.getRelativeKnobY();
        float[] centerCoord = this.getLocalCenterCoordinates();
        if (Math.abs(relativeX) > Math.abs(relativeY)) {
            if (relativeX > 0) {
                this.moveX = this.knobCenterX + (int)centerCoord[0];
                this.moveY = this.knobCenterY;
            } else if (relativeX < 0) {
                this.moveX = this.knobCenterX - (int)centerCoord[0];
                this.moveY = this.knobCenterY;
            } else {
                this.moveToCenter();
            }
        } else if (relativeY > 0) {
            this.moveX = this.knobCenterX;
            this.moveY = this.knobCenterY + (int)centerCoord[1];
        } else if (relativeY < 0) {
            this.moveX = this.knobCenterX;
            this.moveY = this.knobCenterY - (int)centerCoord[1];
        } else {
            this.moveToCenter();
        }
        return super.updateControl();
    }

    @Override
    public int getDirection() {
        if (this.getRelativeKnobY() == -100) {
            return 3;
        }
        if (this.getRelativeKnobY() == 100) {
            return 4;
        }
        if (this.getRelativeKnobX() == -100) {
            return 1;
        }
        if (this.getRelativeKnobX() == 100) {
            return 2;
        }
        return 0;
    }
}

