/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.controls;

import android.graphics.Rect;
import android.view.MotionEvent;
import com.e3roid.E3Scene;
import com.e3roid.drawable.Shape;
import com.e3roid.drawable.Sprite;
import com.e3roid.drawable.texture.Texture;
import com.e3roid.event.ControllerEventListener;
import com.e3roid.event.SceneUpdateListener;

public class StickController
extends Sprite
implements SceneUpdateListener {
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    protected final E3Scene scene;
    protected final Sprite knob;
    protected int knobCenterX;
    protected int knobCenterY;
    protected int updateInterval = 200;
    protected boolean fastUpdate = true;
    protected int moveX;
    protected int moveY;
    protected Rect knobPadding = new Rect();
    protected ControllerEventListener listener;
    protected int margin = 10;
    protected int identifier = 0;

    public StickController(Texture baseTexture, Texture knobTexture, int x, int y, E3Scene scene) {
        this(baseTexture, knobTexture, x, y, scene, null);
    }

    public StickController(Texture baseTexture, Texture knobTexture, int x, int y, E3Scene scene, ControllerEventListener listener) {
        super(baseTexture, x, y);
        this.scene = scene;
        this.listener = listener;
        this.knob = new Sprite(knobTexture, 0, 0);
        this.addChild(this.knob);
        this.updateKnobCenter();
        this.setUpdateInterval(this.updateInterval);
    }

    protected void updateKnobCenter() {
        float[] baseCoord = this.getLocalCenterCoordinates();
        float[] knobCoord = this.knob.getLocalCenterCoordinates();
        this.knobCenterX = (int)((float)this.getRealX() + baseCoord[0] - knobCoord[0]);
        this.knobCenterY = (int)((float)this.getRealY() + baseCoord[1] - knobCoord[1]);
        this.knob.move(this.knobCenterX, this.knobCenterY);
        this.moveX = this.knobCenterX;
        this.moveY = this.knobCenterY;
    }

    @Override
    public void move(int x, int y) {
        super.move(x, y);
        this.updateKnobCenter();
    }

    @Override
    public void moveX(int x) {
        super.moveX(x);
        this.updateKnobCenter();
    }

    @Override
    public void moveY(int y) {
        super.moveY(y);
        this.updateKnobCenter();
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.knobPadding.left = left;
        this.knobPadding.right = this.getWidth() - right;
        this.knobPadding.top = top;
        this.knobPadding.bottom = this.getHeight() - bottom;
    }

    public void setUpdateInterval(int interval) {
        this.updateInterval = interval;
        this.scene.registerUpdateListener(interval, this);
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public void updateImmediately(boolean enable) {
        this.fastUpdate = enable;
    }

    public boolean isKnobArea(int localX, int localY) {
        return localX >= this.knobPadding.left && localX <= this.knobPadding.right && localY >= this.knobPadding.top && localY <= this.knobPadding.bottom;
    }

    @Override
    public boolean onTouchEvent(E3Scene scene, Shape shape, MotionEvent motionEvent, int localX, int localY) {
        int pointerCount = motionEvent.getPointerCount();
        int i = 0;
        while (i < pointerCount) {
            int y;
            int x;
            int actionType = motionEvent.getAction() & 0xFF;
            if ((actionType == 2 || actionType == 0 || actionType == 5) && this.contains(x = scene.getEngine().getContext().getTouchEventX(scene, motionEvent, i), y = scene.getEngine().getContext().getTouchEventY(scene, motionEvent, i))) {
                float[] knobCoord = this.knob.getLocalCenterCoordinates();
                if (x >= this.getRealX() && x <= this.getRealX() + this.getWidth()) {
                    this.moveX = (int)((float)x - knobCoord[0]);
                }
                if (y >= this.getRealY() && y <= this.getRealY() + this.getHeight()) {
                    this.moveY = (int)((float)y - knobCoord[1]);
                }
                if (this.fastUpdate && this.isKnobCenter() && this.updateControl()) {
                    this.updateControlEvent();
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean onSceneTouchEvent(E3Scene scene, MotionEvent motionEvent) {
        int actionType = motionEvent.getAction() & 0xFF;
        if (actionType == 1 || actionType == 3 || actionType == 6 || actionType == 4) {
            this.moveToCenter();
        }
        super.onSceneTouchEvent(scene, motionEvent);
        return false;
    }

    @Override
    public void onUpdateScene(E3Scene scene, long elapsedMsec) {
        this.updateControlEvent();
    }

    protected void updateControlEvent() {
        boolean hasChanged = this.updateControl();
        if (hasChanged || !this.isKnobCenter()) {
            this.onControlUpdate(this.getRelativeKnobX(), this.getRelativeKnobY(), hasChanged);
            if (this.listener != null) {
                this.listener.onControlUpdate(this, this.getRelativeKnobX(), this.getRelativeKnobY(), hasChanged);
            }
        }
    }

    protected boolean updateControl() {
        if (this.moveX != this.knob.getRealX() || this.moveY != this.knob.getRealY()) {
            this.knob.move(this.moveX, this.moveY);
            return true;
        }
        return false;
    }

    public void onControlUpdate(int relativeX, int relativeY, boolean hasChanged) {
    }

    public int getKnobX() {
        return this.moveX;
    }

    public int getKnobY() {
        return this.moveY;
    }

    public void setKnobPosition(int x, int y) {
        this.moveX = x;
        this.moveY = y;
    }

    public int getKnobCenterX() {
        return this.knobCenterX;
    }

    public int getKnobCenterY() {
        return this.knobCenterY;
    }

    public Sprite getKnobSprite() {
        return this.knob;
    }

    public int getRelativeKnobX() {
        float unit = (float)this.getWidth() / 2.0f - (float)this.knobPadding.left;
        float axisX = (float)this.getRawX() + (float)this.getWidth() / 2.0f;
        float knobX = (float)this.getKnobX() + (float)this.knob.getWidth() / 2.0f;
        int x = Math.round((knobX - axisX) / unit * 100.0f);
        if (x > 0) {
            x = Math.min(100, x);
        }
        if (x < 0) {
            x = Math.max(-100, x);
        }
        return x;
    }

    public int getRelativeKnobY() {
        float unit = (float)this.getHeight() / 2.0f - (float)this.knobPadding.top;
        float axisY = (float)this.getRawY() + (float)this.getHeight() / 2.0f;
        float knobY = (float)this.getKnobY() + (float)this.knob.getHeight() / 2.0f;
        int y = Math.round((knobY - axisY) / unit * 100.0f);
        if (y > 0) {
            y = Math.min(100, y);
        }
        if (y < 0) {
            y = Math.max(-100, y);
        }
        return y;
    }

    public void moveToCenter() {
        this.moveX = this.knobCenterX;
        this.moveY = this.knobCenterY;
    }

    public boolean isKnobCenter() {
        return this.moveX == this.knobCenterX && this.moveY == this.knobCenterY;
    }

    @Override
    public boolean containsY(int globalY) {
        return globalY >= this.getRealY() - this.margin && globalY <= this.getRealY() + this.getHeight() + this.margin;
    }

    public int getDirection() {
        int relativeX = this.getRelativeKnobX();
        int relativeY = this.getRelativeKnobY();
        if (Math.abs(relativeX) > Math.abs(relativeY)) {
            if (relativeX > 0) {
                return 2;
            }
            if (relativeX < 0) {
                return 1;
            }
            return 0;
        }
        if (relativeY > 0) {
            return 4;
        }
        if (relativeY < 0) {
            return 3;
        }
        return 0;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int id) {
        this.identifier = id;
    }
}

