/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.modifier;

import com.e3roid.drawable.Shape;
import com.e3roid.drawable.modifier.ShapeModifier;
import com.e3roid.event.ModifierEventListener;
import java.util.ArrayList;
import javax.microedition.khronos.opengles.GL10;

public class ParallelModifier
extends ShapeModifier {
    private ArrayList<ShapeModifier> modifiers = new ArrayList();
    private ArrayList<ShapeModifier> removableModifiers = new ArrayList();
    private ModifierEventListener eventListener;
    private boolean useLoop = false;
    private boolean useReverse = false;
    private int maxLoopCount = 0;
    private int currentLoopCount = 0;

    public ParallelModifier(ShapeModifier ... modifiers) {
        this.add(modifiers);
    }

    public void setLoop() {
        this.setLoop(0, false);
    }

    public void setLoop(boolean reverse) {
        this.setLoop(0, reverse);
    }

    public void setLoop(int count) {
        this.setLoop(count, false);
    }

    public void setLoop(int count, boolean reverse) {
        this.currentLoopCount = 0;
        this.maxLoopCount = count;
        this.useReverse = reverse;
        this.useLoop = true;
    }

    public void setEventListener(ModifierEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void add(ShapeModifier ... modifiers) {
        ShapeModifier[] shapeModifierArray = modifiers;
        int n = modifiers.length;
        int n2 = 0;
        while (n2 < n) {
            ShapeModifier modifier = shapeModifierArray[n2];
            modifier.hasParentShape(false);
            this.modifiers.add(modifier);
            ++n2;
        }
    }

    @Override
    public void onResume() {
        for (ShapeModifier modifier : this.modifiers) {
            modifier.onResume();
        }
    }

    @Override
    public void onPause() {
        for (ShapeModifier modifier : this.modifiers) {
            modifier.onPause();
        }
    }

    @Override
    public void onLoad(Shape shape, GL10 gl) {
        if (this.eventListener != null) {
            this.eventListener.onModifierStart(this, shape);
        }
        for (ShapeModifier modifier : this.modifiers) {
            modifier.onLoad(shape, gl);
        }
    }

    @Override
    public void onBeforeUpdate(Shape shape, GL10 gl) {
        for (ShapeModifier modifier : this.modifiers) {
            modifier.onBeforeUpdate(shape, gl);
        }
    }

    @Override
    public void onAfterUpdate(Shape shape, GL10 gl) {
        for (ShapeModifier modifier : this.modifiers) {
            modifier.onAfterUpdate(shape, gl);
            if (!modifier.isDurationDone()) continue;
            this.removableModifiers.add(modifier);
        }
        if (this.useLoop) {
            if (this.removableModifiers.size() == this.modifiers.size()) {
                int i = 0;
                while (i < this.modifiers.size()) {
                    ShapeModifier modifier = this.modifiers.get(i);
                    modifier.reset();
                    if (this.useReverse) {
                        modifier.reverse();
                    }
                    this.modifiers.set(i, modifier);
                    ++i;
                }
                if (this.maxLoopCount > 0) {
                    ++this.currentLoopCount;
                    if (this.currentLoopCount >= this.maxLoopCount) {
                        for (ShapeModifier modifier : this.modifiers) {
                            modifier.onUnload(shape, gl);
                        }
                        this.modifiers.clear();
                    }
                }
                this.removableModifiers.clear();
            }
        } else if (!this.removableModifiers.isEmpty()) {
            for (ShapeModifier modifier : this.removableModifiers) {
                modifier.onUnload(shape, gl);
                this.modifiers.remove(modifier);
            }
            this.removableModifiers.clear();
        }
        if (this.modifiers.isEmpty()) {
            this.finish(shape);
        }
    }

    @Override
    public void onUnload(Shape shape, GL10 gl) {
        if (this.eventListener != null) {
            this.eventListener.onModifierFinished(this, shape);
        }
    }

    @Override
    public void reset() {
        this.currentLoopCount = 0;
    }
}

