/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.modifier;

import com.e3roid.drawable.Shape;
import com.e3roid.drawable.modifier.ShapeModifier;
import javax.microedition.khronos.opengles.GL10;

public abstract class ProgressAware
extends ShapeModifier {
    public static final int PARAM_SINGLE = 0;
    public static final int PARAM_DOUBLE = 1;
    public static final int PARAM_TRIPLE = 2;
    private boolean finished = false;
    private boolean finishIfDone = true;
    protected float progress;
    protected float currentValueA;
    protected float minValueA;
    protected float maxValueA;
    protected float currentValueB;
    protected float minValueB;
    protected float maxValueB;
    protected float currentValueC;
    protected float minValueC;
    protected float maxValueC;
    protected int paramMode = 0;

    public ProgressAware(float current, float minValue, float maxValue) {
        this.currentValueA = current;
        this.minValueA = minValue;
        this.maxValueA = maxValue;
        this.paramMode = 0;
    }

    public ProgressAware(float currentA, float minValueA, float maxValueA, float currentB, float minValueB, float maxValueB) {
        this.currentValueA = currentA;
        this.minValueA = minValueA;
        this.maxValueA = maxValueA;
        this.currentValueB = currentB;
        this.minValueB = minValueB;
        this.maxValueB = maxValueB;
        this.paramMode = 1;
    }

    public ProgressAware(float currentA, float minValueA, float maxValueA, float currentB, float minValueB, float maxValueB, float currentC, float minValueC, float maxValueC) {
        this.currentValueA = currentA;
        this.minValueA = minValueA;
        this.maxValueA = maxValueA;
        this.currentValueB = currentB;
        this.minValueB = minValueB;
        this.maxValueB = maxValueB;
        this.currentValueC = currentC;
        this.minValueC = minValueC;
        this.maxValueC = maxValueC;
        this.paramMode = 2;
    }

    public float getMinimumValueA() {
        return this.minValueA;
    }

    public float getMaximumValueA() {
        return this.maxValueA;
    }

    public float getMinimumValueB() {
        return this.minValueB;
    }

    public float getMaximumValueB() {
        return this.maxValueB;
    }

    public float getMinimumValueC() {
        return this.minValueC;
    }

    public float getMaximumValueC() {
        return this.maxValueC;
    }

    public float getSpanA() {
        return this.maxValueA - this.minValueA;
    }

    public float getSpanB() {
        return this.maxValueB - this.minValueB;
    }

    public float getSpanC() {
        return this.maxValueC - this.minValueC;
    }

    public float getProgressValueA(float percent) {
        return this.minValueA + percent * this.getSpanA();
    }

    public float getProgressValueB(float percent) {
        return this.minValueB + percent * this.getSpanB();
    }

    public float getProgressValueC(float percent) {
        return this.minValueC + percent * this.getSpanC();
    }

    public void updateProgressValueA(float value, float percent) {
        this.currentValueA = value;
        this.progress = percent;
    }

    public void updateProgressValueB(float value, float percent) {
        this.currentValueB = value;
        this.progress = percent;
    }

    public void updateProgressValueC(float value, float percent) {
        this.currentValueC = value;
        this.progress = percent;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isFinishIfDone() {
        return this.finishIfDone;
    }

    public int getParameterMode() {
        return this.paramMode;
    }

    public void setFinishIfDone(boolean finish) {
        this.finishIfDone = finish;
    }

    public void done(Shape shape) {
        this.progress = 1.0f;
        this.currentValueA = this.getMaximumValueA();
        this.currentValueB = this.getMaximumValueB();
        this.currentValueC = this.getMaximumValueC();
        if (this.isFinishIfDone()) {
            this.finish(shape);
        }
    }

    @Override
    public void reverse() {
        float max;
        float min = this.minValueA;
        this.minValueA = max = this.maxValueA;
        this.maxValueA = min;
        min = this.minValueB;
        this.minValueB = max = this.maxValueB;
        this.maxValueB = min;
        min = this.minValueC;
        this.minValueC = max = this.maxValueC;
        this.maxValueC = min;
    }

    @Override
    public void reset() {
        this.progress = 0.0f;
        this.finished = false;
    }

    @Override
    public void onLoad(Shape shape, GL10 gl) {
    }

    @Override
    public void onUnload(Shape shape, GL10 gl) {
    }

    @Override
    public void finish(Shape shape) {
        this.finished = true;
    }
}

