/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.modifier;

import android.os.SystemClock;
import com.e3roid.drawable.Shape;
import com.e3roid.drawable.modifier.ProgressAware;
import com.e3roid.drawable.modifier.ShapeModifier;
import com.e3roid.drawable.modifier.function.Progressive;
import com.e3roid.event.ModifierEventListener;
import javax.microedition.khronos.opengles.GL10;

public class ProgressModifier
extends ShapeModifier {
    private final ProgressAware modifier;
    private final Progressive functionA;
    private final Progressive functionB;
    private final Progressive functionC;
    private final long duration;
    private long lastTimeMillis = 0L;
    private boolean durationDone = false;
    private long pausedTimeElapsed = 0L;
    private ModifierEventListener eventListener;

    public ProgressModifier(ProgressAware modifier, long duration) {
        this(modifier, duration, null, null, null, null);
    }

    public ProgressModifier(ProgressAware modifier, long duration, Progressive function) {
        this(modifier, duration, function, null, null, null);
    }

    public ProgressModifier(ProgressAware modifier, long duration, Progressive functionA, Progressive functionB) {
        this(modifier, duration, functionA, functionB, null, null);
    }

    public ProgressModifier(ProgressAware modifier, long duration, Progressive functionA, Progressive functionB, Progressive functionC) {
        this(modifier, duration, functionA, functionB, functionC, null);
    }

    public ProgressModifier(ProgressAware modifier, long duration, Progressive functionA, ModifierEventListener eventListener) {
        this(modifier, duration, functionA, null, null, eventListener);
    }

    public ProgressModifier(ProgressAware modifier, long duration, Progressive functionA, Progressive functionB, ModifierEventListener eventListener) {
        this(modifier, duration, functionA, functionB, null, eventListener);
    }

    public ProgressModifier(ProgressAware modifier, long duration, Progressive functionA, Progressive functionB, Progressive functionC, ModifierEventListener eventListener) {
        this.modifier = modifier;
        this.functionA = functionA;
        this.functionB = functionB;
        this.functionC = functionC;
        this.duration = duration;
        this.eventListener = eventListener;
        this.modifier.hasParentShape(false);
    }

    public void setEventListener(ModifierEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public boolean isDurationDone() {
        return this.durationDone;
    }

    @Override
    public void reverse() {
        this.modifier.reverse();
    }

    @Override
    public void reset() {
        this.durationDone = false;
        this.lastTimeMillis = SystemClock.uptimeMillis();
        this.modifier.reset();
    }

    @Override
    public void onLoad(Shape shape, GL10 gl) {
        if (this.eventListener != null) {
            this.eventListener.onModifierStart(this, shape);
        }
        this.lastTimeMillis = SystemClock.uptimeMillis();
        this.durationDone = false;
        this.modifier.onLoad(shape, gl);
    }

    @Override
    public void onPause() {
        this.pausedTimeElapsed = SystemClock.uptimeMillis() - this.lastTimeMillis;
    }

    @Override
    public void onResume() {
        this.lastTimeMillis = SystemClock.uptimeMillis() - this.pausedTimeElapsed;
    }

    @Override
    public void onBeforeUpdate(Shape shape, GL10 gl) {
        long elapsed = SystemClock.uptimeMillis() - this.lastTimeMillis;
        if (elapsed <= this.duration) {
            float progress = 0.0f;
            if (this.functionA != null) {
                progress = this.functionA.getProgress(elapsed, this.duration, 0.0f, 1.0f);
                this.modifier.updateProgressValueA(this.modifier.getProgressValueA(progress), progress);
            }
            if (this.modifier.getParameterMode() != 0) {
                if (this.functionB != null) {
                    progress = this.functionB.getProgress(elapsed, this.duration, 0.0f, 1.0f);
                }
                this.modifier.updateProgressValueB(this.modifier.getProgressValueB(progress), progress);
            }
            if (this.modifier.getParameterMode() == 2) {
                if (this.functionC != null) {
                    progress = this.functionC.getProgress(elapsed, this.duration, 0.0f, 1.0f);
                }
                this.modifier.updateProgressValueC(this.modifier.getProgressValueC(progress), progress);
            }
        } else {
            this.modifier.done(shape);
            this.durationDone = true;
        }
        this.modifier.onBeforeUpdate(shape, gl);
    }

    @Override
    public void onAfterUpdate(Shape shape, GL10 gl) {
        this.modifier.onAfterUpdate(shape, gl);
        if (this.modifier.isFinishIfDone() && this.modifier.isFinished()) {
            this.finish(shape);
            return;
        }
    }

    @Override
    public void onUnload(Shape shape, GL10 gl) {
        this.modifier.onUnload(shape, gl);
        if (this.eventListener != null) {
            this.eventListener.onModifierFinished(this, shape);
        }
    }
}

