/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.modifier;

import com.e3roid.drawable.Shape;
import com.e3roid.drawable.modifier.ShapeModifier;
import com.e3roid.event.ModifierEventListener;
import java.util.ArrayList;
import javax.microedition.khronos.opengles.GL10;

public class SequenceModifier
extends ShapeModifier {
    private ArrayList<ShapeModifier> modifiers = new ArrayList();
    private ShapeModifier currentModifier = null;
    private ModifierEventListener eventListener;
    private int currentIndex = 0;
    private boolean useLoop = false;
    private boolean useReverse = false;
    private int maxLoopCount = 0;
    private int currentLoopCount = 0;

    public SequenceModifier(ShapeModifier ... modifiers) {
        this.add(modifiers);
    }

    public void setLoop() {
        this.setLoop(0, false);
    }

    public void setLoop(boolean reverse) {
        this.setLoop(0, reverse);
    }

    public void setLoop(int count) {
        this.setLoop(count, false);
    }

    public void setLoop(int count, boolean reverse) {
        this.currentLoopCount = 0;
        this.maxLoopCount = count;
        this.useReverse = reverse;
        this.useLoop = true;
    }

    public void setEventListener(ModifierEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void add(ShapeModifier ... modifiers) {
        ShapeModifier[] shapeModifierArray = modifiers;
        int n = modifiers.length;
        int n2 = 0;
        while (n2 < n) {
            ShapeModifier modifier = shapeModifierArray[n2];
            modifier.hasParentShape(false);
            this.modifiers.add(modifier);
            ++n2;
        }
    }

    @Override
    public void onLoad(Shape shape, GL10 gl) {
        if (this.eventListener != null) {
            this.eventListener.onModifierStart(this, shape);
        }
        this.currentModifier = this.modifiers.get(this.currentIndex);
        this.currentModifier.onLoad(shape, gl);
    }

    @Override
    public void onBeforeUpdate(Shape shape, GL10 gl) {
        if (this.currentModifier == null) {
            return;
        }
        this.currentModifier.onBeforeUpdate(shape, gl);
    }

    @Override
    public void onAfterUpdate(Shape shape, GL10 gl) {
        if (this.currentModifier == null) {
            return;
        }
        this.currentModifier.onAfterUpdate(shape, gl);
        if (this.currentModifier.isDurationDone()) {
            if (!this.useLoop) {
                this.currentModifier.onUnload(shape, gl);
            }
            ++this.currentIndex;
            if (this.currentIndex < this.modifiers.size()) {
                this.currentModifier = this.modifiers.get(this.currentIndex);
                this.currentModifier.onLoad(shape, gl);
            } else {
                this.currentModifier = null;
            }
        }
        if (this.currentModifier == null) {
            if (this.useLoop) {
                if (this.maxLoopCount > 0) {
                    ++this.currentLoopCount;
                    if (this.currentLoopCount >= this.maxLoopCount) {
                        for (ShapeModifier modifier : this.modifiers) {
                            modifier.onUnload(shape, gl);
                        }
                        this.finish(shape);
                        return;
                    }
                }
                int i = 0;
                while (i < this.modifiers.size()) {
                    ShapeModifier modifier = this.modifiers.get(i);
                    modifier.reset();
                    if (this.useReverse) {
                        modifier.reverse();
                    }
                    this.modifiers.set(i, modifier);
                    ++i;
                }
                this.currentIndex = 0;
                this.currentModifier = this.modifiers.get(this.currentIndex);
            } else {
                this.finish(shape);
                return;
            }
        }
    }

    @Override
    public void onResume() {
        for (ShapeModifier modifier : this.modifiers) {
            modifier.onResume();
        }
    }

    @Override
    public void onPause() {
        for (ShapeModifier modifier : this.modifiers) {
            modifier.onPause();
        }
    }

    @Override
    public void onUnload(Shape shape, GL10 gl) {
        if (this.eventListener != null) {
            this.eventListener.onModifierFinished(this, shape);
        }
        this.modifiers.clear();
        this.currentModifier = null;
        this.eventListener = null;
    }

    @Override
    public void reset() {
        this.currentIndex = 0;
        this.currentLoopCount = 0;
    }
}

