/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.modifier;

import android.os.SystemClock;
import com.e3roid.drawable.Shape;
import com.e3roid.drawable.modifier.ProgressAware;
import com.e3roid.drawable.modifier.ShapeModifier;
import com.e3roid.event.ModifierEventListener;
import javax.microedition.khronos.opengles.GL10;

public class SpanModifier
extends ShapeModifier {
    private ProgressAware modifier;
    private int maxCount = 0;
    private long span = 0L;
    private int currentCount = 0;
    private long lastTimeMillis = 0L;
    private boolean modifying = false;
    private boolean waitForFinish = false;
    private ModifierEventListener eventListener;

    public SpanModifier(long span, ProgressAware modifier) {
        this(0, span, modifier, null);
    }

    public SpanModifier(long span, ProgressAware modifier, ModifierEventListener listener) {
        this(0, span, modifier, listener);
    }

    public SpanModifier(int count, long span, ProgressAware modifier) {
        this(count, span, modifier, null);
    }

    public SpanModifier(int count, long span, ProgressAware modifier, ModifierEventListener listener) {
        this.modifier = modifier;
        this.maxCount = count;
        this.span = span;
        this.lastTimeMillis = SystemClock.uptimeMillis();
        this.modifier.hasParentShape(false);
        this.eventListener = listener;
    }

    private boolean spanElapsed() {
        return SystemClock.uptimeMillis() - this.lastTimeMillis > this.span;
    }

    private void updateMinimum() {
        this.modifier.updateProgressValueA(this.modifier.getMinimumValueA(), 0.0f);
        if (this.modifier.getParameterMode() != 0) {
            this.modifier.updateProgressValueB(this.modifier.getMinimumValueB(), 0.0f);
        }
        if (this.modifier.getParameterMode() == 2) {
            this.modifier.updateProgressValueC(this.modifier.getMinimumValueC(), 0.0f);
        }
    }

    private void updateMaximum() {
        this.modifier.updateProgressValueA(this.modifier.getMaximumValueA(), 1.0f);
        if (this.modifier.getParameterMode() != 0) {
            this.modifier.updateProgressValueB(this.modifier.getMaximumValueB(), 1.0f);
        }
        if (this.modifier.getParameterMode() == 2) {
            this.modifier.updateProgressValueC(this.modifier.getMaximumValueC(), 1.0f);
        }
    }

    @Override
    public void onResume() {
        this.modifier.onResume();
    }

    @Override
    public void onPause() {
        this.modifier.onPause();
    }

    @Override
    public void onLoad(Shape shape, GL10 gl) {
        if (this.eventListener != null) {
            this.eventListener.onModifierStart(this, shape);
        }
        this.modifier.onLoad(shape, gl);
    }

    @Override
    public void onBeforeUpdate(Shape shape, GL10 gl) {
        if (this.spanElapsed()) {
            if (this.modifying) {
                if (this.maxCount > 0) {
                    ++this.currentCount;
                    if (this.currentCount >= this.maxCount) {
                        this.waitForFinish = true;
                        return;
                    }
                }
                this.updateMinimum();
            } else {
                this.updateMaximum();
            }
            this.lastTimeMillis = SystemClock.uptimeMillis();
            this.modifying = !this.modifying;
        }
        this.modifier.onBeforeUpdate(shape, gl);
    }

    @Override
    public void onAfterUpdate(Shape shape, GL10 gl) {
        this.modifier.onAfterUpdate(shape, gl);
        if (this.waitForFinish) {
            this.finish(shape);
        }
    }

    @Override
    public void onUnload(Shape shape, GL10 gl) {
        if (this.eventListener != null) {
            this.eventListener.onModifierFinished(this, shape);
        }
        this.modifier.onUnload(shape, gl);
    }

    @Override
    public boolean isDurationDone() {
        return this.waitForFinish;
    }

    @Override
    public void reset() {
        this.currentCount = 0;
    }
}

