/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.sprite;

import android.os.SystemClock;
import com.e3roid.drawable.Sprite;
import com.e3roid.drawable.texture.TiledTexture;
import com.e3roid.event.AnimationEventListener;
import com.e3roid.opengl.FastFloatBuffer;
import com.e3roid.util.IntPair;
import java.util.ArrayList;
import java.util.HashMap;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11;

public class AnimatedSprite
extends Sprite {
    private boolean animated = false;
    private int maxCount = 0;
    private ArrayList<Frame> frames = new ArrayList();
    private HashMap<IntPair, FastFloatBuffer> cache = new HashMap();
    private final TiledTexture texture;
    private AnimationEventListener eventListener;
    private long duration = 200L;
    private long lastTimeMillis = 0L;
    private int currentFrame = 0;
    private int currentCount = 0;
    private boolean reloadTile = false;

    public AnimatedSprite(TiledTexture texture, int x, int y) {
        this(texture, x, y, null);
    }

    public AnimatedSprite(TiledTexture texture, int x, int y, AnimationEventListener listener) {
        super(texture);
        this.texture = texture;
        this.eventListener = listener;
        this.setSize(texture.getTileWidth(), texture.getTileHeight());
        this.setPosition(x, y);
        this.useDefaultRotationAndScaleCenter();
        this.createBuffers();
    }

    @Override
    public void onDraw(GL10 _gl) {
        GL11 gl = (GL11)_gl;
        if (this.animated && this.isVisible()) {
            long wait;
            long now = SystemClock.uptimeMillis();
            Frame frame = this.getCurrentFrame();
            long l = wait = frame.getDuration() == 0L ? this.duration : frame.getDuration();
            if (now - this.lastTimeMillis > wait) {
                IntPair cacheKey = new IntPair(frame.getX(), frame.getY());
                this.nextFrame();
                this.loadTextureBuffer(gl, this.cache.get(cacheKey));
                if (this.maxCount > 0 && this.currentFrame == 0) {
                    ++this.currentCount;
                }
                this.lastTimeMillis = now;
            }
            if (this.maxCount > 0 && this.currentCount >= this.maxCount) {
                this.stop();
            }
        }
        if (this.reloadTile) {
            IntPair cacheKey = new IntPair(this.texture.getTileIndexX(), this.texture.getTileIndexY());
            this.loadTextureBuffer(gl, this.cache.get(cacheKey));
            this.reloadTile = false;
        }
        super.onDraw(_gl);
    }

    private void nextFrame() {
        ++this.currentFrame;
        if (this.frames.size() <= this.currentFrame) {
            this.currentFrame = 0;
        }
    }

    private void createAnimationBuffers() {
        int saveX = this.texture.getTileIndexX();
        int saveY = this.texture.getTileIndexY();
        for (Frame frame : this.frames) {
            this.createCache(frame.getX(), frame.getY());
        }
        this.texture.setTileIndex(saveX, saveY);
    }

    private void createCache(int x, int y) {
        IntPair cacheKey = new IntPair(x, y);
        if (this.cache.containsKey(cacheKey)) {
            return;
        }
        this.texture.setTileIndex(x, y);
        float[] coords = new float[]{this.texture.getCoordStartX(), this.texture.getCoordStartY(), this.texture.getCoordStartX(), this.texture.getCoordEndY(), this.texture.getCoordEndX(), this.texture.getCoordEndY(), this.texture.getCoordEndX(), this.texture.getCoordStartY()};
        this.cache.put(cacheKey, FastFloatBuffer.createBuffer(coords));
    }

    @Override
    public void onRemove() {
        super.onRemove();
        this.reset();
        this.animated = false;
    }

    @Override
    public void onDispose() {
        super.onDispose();
        this.reset();
        this.animated = false;
    }

    public Frame getCurrentFrame() {
        return this.frames.get(this.currentFrame);
    }

    public int getCurrentFrameIndex() {
        return this.currentFrame;
    }

    public int getCurrentCount() {
        return this.currentCount;
    }

    public void setTile(int xindex, int yindex) {
        this.createCache(xindex, yindex);
        this.texture.setTileIndex(xindex, yindex);
        this.reloadTile = true;
    }

    public void reset() {
        this.lastTimeMillis = 0L;
        this.currentFrame = 0;
        this.currentCount = 0;
    }

    public void stop() {
        if (this.eventListener != null) {
            this.eventListener.animationFinished(this);
        }
        this.animated = false;
    }

    public void start() {
        if (this.eventListener != null) {
            this.eventListener.animationStarted(this);
        }
        this.animated = true;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setEventListener(AnimationEventListener listener) {
        this.eventListener = listener;
    }

    public void animate(long duration, ArrayList<Frame> frames) {
        this.animate(duration, 0, frames);
    }

    public void animate(long duration, int count, ArrayList<Frame> frames) {
        this.duration = duration;
        this.maxCount = count;
        this.frames = frames;
        this.createAnimationBuffers();
        this.reset();
        if (this.eventListener != null && this.animated) {
            this.eventListener.animationFinished(this);
        }
        this.start();
    }

    public static class Frame {
        private int tileX = 0;
        private int tileY = 0;
        private long duration = 0L;

        public Frame(int x, int y) {
            this.tileX = x;
            this.tileY = y;
        }

        public Frame(int x, int y, long duration) {
            this.tileX = x;
            this.tileY = y;
            this.duration = duration;
        }

        public int getX() {
            return this.tileX;
        }

        public int getY() {
            return this.tileY;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

