/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.sprite;

import android.content.Context;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Toast;
import com.e3roid.E3Activity;
import com.e3roid.E3Scene;
import com.e3roid.drawable.Sprite;
import com.e3roid.drawable.texture.BitmapTexture;
import com.e3roid.event.SceneOnKeyListener;
import com.e3roid.event.TextInputListener;
import javax.microedition.khronos.opengles.GL10;
import org.connectbot.TerminalContainer;
import org.connectbot.service.TerminalBridge;

public class TerminalSprite
extends Sprite
implements TerminalContainer,
SceneOnKeyListener,
TextInputListener {
    private BitmapTexture texture;
    private TerminalBridge bridge;
    private E3Activity context;
    private Toast notification = null;
    private String lastNotification = null;
    private volatile boolean notifications = true;

    public TerminalSprite(TerminalBridge bridge, E3Activity context) {
        this(0, 0, context.getWidth(), context.getHeight(), bridge, context);
    }

    public TerminalSprite(int x, int y, int width, int height, TerminalBridge bridge, E3Activity context) {
        this.bridge = bridge;
        this.context = context;
        this.setPosition(x, y);
        this.setSize(width, height);
        bridge.parentChanged(this);
        this.texture = new BitmapTexture(bridge.getBitmap(), this.getWidth(), this.getHeight(), (Context)context);
        this.texture.recycleBitmap(false);
        this.createTexture();
        this.createBuffers();
    }

    public void setFgColor(int color) {
        this.bridge.setFgColor(color);
    }

    public void setBgColor(int color) {
        this.bridge.setBgColor(color);
    }

    public void setFontSize(int size) {
        this.bridge.setFontSize(size);
    }

    public void setEncoding(String encoding) {
        this.bridge.setCharset(encoding);
    }

    @Override
    public void onDraw(GL10 gl) {
        if (this.bridge.getBitmap() != null && this.bridge.onDraw()) {
            this.createTexture();
            this.texture.loadTexture(gl, true);
        }
        super.onDraw(gl);
    }

    protected void createTexture() {
        this.texture.setBitmap(this.bridge.getBitmap());
        this.updateTexture(this.texture);
    }

    @Override
    public void onDispose() {
        this.bridge.dispatchDisconnect(true);
        this.bridge.parentDestroyed();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void notifyUser(String message) {
        if (!this.notifications) {
            return;
        }
        if (this.notification != null) {
            if (this.lastNotification != null && this.lastNotification.equals(message)) {
                return;
            }
            this.notification.setText((CharSequence)message);
            this.notification.show();
        } else {
            this.notification = Toast.makeText((Context)this.context, (CharSequence)message, (int)0);
            this.notification.show();
        }
        this.lastNotification = message;
    }

    @Override
    public void postInvalidate() {
    }

    @Override
    public boolean onKeyDown(E3Scene scene, int keyCode, KeyEvent event) {
        return this.bridge.getKeyHandler().onKey((View)this.context.getView(), keyCode, event);
    }

    @Override
    public boolean onKeyUp(E3Scene scene, int keyCode, KeyEvent event) {
        return this.bridge.getKeyHandler().onKey((View)this.context.getView(), keyCode, event);
    }

    @Override
    public boolean onCommitText(CharSequence text, int newCursorPosition) {
        return this.bridge.getKeyHandler().onCommitText((View)this.context.getView(), text, newCursorPosition);
    }
}

