/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.sprite;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.e3roid.drawable.Sprite;
import com.e3roid.drawable.texture.BitmapTexture;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11;

public class TextSprite
extends Sprite {
    private final Context context;
    private Paint textPaint = new Paint();
    private Paint backPaint = new Paint();
    private Paint.FontMetrics fontMetrics;
    private Typeface typeFace = Typeface.DEFAULT;
    private int textSize;
    private boolean antiAlias = true;
    private int textColor = -16777216;
    private int backColor = 0;
    private int preferredWidth = 0;
    private String text;
    private boolean textChanged = false;
    private boolean sizeChanged = false;
    private static final int PADDING_LEFT = 5;
    private static final int PADDING_RIGHT = 5;
    private int paddingLeft;
    private int paddingRight;

    public TextSprite(String text, int textSize, Context context) {
        this(text, textSize, -16777216, 0, 0, Typeface.DEFAULT, context);
    }

    public TextSprite(String text, int textSize, int color, int backColor, Typeface typeface, Context context) {
        this(text, textSize, color, backColor, 0, typeface, context);
    }

    public TextSprite(String text, int textSize, int color, int backColor, int preferredWidth, Typeface typeface, Context context) {
        this.context = context;
        this.preferredWidth = preferredWidth;
        this.paddingLeft = 5;
        this.paddingRight = 5;
        this.setPosition(0, 0);
        this.setText(text);
        this.setTextSize(textSize);
        this.setColor(color);
        this.setBackColor(backColor);
        this.setTypeface(typeface);
        this.preparePaint();
        this.textChanged = false;
    }

    private void preparePaint() {
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTypeface(this.typeFace);
        this.textPaint.setTextSize((float)this.textSize);
        this.textPaint.setAntiAlias(this.antiAlias);
        this.backPaint.setColor(this.backColor);
        this.backPaint.setStyle(Paint.Style.FILL);
        this.fontMetrics = this.textPaint.getFontMetrics();
        this.setSize(this.getTextWidth(), this.getTextHeight());
    }

    public void createLabel() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.backPaint);
        canvas.drawText(this.text, (float)this.getPreferredPaddingLeft(), Math.abs(this.fontMetrics.ascent), this.textPaint);
        this.texture = new BitmapTexture(bitmap, this.getWidth(), this.getHeight(), this.context);
        this.texture.recycleBitmap(false);
        this.updateTexture(this.texture);
    }

    public int getTextWidth() {
        int width = this.measureTextWidthWithPadding();
        if (this.preferredWidth > width) {
            return this.preferredWidth;
        }
        return width;
    }

    protected int measureTextWidthWithPadding() {
        return this.measureTextWidth() + this.paddingLeft + this.paddingRight;
    }

    protected int measureTextWidth() {
        return (int)Math.ceil(this.textPaint.measureText(this.text));
    }

    private int getPreferredPaddingLeft() {
        int width = this.measureTextWidthWithPadding();
        if (this.preferredWidth < width) {
            return this.paddingLeft;
        }
        return (int)((float)(this.preferredWidth - this.measureTextWidth()) * 0.5f);
    }

    public int getTextHeight() {
        return (int)Math.ceil(Math.abs(this.fontMetrics.ascent) + Math.abs(this.fontMetrics.descent) + Math.abs(this.fontMetrics.leading));
    }

    @Override
    public void onLoadSurface(GL10 gl) {
        this.onLoadSurface(gl, false);
    }

    @Override
    public void onLoadSurface(GL10 gl, boolean force) {
        if (this.textChanged) {
            this.preparePaint();
        }
        this.createLabel();
        this.createBuffers();
        super.onLoadSurface(gl, force);
    }

    @Override
    public void onDraw(GL10 gl) {
        if (this.textChanged) {
            this.preparePaint();
            this.createLabel();
            this.texture.loadTexture(gl, false);
            if (this.sizeChanged) {
                this.createBuffers();
                this.loadVertexBuffer((GL11)gl);
                this.loadTextureBuffer((GL11)gl);
            }
            this.sizeChanged = false;
            this.textChanged = false;
        }
        super.onDraw(gl);
    }

    @Override
    public void onRemove() {
        ((BitmapTexture)this.texture).recycleBitmap();
        super.onRemove();
    }

    @Override
    public void onDispose() {
        super.onDispose();
    }

    public void reload() {
        this.reload(false);
    }

    public void reload(boolean resized) {
        this.sizeChanged = resized;
        this.textChanged = true;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.textChanged = true;
    }

    public void setTextSize(int size) {
        this.textSize = size;
        this.textChanged = true;
    }

    public void setAntiAlias(boolean enable) {
        this.antiAlias = enable;
        this.textChanged = true;
    }

    public void setColor(int textColor) {
        this.textColor = textColor;
        this.textChanged = true;
    }

    public void setBackColor(int backColor) {
        this.backColor = backColor;
        this.textChanged = true;
    }

    public void setTypeface(Typeface typeface) {
        this.typeFace = typeface;
        this.textChanged = true;
    }

    public void setPaddingLeft(int left) {
        this.paddingLeft = left;
        this.reload(true);
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingRight(int right) {
        this.paddingRight = right;
        this.reload(true);
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }
}

