/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.sprite;

import com.e3roid.drawable.Sprite;
import com.e3roid.drawable.texture.TiledTexture;
import com.e3roid.opengl.FastFloatBuffer;
import com.e3roid.opengl.GLHelper;
import com.e3roid.util.IntPair;
import java.util.HashMap;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11;

public class TiledSprite
extends Sprite {
    private final TiledTexture texture;
    private boolean tileIndexChanged = false;
    private int xindex = 0;
    private int yindex = 0;
    private HashMap<IntPair, FastFloatBuffer> bufferCache = new HashMap();
    private final int[] GENERATED_TILED_ID = new int[1];

    public TiledSprite(TiledTexture texture, int x, int y) {
        this(texture, x, y, 0, 0);
    }

    public TiledSprite(TiledTexture texture, int x, int y, int xindex, int yindex) {
        ((Sprite)this).texture = texture;
        this.texture = texture;
        this.setSize(texture.getTileWidth(), texture.getTileHeight());
        this.setPosition(x, y);
        this.setTile(xindex, yindex);
        this.useDefaultRotationAndScaleCenter();
        this.createBuffers();
    }

    public void setTile(int xindex, int yindex) {
        if (this.xindex != xindex || this.yindex != yindex) {
            this.tileIndexChanged = true;
        }
        this.xindex = xindex;
        this.yindex = yindex;
    }

    public int getTileIndexX() {
        return this.xindex;
    }

    public int getTileIndexY() {
        return this.yindex;
    }

    @Override
    public void onLoadSurface(GL10 _gl, boolean force) {
        if (!force && this.isLoaded()) {
            return;
        }
        super.callRootOnLoadSurface(_gl, force);
        GL11 gl = (GL11)_gl;
        if (force && this.texture.isLoaded()) {
            this.texture.unloadTexture((GL10)gl);
        }
        if (!this.texture.isLoaded()) {
            this.texture.loadTexture((GL10)gl);
        }
        if (force) {
            this.bufferCache.clear();
            this.tileIndexChanged = true;
        }
        if (this.useVBO) {
            gl.glGenBuffers(1, this.GENERATED_TEXTURE_BUFFER_ID, 0);
        }
        this.loadTextureBuffer(gl, this.coordBuffer);
    }

    @Override
    public void onDraw(GL10 _gl) {
        GL11 gl = (GL11)_gl;
        if (this.tileIndexChanged) {
            this.loadTextureBuffer(gl, this.reloadTile(gl));
            this.tileIndexChanged = false;
        }
        this.GENERATED_TEXTURE_BUFFER_ID[0] = this.coordBuffer.getBufferID();
        super.onDraw((GL10)gl);
    }

    public void onFasterDraw(GL10 _gl) {
        GL11 gl = (GL11)_gl;
        if (this.tileIndexChanged) {
            this.loadTextureBuffer(gl, this.reloadTile(gl));
            this.tileIndexChanged = false;
        }
        if (this.isRemoved() && this.isLoaded()) {
            this.unload((GL10)gl);
            return;
        }
        if (!this.isVisible() || this.isRemoved()) {
            return;
        }
        GLHelper.bindTexture(gl, this.texture.getTextureID());
        gl.glLoadIdentity();
        gl.glTranslatef(this.translateParams[0], this.translateParams[1], this.translateParams[2]);
        GLHelper.bindBuffer(gl, this.GENERATED_HARDWAREID[0]);
        GLHelper.vertexZeroPointer(gl);
        GLHelper.bindBuffer(gl, this.coordBuffer.getBufferID());
        GLHelper.texCoordZeroPointer(gl);
        GLHelper.bindElementBuffer(gl, this.GENERATED_HARDWAREID[1]);
        gl.glDrawElements(6, 4, 5123, 0);
    }

    @Override
    protected void loadTextureBuffer(GL11 gl, FastFloatBuffer coordBuffer) {
        if (!coordBuffer.isLoaded()) {
            GLHelper.bindBuffer(gl, coordBuffer.getBufferID());
            GLHelper.bufferFloatData(gl, coordBuffer.capacity(), coordBuffer, 35044);
            coordBuffer.setLoaded(true);
        }
        this.coordBuffer = coordBuffer;
    }

    public FastFloatBuffer reloadTile(GL11 gl) {
        this.texture.setTileIndex(this.xindex, this.yindex);
        IntPair key = new IntPair(this.xindex, this.yindex);
        if (this.bufferCache.containsKey(key)) {
            return this.bufferCache.get(key);
        }
        float[] coords = new float[]{this.texture.getCoordStartX(), this.texture.getCoordStartY(), this.texture.getCoordStartX(), this.texture.getCoordEndY(), this.texture.getCoordEndX(), this.texture.getCoordEndY(), this.texture.getCoordEndX(), this.texture.getCoordStartY()};
        FastFloatBuffer data = FastFloatBuffer.createBuffer(coords);
        data.setBufferID(this.generateTextureID(gl));
        this.bufferCache.put(key, data);
        return data;
    }

    protected int generateTextureID(GL11 gl) {
        gl.glGenBuffers(1, this.GENERATED_TILED_ID, 0);
        return this.GENERATED_TILED_ID[0];
    }
}

