/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.texture;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLUtils;
import com.e3roid.drawable.texture.Texture;
import com.e3roid.opengl.GLHelper;
import com.e3roid.opengl.TGA;
import com.e3roid.util.BitmapUtil;
import com.e3roid.util.Debug;
import com.e3roid.util.MathUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.microedition.khronos.opengles.GL10;

public class AssetTexture
extends Texture {
    public static String tgaExtension = ".tga";
    private final String assetName;
    private boolean useTGA = false;
    private boolean flipped = false;
    private boolean useFullpath = false;

    public AssetTexture(String name, Context context) {
        this(name, context, Texture.Option.DEFAULT);
    }

    public AssetTexture(String name, Context context, Texture.Option option) {
        super(context, option);
        this.assetName = name;
        if (name.startsWith("/")) {
            this.useFullpath = true;
        }
        if (name.toLowerCase().endsWith(tgaExtension)) {
            this.initializeTGA(name);
        } else {
            this.initializeBitmap(name);
        }
    }

    private void initializeBitmap(String assetName) {
        BitmapFactory.Options bitmapOptions;
        block14: {
            InputStream is = null;
            bitmapOptions = new BitmapFactory.Options();
            bitmapOptions.inJustDecodeBounds = true;
            try {
                try {
                    is = this.useFullpath ? new FileInputStream(assetName) : this.getContext().getAssets().open(assetName);
                    BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)bitmapOptions);
                }
                catch (Exception e) {
                    Debug.e("Failed to load Texture " + assetName, e);
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setSize(bitmapOptions.outWidth, bitmapOptions.outHeight);
        this.setGLSize(MathUtil.nextPowerOfTwo(this.getWidth()), MathUtil.nextPowerOfTwo(this.getHeight()));
    }

    private void initializeTGA(String assetName) {
        TGA.ImageTGA image;
        block15: {
            this.useTGA = true;
            this.flipped = true;
            image = null;
            InputStream is = null;
            try {
                try {
                    is = this.useFullpath ? new FileInputStream(assetName) : this.getContext().getAssets().open(assetName);
                    image = TGA.inJustDecodeBounds(is);
                }
                catch (Exception e) {
                    Debug.e("Failed to load TGA texture " + assetName, e);
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (image == null) {
            throw new IllegalArgumentException("Failed to load TGA texture: " + assetName);
        }
        this.setSize(image.width, image.height);
        this.setGLSize(MathUtil.nextPowerOfTwo(this.getWidth()), MathUtil.nextPowerOfTwo(this.getHeight()));
    }

    public AssetTexture(String name, int width, int height, Context context) {
        this(name, width, height, context, Texture.Option.DEFAULT);
    }

    public AssetTexture(String name, int width, int height, Context context, Texture.Option option) {
        super(width, height, context, option);
        this.assetName = name;
        if (name.toLowerCase().endsWith(tgaExtension)) {
            this.useTGA = true;
            this.flipped = true;
        }
    }

    @Override
    public void loadTexture(GL10 gl, boolean reload) {
        if (this.useTGA) {
            this.loadTGATexture(gl, reload);
        } else {
            super.loadTexture(gl, reload);
        }
    }

    private void loadTGATexture(GL10 gl, boolean reload) {
        TGA.ImageTGA image;
        block16: {
            image = null;
            InputStream is = null;
            try {
                try {
                    is = this.useFullpath ? new FileInputStream(this.assetName) : this.getContext().getAssets().open(this.assetName);
                    image = TGA.load(is);
                }
                catch (Exception e) {
                    Debug.e("Failed to load Texture " + this.assetName, e);
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (image == null) {
            throw new IllegalArgumentException("Failed to load TGA info: " + this.assetName);
        }
        if (!reload) {
            this.setTextureID(this.generateTextureID(gl));
        }
        gl.glBindTexture(3553, this.getTextureID());
        this.applyOptions(gl);
        int format = image.pixelDepth == 32 ? 6408 : 6407;
        Bitmap holder = null;
        holder = format == 6407 ? Bitmap.createBitmap((int)this.getGLWidth(), (int)this.getGLHeight(), (Bitmap.Config)Bitmap.Config.RGB_565) : Bitmap.createBitmap((int)this.getGLWidth(), (int)this.getGLHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)holder, (int)0);
        holder.recycle();
        gl.glTexSubImage2D(3553, 0, 0, 0, image.width, image.height, format, 5121, (Buffer)ByteBuffer.wrap(image.imageData));
        GLHelper.checkError(gl);
        this.setLoaded(true);
    }

    @Override
    public float getCoordStartY() {
        if (!this.flipped) {
            return super.getCoordStartY();
        }
        return super.getCoordEndY();
    }

    @Override
    public float getCoordEndY() {
        if (!this.flipped) {
            return super.getCoordEndY();
        }
        return super.getCoordStartY();
    }

    public String getName() {
        return this.assetName;
    }

    @Override
    protected Bitmap loadBitmap() {
        if (this.useTGA) {
            return null;
        }
        return BitmapUtil.getBitmapFromAsset(this.assetName, this.getContext());
    }

    @Override
    public String describe() {
        return "AssetTexture: " + this.assetName;
    }

    public void flip() {
        this.flipped = !this.flipped;
    }

    public boolean isFlipped() {
        return this.flipped;
    }
}

