/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.texture;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import com.e3roid.drawable.texture.Texture;

public class BitmapTexture
extends Texture {
    private Bitmap bitmap;

    public BitmapTexture(Bitmap bitmap, int width, int height, Context context) {
        this(bitmap, width, height, context, Texture.Option.DEFAULT);
    }

    public BitmapTexture(Bitmap bitmap, int width, int height, Context context, Texture.Option option) {
        super(width, height, context, option);
        this.bitmap = bitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public void recycleBitmap() {
        this.bitmap.recycle();
    }

    @Override
    protected Bitmap loadBitmap() {
        return this.bitmap;
    }

    @Override
    public String describe() {
        return "BitmapTexture: " + this.bitmap.toString();
    }

    public static BitmapTexture createTextureFromTile(Bitmap tile, int width, int height, Context context) {
        return BitmapTexture.createTextureFromTile(tile, width, height, TileOption.FILL, context);
    }

    public static BitmapTexture createTextureFromTile(Bitmap tile, int width, int height, TileOption option, Context context) {
        int tileWidth = tile.getWidth();
        int tileHeight = tile.getHeight();
        int xcount = width / tileWidth;
        int ycount = height / tileHeight;
        if (option == TileOption.FILL) {
            if (width % tileWidth != 0) {
                ++xcount;
            }
            if (height % tileHeight != 0) {
                ++ycount;
            }
        } else if (option == TileOption.STRETCH) {
            width = tileWidth * xcount;
            height = tileHeight * ycount;
        }
        Bitmap holder = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(holder);
        Rect src = new Rect(0, 0, tileWidth, tileHeight);
        int i = 0;
        while (i < xcount) {
            int j = 0;
            while (j < ycount) {
                int startX = i * tileWidth;
                int startY = j * tileHeight;
                Rect dst = new Rect(startX, startY, startX + tileWidth, startY + tileHeight);
                canvas.drawBitmap(tile, src, dst, null);
                ++j;
            }
            ++i;
        }
        return new BitmapTexture(holder, width, height, context);
    }

    public static enum TileOption {
        FILL,
        STRETCH,
        DEFAULT;

    }
}

