/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.texture;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLUtils;
import com.e3roid.opengl.GLHelper;
import com.e3roid.util.MathUtil;
import javax.microedition.khronos.opengles.GL10;

public abstract class Texture {
    private final Context context;
    private final int[] GENERATED_TEXTUREID = new int[1];
    private int width;
    private int height;
    private int glWidth;
    private int glHeight;
    private int textureID = -1;
    private Option option = Option.DEFAULT;
    private boolean loaded = false;
    private boolean reusable = false;
    private boolean recycleBitmap = true;

    public Texture(Context context) {
        this(context, Option.DEFAULT);
    }

    public Texture(Context context, Option option) {
        this.context = context;
        this.option = option;
    }

    public Texture(int width, int height, Context context) {
        this(width, height, context, Option.DEFAULT);
    }

    public Texture(int width, int height, Context context, Option option) {
        this.context = context;
        this.option = option;
        this.width = width;
        this.height = height;
        this.glWidth = MathUtil.nextPowerOfTwo(width);
        this.glHeight = MathUtil.nextPowerOfTwo(height);
    }

    protected abstract Bitmap loadBitmap();

    public abstract String describe();

    public void loadTexture(GL10 gl) {
        this.loadTexture(gl, false);
    }

    public void loadTexture(GL10 gl, boolean reload) {
        if (!reload) {
            this.textureID = this.generateTextureID(gl);
        }
        gl.glBindTexture(3553, this.textureID);
        this.applyOptions(gl);
        Bitmap holder = Bitmap.createBitmap((int)this.glWidth, (int)this.glHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)holder, (int)0);
        holder.recycle();
        Bitmap bitmap = this.loadBitmap();
        if (bitmap == null) {
            return;
        }
        try {
            GLHelper.texSubImage2D(gl, 3553, 0, 0, 0, bitmap, 6408, 5121);
            this.loaded = true;
        }
        finally {
            if (this.recycleBitmap) {
                bitmap.recycle();
            }
        }
    }

    public void unloadTexture(GL10 gl) {
        GLHelper.deleteTexture(gl, this.textureID);
        this.textureID = -1;
        this.loaded = false;
    }

    protected int generateTextureID(GL10 gl) {
        if (this.textureID > 0) {
            GLHelper.deleteTexture(gl, this.textureID);
            this.textureID = -1;
        }
        gl.glGenTextures(1, this.GENERATED_TEXTUREID, 0);
        return this.GENERATED_TEXTUREID[0];
    }

    protected void applyOptions(GL10 gl) {
        int minFilter = 9728;
        int magFilter = 9728;
        int wrapS = 33071;
        int wrapT = 33071;
        int texEnv = 8448;
        switch (this.option) {
            case DEFAULT: {
                break;
            }
            case BILINEAR: {
                minFilter = 9729;
                magFilter = 9729;
                wrapS = 33071;
                wrapT = 33071;
                texEnv = 7681;
                break;
            }
            case REPEATING: {
                minFilter = 9728;
                magFilter = 9728;
                wrapS = 10497;
                wrapT = 10497;
                texEnv = 7681;
                break;
            }
            case REPEATING_BILINEAR: {
                minFilter = 9729;
                magFilter = 9729;
                wrapS = 10497;
                wrapT = 10497;
                texEnv = 7681;
            }
        }
        gl.glTexParameterf(3553, 10241, (float)minFilter);
        gl.glTexParameterf(3553, 10240, (float)magFilter);
        gl.glTexParameterf(3553, 10242, (float)wrapS);
        gl.glTexParameterf(3553, 10243, (float)wrapT);
        gl.glTexEnvf(8960, 8704, (float)texEnv);
        GLHelper.checkError(gl);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    protected void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    protected void setGLSize(int w, int h) {
        this.glWidth = w;
        this.glHeight = h;
    }

    public void recycleBitmap(boolean recycle) {
        this.recycleBitmap = recycle;
    }

    public boolean isRecycleBitmap() {
        return this.recycleBitmap;
    }

    public void setReusable(boolean reusable) {
        this.reusable = reusable;
    }

    public boolean isReusable() {
        return this.reusable;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getGLWidth() {
        return this.glWidth;
    }

    public int getGLHeight() {
        return this.glHeight;
    }

    public float getCoordStartX() {
        return 0.0f;
    }

    public float getCoordStartY() {
        return 0.0f;
    }

    public float getCoordEndX() {
        return (float)this.width / (float)this.glWidth;
    }

    public float getCoordEndY() {
        return (float)this.height / (float)this.glHeight;
    }

    public int getTextureID() {
        return this.textureID;
    }

    protected void setTextureID(int id) {
        this.textureID = id;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    protected Context getContext() {
        return this.context;
    }

    public static enum Option {
        DEFAULT,
        BILINEAR,
        REPEATING,
        REPEATING_BILINEAR;

    }
}

