/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.texture;

import android.content.Context;
import com.e3roid.drawable.texture.AssetTexture;
import com.e3roid.drawable.texture.Texture;

public class TiledTexture
extends AssetTexture {
    private int xindex;
    private int yindex;
    private final int tileWidth;
    private final int tileHeight;
    private final int border;
    private final int margin;

    public TiledTexture(String name, int width, int height, Context context) {
        this(name, width, height, 0, 0, 0, 0, context, Texture.Option.DEFAULT);
    }

    public TiledTexture(String name, int width, int height, int xindex, int yindex, int border, Context context) {
        this(name, width, height, xindex, yindex, border, border, context, Texture.Option.DEFAULT);
    }

    public TiledTexture(String name, int width, int height, int xindex, int yindex, int border, int margin, Context context) {
        this(name, width, height, xindex, yindex, border, margin, context, Texture.Option.DEFAULT);
    }

    public TiledTexture(String name, int width, int height, int xindex, int yindex, int border, Context context, Texture.Option option) {
        this(name, width, height, xindex, yindex, border, border, context, option);
    }

    public TiledTexture(String name, int width, int height, int xindex, int yindex, int border, int margin, Context context, Texture.Option option) {
        super(name, context, option);
        this.xindex = xindex;
        this.yindex = yindex;
        this.tileWidth = width;
        this.tileHeight = height;
        this.border = border;
        this.margin = margin;
    }

    public void setTileIndex(int xindex, int yindex) {
        this.xindex = xindex;
        this.yindex = yindex;
    }

    @Override
    public float getCoordStartX() {
        float start = this.margin + (this.tileWidth + this.border) * this.xindex;
        return start / (float)this.getGLWidth();
    }

    @Override
    public float getCoordStartY() {
        float start = this.margin + (this.tileHeight + this.border) * this.yindex;
        if (this.isFlipped()) {
            start = (float)this.getHeight() - start;
        }
        return start / (float)this.getGLHeight();
    }

    @Override
    public float getCoordEndX() {
        float start = this.margin + (this.tileWidth + this.border) * this.xindex + this.tileWidth;
        return start / (float)this.getGLWidth();
    }

    @Override
    public float getCoordEndY() {
        float start = this.margin + (this.tileHeight + this.border) * this.yindex + this.tileHeight;
        if (this.isFlipped()) {
            start = (float)this.getHeight() - start;
        }
        return start / (float)this.getGLHeight();
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileIndexX() {
        return this.xindex;
    }

    public int getTileIndexY() {
        return this.yindex;
    }

    public int getColumnCount() {
        return this.getWidth() / (this.tileWidth + this.border);
    }

    public int getRowCount() {
        return this.getHeight() / (this.tileHeight + this.border);
    }

    @Override
    public String describe() {
        return "TiledTexture: " + this.getName();
    }
}

