/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.tmx;

import android.graphics.Rect;
import com.e3roid.E3Engine;
import com.e3roid.drawable.Drawable;
import com.e3roid.drawable.Shape;
import com.e3roid.drawable.sprite.TiledSprite;
import com.e3roid.drawable.tmx.TMXTile;
import com.e3roid.drawable.tmx.TMXTileSet;
import com.e3roid.drawable.tmx.TMXTiledMap;
import com.e3roid.opengl.GLHelper;
import com.e3roid.util.Base64InputStream;
import com.e3roid.util.Debug;
import com.e3roid.util.SAXUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import javax.microedition.khronos.opengles.GL10;
import org.xml.sax.Attributes;

public class TMXLayer
implements Drawable {
    private final String name;
    private final int columns;
    private final int rows;
    private final TMXTiledMap tiledMap;
    private final TMXTile[][] tiles;
    private E3Engine engine;
    private int tileCount = 0;
    private boolean removed = false;
    private boolean useVBO = true;
    private boolean useLoop = false;
    private boolean stopOnTheEdge = true;
    private int x = 0;
    private int y = 0;
    private int width;
    private int height;
    private int sceneWidth;
    private int sceneHeight;
    private TMXTile tileToDraw;
    private TiledSprite spriteToDraw;
    private ArrayList<Shape> children = new ArrayList();

    public TMXLayer(TMXTiledMap tiledMap, Attributes atts) {
        this.tiledMap = tiledMap;
        this.name = SAXUtil.getString(atts, "name");
        this.columns = SAXUtil.getInt(atts, "width");
        this.rows = SAXUtil.getInt(atts, "height");
        this.tiles = new TMXTile[this.rows][this.columns];
    }

    public void addChild(Shape shape) {
        this.children.add(shape);
    }

    public void removeChild(Shape shape) {
        this.children.remove(shape);
    }

    public int setX(int x) {
        if (!this.useLoop && this.stopOnTheEdge) {
            if (x < 0) {
                x = 0;
            }
            if (x > this.getMaxX()) {
                x = this.getMaxX();
            }
        }
        if (x % this.width == 0) {
            x = 0;
        }
        this.x = x;
        return this.x;
    }

    public int setY(int y) {
        if (!this.useLoop && this.stopOnTheEdge) {
            if (y < 0) {
                y = 0;
            }
            if (y > this.getMaxY()) {
                y = this.getMaxY();
            }
        }
        if (y % this.height == 0) {
            y = 0;
        }
        this.y = y;
        return y;
    }

    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void scroll(int x, int y) {
        int relativeX = this.x - this.setX(x);
        int relativeY = this.y - this.setY(y);
        for (Shape child : this.children) {
            child.moveRelative(relativeX, relativeY);
        }
    }

    public void setSceneSize(int width, int height) {
        this.sceneWidth = width;
        this.sceneHeight = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColumnAtPosition(int x) {
        return (x %= this.width) / (this.width / this.columns);
    }

    public int getRowAtPosition(int y) {
        return (y %= this.height) / (this.height / this.rows);
    }

    public TMXTile getTileAt(int column, int row) {
        if (row >= this.tiles.length) {
            return null;
        }
        if (column >= this.tiles[row].length) {
            return null;
        }
        return this.tiles[row][column];
    }

    public TMXTile getTileFromPosition(int x, int y) {
        int column = this.getColumnAtPosition(x + this.x);
        int row = this.getRowAtPosition(y + this.y);
        return this.getTileAt(column, row);
    }

    public ArrayList<TMXTile> getTileFromRect(Rect rect) {
        return this.getTileFromRect(rect, 0, 0);
    }

    public ArrayList<TMXTile> getTileFromRect(Rect rect, int xstep, int ystep) {
        ArrayList<TMXTile> tiles = new ArrayList<TMXTile>();
        rect.left += xstep;
        rect.right += xstep;
        rect.top += ystep;
        rect.bottom += ystep;
        TMXTile leftTop = this.getTileFromPosition(rect.left, rect.top);
        TMXTile leftBottom = this.getTileFromPosition(rect.left, rect.bottom);
        TMXTile rightTop = this.getTileFromPosition(rect.right, rect.top);
        TMXTile rightBottom = this.getTileFromPosition(rect.right, rect.bottom);
        if (!TMXTile.isEmpty(leftTop)) {
            tiles.add(leftTop);
        }
        if (!TMXTile.isEmpty(leftBottom) && !tiles.contains(leftBottom)) {
            tiles.add(leftBottom);
        }
        if (!TMXTile.isEmpty(rightTop) && !tiles.contains(rightTop)) {
            tiles.add(rightTop);
        }
        if (!TMXTile.isEmpty(rightBottom) && !tiles.contains(rightBottom)) {
            tiles.add(rightBottom);
        }
        return tiles;
    }

    @Override
    public void onLoadSurface(GL10 gl) {
        this.onLoadSurface(gl, false);
    }

    @Override
    public void onLoadSurface(GL10 gl, boolean force) {
        ArrayList<TMXTileSet> tileSets = this.tiledMap.getTileSets();
        for (TMXTileSet tileSet : tileSets) {
            TiledSprite sprite = tileSet.getSprite();
            sprite.enableVBO(this.useVBO);
            sprite.onLoadEngine(this.engine);
            sprite.onLoadSurface(gl, force);
        }
    }

    @Override
    public void onDraw(GL10 gl) {
        int columnCount = (int)Math.ceil((double)this.sceneWidth / (double)this.tiledMap.getTileWidth());
        int rowCount = (int)Math.ceil((double)this.sceneHeight / (double)this.tiledMap.getTileHeight());
        int firstColumn = Math.max(0, Math.min(this.columns, this.x / this.tiledMap.getTileWidth()));
        int lastColumn = Math.min(firstColumn + columnCount + 1, this.columns);
        int firstRow = Math.max(0, Math.min(this.rows, this.y / this.tiledMap.getTileHeight()));
        int lastRow = Math.min(firstRow + rowCount + 1, this.rows);
        this.drawTile(firstColumn, lastColumn, firstRow, lastRow, gl);
        if (this.useLoop) {
            int spareColumn = columnCount - (lastColumn - firstColumn);
            int spareRow = rowCount - (lastRow - firstRow);
            if (spareColumn >= 0 || spareRow >= 0) {
                firstColumn = 0;
                firstRow = 0;
                lastColumn = spareColumn <= 0 ? columnCount : spareColumn + 1;
                lastRow = spareRow <= 0 ? rowCount : spareRow + 1;
                this.drawTile(firstColumn, lastColumn, firstRow, lastRow, gl);
            }
        }
    }

    private void drawTile(int firstColumn, int lastColumn, int firstRow, int lastRow, GL10 gl) {
        GLHelper.resetCurrentTextureID();
        int i = firstRow;
        while (i < lastRow) {
            int j = firstColumn;
            while (j < lastColumn) {
                if (this.removed) break;
                this.tileToDraw = this.tiles[i][j];
                if (!TMXTile.isEmpty(this.tileToDraw)) {
                    this.spriteToDraw = this.tiledMap.getSpriteByGID(this.tileToDraw.getGID());
                    if (this.spriteToDraw != null) {
                        int sceneX = j * this.spriteToDraw.getWidth() - this.x;
                        int sceneY = i * this.spriteToDraw.getHeight() - this.y;
                        if (this.useLoop) {
                            int shownWidth = this.width - this.x;
                            int shownHeight = this.height - this.y;
                            int nextX = sceneX + this.width;
                            int nextY = sceneY + this.height;
                            if (shownWidth < this.sceneWidth && nextX >= shownWidth && nextX < this.sceneWidth) {
                                sceneX = nextX;
                            }
                            if (shownHeight < this.sceneHeight && nextY >= shownHeight && nextY < this.sceneHeight) {
                                sceneY = nextY;
                            }
                        }
                        this.spriteToDraw.setTile(this.tileToDraw.getAtlasColumn(), this.tileToDraw.getAtlasRow());
                        this.spriteToDraw.move(sceneX, sceneY);
                        this.spriteToDraw.onFasterDraw(gl);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void extract(String data, String encoding, String compression) throws IOException {
        FilterInputStream dataIn = null;
        try {
            InputStream in = new ByteArrayInputStream(data.getBytes("UTF-8"));
            if (encoding != null && encoding.equals("base64")) {
                in = new Base64InputStream(in, 0);
            }
            if (compression != null) {
                if (compression.equals("gzip")) {
                    in = new GZIPInputStream(in);
                } else {
                    throw new IllegalArgumentException("compression '" + compression + "' is not supported.");
                }
            }
            dataIn = new DataInputStream(in);
            int expectedTileCount = this.columns * this.rows;
            while (this.tileCount < expectedTileCount) {
                this.addTile(this.readGID((DataInputStream)dataIn));
            }
        }
        finally {
            try {
                dataIn.close();
            }
            catch (IOException e) {
                Debug.e(e);
            }
        }
    }

    private void addTile(int gid) {
        int column = this.tileCount % this.columns;
        int row = this.tileCount / this.columns;
        if (gid == 0) {
            this.tiles[row][column] = TMXTile.getEmptyTile(column, row);
        } else {
            TiledSprite sprite = this.tiledMap.getSpriteByGID(gid);
            if (sprite == null) {
                return;
            }
            this.tiles[row][column] = new TMXTile(gid, column, row, sprite.getTileIndexX(), sprite.getTileIndexY(), sprite.getWidth(), sprite.getHeight());
            this.width = this.columns * sprite.getWidth();
            this.height = this.rows * sprite.getHeight();
        }
        ++this.tileCount;
    }

    private int readGID(DataInputStream dataIn) throws IOException {
        int lowestByte = dataIn.read();
        int secondLowestByte = dataIn.read();
        int secondHighestByte = dataIn.read();
        int highestByte = dataIn.read();
        if (lowestByte < 0 || secondLowestByte < 0 || secondHighestByte < 0 || highestByte < 0) {
            throw new IllegalArgumentException("Couldn't read gid from stream.");
        }
        return lowestByte | secondLowestByte << 8 | secondHighestByte << 16 | highestByte << 24;
    }

    public void setup(Attributes atts) {
        this.addTile(SAXUtil.getInt(atts, "gid"));
    }

    @Override
    public void onResume() {
        ArrayList<TMXTileSet> tileSets = this.tiledMap.getTileSets();
        for (TMXTileSet tileSet : tileSets) {
            TiledSprite sprite = tileSet.getSprite();
            sprite.onResume();
        }
    }

    @Override
    public void onPause() {
        ArrayList<TMXTileSet> tileSets = this.tiledMap.getTileSets();
        for (TMXTileSet tileSet : tileSets) {
            TiledSprite sprite = tileSet.getSprite();
            sprite.onPause();
        }
    }

    @Override
    public void onDispose() {
        ArrayList<TMXTileSet> tileSets = this.tiledMap.getTileSets();
        for (TMXTileSet tileSet : tileSets) {
            TiledSprite sprite = tileSet.getSprite();
            sprite.onDispose();
        }
        this.tiledMap.onDispose();
        this.removed = true;
    }

    @Override
    public void onRemove() {
        ArrayList<TMXTileSet> tileSets = this.tiledMap.getTileSets();
        for (TMXTileSet tileSet : tileSets) {
            TiledSprite sprite = tileSet.getSprite();
            sprite.onRemove();
        }
        this.tiledMap.onRemove();
        this.removed = true;
    }

    @Override
    public void onLoadEngine(E3Engine engine) {
        this.engine = engine;
        this.useVBO = engine.useVBO();
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public boolean contains(int x, int y) {
        return false;
    }

    public int getTileWidth() {
        return this.tiledMap.getTileWidth();
    }

    public int getTileHeight() {
        return this.tiledMap.getTileHeight();
    }

    public boolean useLoop() {
        return this.useLoop;
    }

    public void loop(boolean useLoop) {
        this.useLoop = useLoop;
    }

    public void stopOnTheEdge(boolean stop) {
        this.stopOnTheEdge = stop;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getSceneWidth() {
        return this.sceneWidth;
    }

    public int getSceneHeight() {
        return this.sceneHeight;
    }

    public int getMaxX() {
        return this.width - this.sceneWidth;
    }

    public int getMaxY() {
        return this.height - this.sceneHeight;
    }
}

