/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.tmx;

import android.graphics.Rect;

public class TMXTile {
    private int gid;
    private int atlasColumn;
    private int atlasRow;
    private final int column;
    private final int row;
    private final int width;
    private final int height;

    public TMXTile(int gid, int column, int row, int atlasColumn, int atlasRow, int width, int height) {
        this.gid = gid;
        this.column = column;
        this.row = row;
        this.atlasColumn = atlasColumn;
        this.atlasRow = atlasRow;
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static TMXTile getEmptyTile(int column, int row) {
        return new TMXTile(0, column, row, -1, -1, 0, 0);
    }

    public static boolean isEmpty(TMXTile tile) {
        if (tile == null) {
            return true;
        }
        return tile.getGID() == 0;
    }

    public int getGID() {
        return this.gid;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public int getAtlasColumn() {
        return this.atlasColumn;
    }

    public int getAtlasRow() {
        return this.atlasRow;
    }

    public Rect getRect() {
        int left = this.getColumn() * this.getWidth();
        int right = left + this.getWidth();
        int top = this.getRow() * this.getHeight();
        int bottom = top + this.getHeight();
        return new Rect(left, right, top, bottom);
    }

    public void setGID(int gid) {
        this.gid = gid;
    }

    public void setAtlas(int column, int row) {
        this.atlasColumn = column;
        this.atlasRow = row;
    }

    public void setEmpty() {
        this.gid = 0;
    }
}

