/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.tmx;

import android.content.Context;
import com.e3roid.drawable.sprite.TiledSprite;
import com.e3roid.drawable.texture.TiledTexture;
import com.e3roid.drawable.tmx.TMXProperty;
import com.e3roid.util.SAXUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.Attributes;

public class TMXTileSet {
    private static final String NAME = "name";
    private static final String TILE_WIDTH = "tilewidth";
    private static final String TILE_HEIGHT = "tileheight";
    private static final String SPACING = "spacing";
    private static final String MARGIN = "margin";
    private final int firstGID;
    private final String name;
    private final int tileWidth;
    private final int tileHeight;
    private final int spacing;
    private final int margin;
    private final Context context;
    private TiledSprite sprite;
    private TiledTexture texture;
    private String imageSource;
    private final HashMap<Integer, ArrayList<TMXProperty>> tileProperties = new HashMap();

    public TMXTileSet(int firstGID, Attributes atts, Context context) {
        this.firstGID = firstGID;
        this.name = SAXUtil.getString(atts, NAME);
        this.tileWidth = SAXUtil.getInt(atts, TILE_WIDTH);
        this.tileHeight = SAXUtil.getInt(atts, TILE_HEIGHT);
        this.spacing = SAXUtil.getInt(atts, SPACING, 0);
        this.margin = SAXUtil.getInt(atts, MARGIN, 0);
        this.context = context;
    }

    public void addTileProperty(int id, TMXProperty property) {
        int gid = this.firstGID + id;
        ArrayList<TMXProperty> properties = this.tileProperties.get(gid);
        if (properties == null) {
            properties = new ArrayList();
        }
        properties.add(property);
        this.tileProperties.put(gid, properties);
    }

    public ArrayList<TMXProperty> getTileProperty(int gid) {
        return this.tileProperties.get(gid);
    }

    public void setImageSource(String source) {
        this.imageSource = source;
    }

    public String getimageSource() {
        return this.imageSource;
    }

    public TiledSprite getSprite(int gid) {
        this.sprite = this.getSprite();
        int index = gid - this.firstGID;
        int column = index % this.getCount(this.texture.getWidth(), this.texture.getTileWidth(), this.spacing);
        int row = index / this.getCount(this.texture.getWidth(), this.texture.getTileWidth(), this.spacing);
        this.sprite.setTile(column, row);
        return this.sprite;
    }

    public TiledSprite getSprite() {
        if (this.texture == null || this.sprite == null) {
            this.texture = new TiledTexture(this.imageSource, this.tileWidth, this.tileHeight, 0, 0, this.spacing, this.margin, this.context);
            this.texture.setReusable(true);
            this.sprite = new TiledSprite(this.texture, 0, 0, 0, 0);
        }
        return this.sprite;
    }

    private int getCount(int total, int unit, int spacing) {
        return total / (unit + spacing);
    }

    public int getFirstGID() {
        return this.firstGID;
    }

    public String getName() {
        return this.name;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public int getMargin() {
        return this.margin;
    }
}

