/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.drawable.tmx;

import com.e3roid.drawable.sprite.TiledSprite;
import com.e3roid.drawable.tmx.TMXLayer;
import com.e3roid.drawable.tmx.TMXObjectGroup;
import com.e3roid.drawable.tmx.TMXProperty;
import com.e3roid.drawable.tmx.TMXTileSet;
import com.e3roid.util.Debug;
import com.e3roid.util.SAXUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.Attributes;

public class TMXTiledMap {
    private static final String ORIENTATION = "orientation";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String TILE_WIDTH = "tilewidth";
    private static final String TILE_HEIGHT = "tileheight";
    private final String orientation;
    private final int columns;
    private final int rows;
    private final int tileWidth;
    private final int tileHeight;
    private boolean removed = false;
    private ArrayList<TMXLayer> layers = new ArrayList();
    private ArrayList<TMXTileSet> tileSets = new ArrayList();
    private ArrayList<TMXObjectGroup> objectGroups = new ArrayList();
    private HashMap<Integer, Integer> tileSetPropertyCache = new HashMap();
    private HashMap<Integer, Integer> spriteCache = new HashMap();

    public TMXTiledMap(Attributes atts) {
        this.orientation = SAXUtil.getString(atts, ORIENTATION);
        this.columns = SAXUtil.getInt(atts, WIDTH);
        this.rows = SAXUtil.getInt(atts, HEIGHT);
        this.tileWidth = SAXUtil.getInt(atts, TILE_WIDTH);
        this.tileHeight = SAXUtil.getInt(atts, TILE_HEIGHT);
    }

    public String getOrientation() {
        return this.orientation;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public ArrayList<TMXLayer> getLayers() {
        return this.layers;
    }

    public void addTMXLayer(TMXLayer layer) {
        this.layers.add(layer);
    }

    public void removeTMXLayer(TMXLayer layer) {
        this.layers.remove(layer);
    }

    public ArrayList<TMXTileSet> getTileSets() {
        return this.tileSets;
    }

    public void addTileSet(TMXTileSet tileSet) {
        this.tileSets.add(tileSet);
    }

    public void removeTileSet(TMXTileSet tileSet) {
        this.tileSets.remove(tileSet);
    }

    public void addObjectGroup(TMXObjectGroup group) {
        this.objectGroups.add(group);
    }

    public ArrayList<TMXObjectGroup> getObjectGroups() {
        return this.objectGroups;
    }

    public ArrayList<TMXProperty> getTileProperties(int gid) {
        if (this.tileSetPropertyCache.containsKey(gid)) {
            int index = this.tileSetPropertyCache.get(gid);
            return this.tileSets.get(index).getTileProperty(gid);
        }
        int i = 0;
        while (i < this.tileSets.size()) {
            TMXTileSet tileSet = this.tileSets.get(i);
            ArrayList<TMXProperty> props = tileSet.getTileProperty(gid);
            if (props != null) {
                this.tileSetPropertyCache.put(gid, i);
                return props;
            }
            ++i;
        }
        return null;
    }

    public TiledSprite getSpriteByGID(int gid) {
        if (this.removed) {
            return null;
        }
        try {
            if (this.spriteCache.containsKey(gid)) {
                int index = this.spriteCache.get(gid);
                return this.tileSets.get(index).getSprite(gid);
            }
            int i = this.tileSets.size() - 1;
            while (i >= 0) {
                TMXTileSet tileSet = this.tileSets.get(i);
                if (gid >= tileSet.getFirstGID()) {
                    TiledSprite sprite = tileSet.getSprite(gid);
                    this.spriteCache.put(gid, i);
                    return sprite;
                }
                --i;
            }
        }
        catch (Exception e) {
            Debug.e(e);
        }
        return null;
    }

    public void onDispose() {
        this.removed = true;
    }

    public void onRemove() {
        this.removed = true;
        this.onDispose();
    }
}

