/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.opengl;

import android.opengl.GLU;
import android.os.SystemClock;
import com.e3roid.drawable.modifier.function.Linear;
import com.e3roid.drawable.modifier.function.Progressive;
import com.e3roid.opengl.GLHelper;
import javax.microedition.khronos.opengles.GL10;

public class Camera {
    private boolean usePerspective = false;
    private int width;
    private int height;
    private float eyeX = 0.0f;
    private float eyeY = 0.0f;
    private float eyeZ = 0.0f;
    private float centerX = 0.0f;
    private float centerY = 0.0f;
    private float centerZ = -1.0f;
    private boolean zooming = false;
    private int zoomFromWidth;
    private int zoomFromHeight;
    private int zoomCenterX;
    private int zoomCenterY;
    private float currentZoom = 1.0f;
    private float targetZoom = 1.0f;
    private long zoomLastTime = 0L;
    private long zoomDuration = 0L;
    private Progressive zoomFunction;

    public Camera() {
    }

    public Camera(int width, int height) {
        this.setView(width, height);
    }

    public void setView(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void reloadMatrix(GL10 gl) {
        GLHelper.switchToProjectionMatrix(gl, true);
        if (this.usePerspective) {
            float ratio = (float)this.width / (float)this.height;
            float zfar = Math.max(this.height, this.width);
            gl.glFrustumf(-ratio, ratio, 1.0f, -1.0f, 1.0f, zfar + zfar / 10.0f);
        } else {
            gl.glOrthof(0.0f, (float)this.width, (float)this.height, 0.0f, -1.0f, 1.0f);
        }
    }

    public void zoom(float zoomFactor, long duration, int centerX, int centerY) {
        this.zoom(zoomFactor, duration, centerX, centerY, Linear.getInstance());
    }

    public void zoom(float zoomFactor, long duration, int centerX, int centerY, Progressive zoomFunction) {
        this.zoomFunction = zoomFunction;
        this.targetZoom = zoomFactor;
        this.zoomCenterX = centerX;
        this.zoomCenterY = centerY;
        this.zoomDuration = duration;
        this.zoomLastTime = SystemClock.uptimeMillis();
        this.zoomFromWidth = this.width;
        this.zoomFromHeight = this.height;
        this.zooming = true;
    }

    public void switchToOrtho(GL10 gl) {
        gl.glOrthof(0.0f, (float)this.width, (float)this.height, 0.0f, -1.0f, 1.0f);
    }

    public void lookAtOrthoCenter(GL10 gl) {
        GLU.gluLookAt((GL10)gl, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    public void look(GL10 gl) {
        this.reloadMatrix(gl);
        if (this.zooming) {
            long elapsed = SystemClock.uptimeMillis() - this.zoomLastTime;
            if (elapsed <= this.zoomDuration) {
                this.currentZoom = (float)(1.0 + (double)this.zoomFunction.getProgress(elapsed, this.zoomDuration, 0.0f, 1.0f) * ((double)this.targetZoom - 1.0));
            } else {
                this.currentZoom = this.targetZoom;
                this.zooming = false;
            }
            this.setView((int)((float)this.zoomFromWidth / this.currentZoom), (int)((float)this.zoomFromHeight / this.currentZoom));
            float eyePointX = (float)this.zoomCenterX - (float)this.zoomFromWidth / this.currentZoom / 2.0f;
            float eyePointY = (float)this.zoomCenterY - (float)this.zoomFromHeight / this.currentZoom / 2.0f;
            this.eyeX = eyePointX;
            this.eyeY = eyePointY;
            this.centerX = eyePointX;
            this.centerY = eyePointY;
        }
        if (this.usePerspective) {
            this.lookPerspective(gl);
        } else {
            this.lookOrtho(gl);
        }
    }

    public void lookOrtho(GL10 gl) {
        GLU.gluLookAt((GL10)gl, (float)this.eyeX, (float)this.eyeY, (float)this.eyeZ, (float)this.centerX, (float)this.centerY, (float)this.centerZ, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    public void lookPerspective(GL10 gl) {
        GLU.gluLookAt((GL10)gl, (float)this.eyeX, (float)this.eyeY, (float)this.eyeZ, (float)this.centerX, (float)this.centerY, (float)this.centerZ, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    public void defaultLook() {
        if (this.usePerspective) {
            this.eyeX = (float)this.width * 0.5f;
            this.eyeY = this.height + this.height / 10;
            this.eyeZ = (float)this.height * 0.5f;
            this.centerX = (float)this.width * 0.5f;
            this.centerY = (float)this.height * 0.5f;
            this.centerZ = 0.0f;
        } else {
            this.eyeX = 0.0f;
            this.eyeY = 0.0f;
            this.eyeZ = 0.0f;
            this.centerX = 0.0f;
            this.centerY = 0.0f;
            this.centerZ = -1.0f;
        }
    }

    public void enablePerspective(boolean enable) {
        this.usePerspective = enable;
    }

    public boolean isPerspective() {
        return this.usePerspective;
    }

    public void moveEye(float x, float y, float z) {
        this.eyeX = x;
        this.eyeY = y;
        this.eyeZ = z;
    }

    public void moveCenter(float x, float y, float z) {
        this.centerX = x;
        this.centerY = y;
        this.centerZ = z;
    }

    public float getEyeX() {
        return this.eyeX;
    }

    public float getEyeY() {
        return this.eyeY;
    }

    public float getEyeZ() {
        return this.eyeZ;
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public float getCenterZ() {
        return this.centerZ;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

