/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.opengl;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class FastFloatBuffer {
    public ByteBuffer bytes;
    private FloatBuffer floats;
    private IntBuffer ints;
    private int bufferID = -1;
    private boolean loaded = false;
    private static SoftReference<int[]> intArray = new SoftReference<int[]>(new int[0]);

    public static FastFloatBuffer createBuffer(float[] data) {
        FastFloatBuffer buffer = new FastFloatBuffer(data.length);
        buffer.put(data);
        buffer.position(0);
        return buffer;
    }

    public FastFloatBuffer(int capacity) {
        this.bytes = ByteBuffer.allocateDirect(capacity * 4).order(ByteOrder.nativeOrder());
        this.floats = this.bytes.asFloatBuffer();
        this.ints = this.bytes.asIntBuffer();
    }

    public void flip() {
        this.bytes.flip();
        this.floats.flip();
        this.ints.flip();
    }

    public void put(float f) {
        this.bytes.position(this.bytes.position() + 4);
        this.floats.put(f);
        this.ints.position(this.ints.position() + 1);
    }

    public void put(float[] data) {
        int[] ia = intArray.get();
        if (ia == null || ia.length < data.length) {
            ia = new int[data.length];
            intArray = new SoftReference<int[]>(ia);
        }
        int i = 0;
        while (i < data.length) {
            ia[i] = Float.floatToRawIntBits(data[i]);
            ++i;
        }
        this.bytes.position(this.bytes.position() + 4 * data.length);
        this.floats.position(this.floats.position() + data.length);
        this.ints.put(ia, 0, data.length);
    }

    public void put(int[] data) {
        this.bytes.position(this.bytes.position() + 4 * data.length);
        this.floats.position(this.floats.position() + data.length);
        this.ints.put(data, 0, data.length);
    }

    public static int[] convert(float ... data) {
        int[] id = new int[data.length];
        int i = 0;
        while (i < data.length) {
            id[i] = Float.floatToRawIntBits(data[i]);
            ++i;
        }
        return id;
    }

    public void put(FastFloatBuffer b) {
        this.bytes.put(b.bytes);
        this.floats.position(this.bytes.position() >> 2);
        this.ints.position(this.bytes.position() >> 2);
    }

    public int capacity() {
        return this.floats.capacity();
    }

    public int position() {
        return this.floats.position();
    }

    public void position(int p) {
        this.bytes.position(4 * p);
        this.floats.position(p);
        this.ints.position(p);
    }

    public FloatBuffer slice() {
        return this.floats.slice();
    }

    public int remaining() {
        return this.floats.remaining();
    }

    public int limit() {
        return this.floats.limit();
    }

    public void clear() {
        this.bytes.clear();
        this.floats.clear();
        this.ints.clear();
    }

    public void setBufferID(int id) {
        this.bufferID = id;
    }

    public int getBufferID() {
        return this.bufferID;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }
}

