/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.opengl;

import android.graphics.Bitmap;
import android.opengl.GLU;
import android.opengl.GLUtils;
import com.e3roid.opengl.FastFloatBuffer;
import com.e3roid.util.Debug;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11;

public class GLHelper {
    private static final int[] BUFFER_TO_DELETE = new int[1];
    private static final int[] TEXTURE_TO_DELETE = new int[1];
    private static int currentBufferID = -1;
    private static int currentMatrix = -1;
    private static int currentElementBufferID = -1;
    private static int currentTextureID = -1;
    private static FastFloatBuffer currentTextureBuffer = null;
    private static FastFloatBuffer currentVertexBuffer = null;
    private static int srcBlendMode = -1;
    private static int dstBlendMode = -1;
    private static boolean useLighting = false;
    private static boolean useDither = false;
    private static boolean useDepthTest = false;
    private static boolean useMultiSample = false;
    private static boolean useBlend = false;
    private static boolean useCulling = false;
    private static boolean useColorArray = false;
    private static boolean useTextures = false;
    private static boolean useVertexArray = false;
    private static boolean useTexCoordArray = false;
    private static boolean logGLError = false;
    private static float colorRed = -1.0f;
    private static float colorGreen = -1.0f;
    private static float colorBlue = -1.0f;
    private static float colorAlpha = -1.0f;
    private static float clearColorRed = -1.0f;
    private static float clearColorGreen = -1.0f;
    private static float clearColorBlue = -1.0f;
    private static float clearColorAlpha = -1.0f;
    private static float lineWidth = 1.0f;
    private static final boolean USE_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;

    public static void reset(GL10 gl) {
        GLHelper.BUFFER_TO_DELETE[0] = -1;
        GLHelper.TEXTURE_TO_DELETE[0] = -1;
        currentBufferID = -1;
        currentMatrix = -1;
        currentElementBufferID = -1;
        currentTextureBuffer = null;
        currentVertexBuffer = null;
        srcBlendMode = -1;
        dstBlendMode = -1;
        useLighting = false;
        useDither = false;
        useDepthTest = false;
        useMultiSample = false;
        useBlend = false;
        useCulling = false;
        useColorArray = false;
        useTextures = false;
        useVertexArray = false;
        useTexCoordArray = false;
        colorRed = -1.0f;
        colorGreen = -1.0f;
        colorBlue = -1.0f;
        colorAlpha = -1.0f;
        clearColorRed = -1.0f;
        clearColorGreen = -1.0f;
        clearColorBlue = -1.0f;
        clearColorAlpha = -1.0f;
        lineWidth = 1.0f;
    }

    public static void bindBuffer(GL11 gl, int bufferID) {
        if (currentBufferID != bufferID) {
            gl.glBindBuffer(34962, bufferID);
            currentBufferID = bufferID;
            GLHelper.checkError((GL10)gl);
        }
    }

    public static void bindTexture(GL11 gl, int textureID) {
        if (currentTextureID != textureID) {
            gl.glBindTexture(3553, textureID);
            currentTextureID = textureID;
            GLHelper.checkError((GL10)gl);
        }
    }

    public static void resetCurrentTextureID() {
        currentTextureID = -1;
    }

    public static void deleteBuffer(GL11 gl, int bufferID) {
        GLHelper.BUFFER_TO_DELETE[0] = bufferID;
        gl.glDeleteBuffers(1, BUFFER_TO_DELETE, 0);
        GLHelper.checkError((GL10)gl);
    }

    public static void deleteTexture(GL10 gl, int textureID) {
        GLHelper.TEXTURE_TO_DELETE[0] = textureID;
        gl.glDeleteTextures(1, TEXTURE_TO_DELETE, 0);
        GLHelper.checkError(gl);
    }

    public static void bindElementBuffer(GL11 gl, int elementID) {
        if (currentElementBufferID != elementID) {
            gl.glBindBuffer(34963, elementID);
            currentElementBufferID = elementID;
            GLHelper.checkError((GL10)gl);
        }
    }

    public static void deleteElementBuffer(GL11 gl, int elementID) {
        GLHelper.BUFFER_TO_DELETE[0] = elementID;
        gl.glDeleteBuffers(1, BUFFER_TO_DELETE, 0);
        GLHelper.checkError((GL10)gl);
    }

    public static void texCoordPointer(GL10 gl, FastFloatBuffer textureBuffer) {
        if (currentTextureBuffer != textureBuffer) {
            gl.glTexCoordPointer(2, 5126, 0, (Buffer)textureBuffer.bytes);
            currentTextureBuffer = textureBuffer;
            GLHelper.checkError(gl);
        }
    }

    public static void texCoordZeroPointer(GL11 gl) {
        gl.glTexCoordPointer(2, 5126, 0, 0);
        GLHelper.checkError((GL10)gl);
    }

    public static void vertexPointer(GL10 gl, FastFloatBuffer vertexBuffer) {
        if (currentVertexBuffer != vertexBuffer) {
            gl.glVertexPointer(3, 5126, 0, (Buffer)vertexBuffer.bytes);
            currentVertexBuffer = vertexBuffer;
            GLHelper.checkError(gl);
        }
    }

    public static void vertexZeroPointer(GL11 gl) {
        gl.glVertexPointer(3, 5126, 0, 0);
        GLHelper.checkError((GL10)gl);
    }

    public static void blendMode(GL10 gl, int srcBlendMode, int dstBlendMode) {
        if (GLHelper.srcBlendMode != srcBlendMode || GLHelper.dstBlendMode != dstBlendMode) {
            gl.glBlendFunc(srcBlendMode, dstBlendMode);
            GLHelper.srcBlendMode = srcBlendMode;
            GLHelper.dstBlendMode = dstBlendMode;
            GLHelper.checkError(gl);
        }
    }

    public static void switchToModelViewMatrix(GL10 gl) {
        GLHelper.switchToModelViewMatrix(gl, false);
        GLHelper.checkError(gl);
    }

    public static void switchToModelViewMatrix(GL10 gl, boolean loadIdentity) {
        if (currentMatrix != 5888) {
            gl.glMatrixMode(5888);
            currentMatrix = 5888;
            GLHelper.checkError(gl);
        }
        if (loadIdentity) {
            gl.glLoadIdentity();
            GLHelper.checkError(gl);
        }
    }

    public static void switchToProjectionMatrix(GL10 gl) {
        GLHelper.switchToProjectionMatrix(gl, false);
        GLHelper.checkError(gl);
    }

    public static void switchToProjectionMatrix(GL10 gl, boolean loadIdentity) {
        if (currentMatrix != 5889) {
            gl.glMatrixMode(5889);
            currentMatrix = 5889;
            GLHelper.checkError(gl);
        }
        if (loadIdentity) {
            gl.glLoadIdentity();
            GLHelper.checkError(gl);
        }
    }

    public static void hintPerspectiveCorrectionAndFastest(GL10 gl) {
        gl.glHint(3152, 4353);
        GLHelper.checkError(gl);
    }

    public static void hintPerspectiveCorrectionAndNicest(GL10 gl) {
        gl.glHint(3152, 4354);
        GLHelper.checkError(gl);
    }

    public static void bufferFloatData(GL11 gl, int size, FastFloatBuffer buffer, int usage) {
        gl.glBufferData(34962, 4 * size, (Buffer)buffer.bytes, usage);
        GLHelper.checkError((GL10)gl);
    }

    public static void bufferElementShortData(GL11 gl, int size, ShortBuffer buffer, int usage) {
        gl.glBufferData(34963, 2 * size, (Buffer)buffer, usage);
        GLHelper.checkError((GL10)gl);
    }

    public static void setColor(GL10 gl, float red, float green, float blue, float alpha) {
        if (red != colorRed || green != colorGreen || blue != colorBlue || alpha != colorAlpha) {
            gl.glColor4f(red, green, blue, alpha);
            colorRed = red;
            colorGreen = green;
            colorBlue = blue;
            colorAlpha = alpha;
            GLHelper.checkError(gl);
        }
    }

    public static void lineWidth(GL10 gl, float width) {
        if (lineWidth == width) {
            return;
        }
        gl.glLineWidth(width);
        lineWidth = width;
        GLHelper.checkError(gl);
    }

    public static void clearColor(GL10 gl, float red, float green, float blue, float alpha) {
        if (red != clearColorRed || green != clearColorGreen || blue != clearColorBlue || alpha != clearColorAlpha) {
            gl.glClearColor(red, green, blue, alpha);
            gl.glClear(16384);
            clearColorRed = red;
            clearColorGreen = green;
            clearColorBlue = blue;
            clearColorAlpha = alpha;
            GLHelper.checkError(gl);
        }
    }

    public static void texSubImage2D(GL10 gl, int target, int level, int xoffset, int yoffset, Bitmap bitmap, int format, int type) {
        GLHelper.texSubImage2D(gl, target, level, xoffset, yoffset, bitmap, format, type, true);
    }

    public static void texSubImage2D(GL10 gl, int target, int level, int xoffset, int yoffset, Bitmap bitmap, int format, int type, boolean usePreMultiplyAlpha) {
        if (usePreMultiplyAlpha) {
            GLUtils.texSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (Bitmap)bitmap, (int)format, (int)type);
        } else {
            int[] pixels = GLHelper.getPixels(bitmap);
            Buffer pixelBuffer = GLHelper.convertARGBtoRGBABuffer(pixels);
            gl.glTexSubImage2D(target, level, xoffset, yoffset, bitmap.getWidth(), bitmap.getHeight(), format, type, pixelBuffer);
        }
        GLHelper.checkError(gl);
    }

    public static void enableColorArray(GL10 gl, boolean enable) {
        if (enable == useColorArray) {
            return;
        }
        if (enable) {
            gl.glEnableClientState(32886);
        } else {
            gl.glDisableClientState(32886);
        }
        useColorArray = enable;
        GLHelper.checkError(gl);
    }

    public static void enableVertexArray(GL10 gl, boolean enable) {
        if (enable == useVertexArray) {
            return;
        }
        if (enable) {
            gl.glEnableClientState(32884);
        } else {
            gl.glDisableClientState(32884);
        }
        useVertexArray = enable;
        GLHelper.checkError(gl);
    }

    public static void enableTexCoordArray(GL10 gl, boolean enable) {
        if (enable == useTexCoordArray) {
            return;
        }
        if (enable) {
            gl.glEnableClientState(32888);
        } else {
            gl.glDisableClientState(32888);
        }
        useTexCoordArray = enable;
        GLHelper.checkError(gl);
    }

    public static void enableLighting(GL10 gl, boolean enable) {
        if (enable == useLighting) {
            return;
        }
        if (enable) {
            gl.glEnable(2896);
        } else {
            gl.glDisable(2896);
        }
        useLighting = enable;
        GLHelper.checkError(gl);
    }

    public static void enableBlend(GL10 gl, boolean enable) {
        if (enable == useBlend) {
            return;
        }
        if (enable) {
            gl.glEnable(3042);
        } else {
            gl.glDisable(3042);
        }
        useBlend = enable;
        GLHelper.checkError(gl);
    }

    public static void enableCulling(GL10 gl, boolean enable) {
        if (enable == useCulling) {
            return;
        }
        if (enable) {
            gl.glEnable(2884);
        } else {
            gl.glDisable(2884);
        }
        useCulling = enable;
        GLHelper.checkError(gl);
    }

    public static void enableTextures(GL10 gl, boolean enable) {
        if (enable == useTextures) {
            return;
        }
        if (enable) {
            gl.glEnable(3553);
        } else {
            gl.glDisable(3553);
        }
        useTextures = enable;
        GLHelper.checkError(gl);
    }

    public static void enableDither(GL10 gl, boolean enable) {
        if (enable == useDither) {
            return;
        }
        if (enable) {
            gl.glEnable(3024);
        } else {
            gl.glDisable(3024);
        }
        useDither = enable;
        GLHelper.checkError(gl);
    }

    public static void enableDepthTest(GL10 gl, boolean enable) {
        if (enable == useDepthTest) {
            return;
        }
        if (enable) {
            gl.glEnable(2929);
        } else {
            gl.glDisable(2929);
        }
        useDepthTest = enable;
        GLHelper.checkError(gl);
    }

    public static void enableMultiSample(GL10 gl, boolean enable) {
        if (enable == useMultiSample) {
            return;
        }
        if (enable) {
            gl.glEnable(32925);
        } else {
            gl.glDisable(32925);
        }
        useMultiSample = enable;
        GLHelper.checkError(gl);
    }

    public static void logGLError(boolean enable) {
        logGLError = enable;
    }

    public static void checkError(GL10 gl) {
        if (!logGLError) {
            return;
        }
        int error = gl.glGetError();
        if (error != 0) {
            String method = Thread.currentThread().getStackTrace()[3].getMethodName();
            Debug.d("Error: " + error + " (" + GLU.gluErrorString((int)error) + "): " + method);
        }
    }

    public static Buffer convertARGBtoRGBABuffer(int[] pixcels) {
        int i = pixcels.length - 1;
        while (i >= 0) {
            int pixel = pixcels[i];
            int red = pixel >> 16 & 0xFF;
            int green = pixel >> 8 & 0xFF;
            int blue = pixel & 0xFF;
            int alpha = pixel >> 24;
            pixcels[i] = USE_LITTLE_ENDIAN ? alpha << 24 | blue << 16 | green << 8 | red : red << 24 | green << 16 | blue << 8 | alpha;
            --i;
        }
        return IntBuffer.wrap(pixcels);
    }

    public static int[] getPixels(Bitmap bitmap) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int[] pixels = new int[w * h];
        bitmap.getPixels(pixels, 0, w, 0, 0, w, h);
        return pixels;
    }

    public static int[] getPixels(Bitmap bitmap, int xoffset, int yoffset, int width, int height) {
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, xoffset, yoffset, width, height);
        return pixels;
    }
}

