/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.opengl;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import com.e3roid.E3Engine;
import com.e3roid.event.TextInputListener;
import com.e3roid.opengl.GLSurfaceView;

public class RenderSurfaceView
extends GLSurfaceView {
    protected E3Engine engine;
    protected boolean useSoftInput = false;
    protected boolean hideSoftInputWhenDone = true;
    protected TextInputListener textInputListener;

    public RenderSurfaceView(Context context) {
        super(context);
    }

    public RenderSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setTextInputListener(TextInputListener textInputListener) {
        this.textInputListener = textInputListener;
    }

    public void setRenderer(E3Engine engine) {
        this.engine = engine;
        super.setRenderer(engine);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.engine == null) {
            throw new IllegalStateException("engine must be set by calling setRenderer()");
        }
        this.engine.onMeasure(this, widthMeasureSpec, heightMeasureSpec);
    }

    public void updateMeasuredDimension(int measuredWidth, int measuredHeight) {
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    public void enableSoftInput(boolean enable) {
        this.useSoftInput = enable;
        this.setFocusable(enable);
        this.setFocusableInTouchMode(enable);
    }

    public void hideSoftInputWhenDone(boolean hide) {
        this.hideSoftInputWhenDone = hide;
    }

    public void showSoftInput() {
        this.showSoftInput(1);
    }

    public void showSoftInput(int flags) {
        InputMethodManager manager = (InputMethodManager)this.getContext().getSystemService("input_method");
        manager.showSoftInput((View)this, flags);
    }

    public void hideSoftInput() {
        this.hideSoftInput(0);
    }

    public void hideSoftInput(int flags) {
        InputMethodManager im = (InputMethodManager)this.getContext().getSystemService("input_method");
        im.hideSoftInputFromWindow(this.getWindowToken(), flags);
    }

    public boolean isSoftInputActive() {
        InputMethodManager im = (InputMethodManager)this.getContext().getSystemService("input_method");
        return im.isActive((View)this);
    }

    public void toggleSoftInput(int showFlags, int hideFlags) {
        InputMethodManager im = (InputMethodManager)this.getContext().getSystemService("input_method");
        im.toggleSoftInput(showFlags, hideFlags);
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        if (!this.useSoftInput) {
            return super.onCreateInputConnection(outAttrs);
        }
        outAttrs.initialCapsMode = 0;
        outAttrs.initialSelStart = -1;
        outAttrs.initialSelEnd = -1;
        outAttrs.inputType = 65537;
        outAttrs.imeOptions = 0x10000006;
        return this.onLoadInputConnection();
    }

    protected InputConnection onLoadInputConnection() {
        return new TextInputConnection(this);
    }

    private class TextInputConnection
    extends BaseInputConnection {
        public TextInputConnection(RenderSurfaceView view) {
            super((View)view, false);
        }

        public boolean performEditorAction(int actionCode) {
            if (RenderSurfaceView.this.hideSoftInputWhenDone && actionCode == 6) {
                RenderSurfaceView.this.hideSoftInput();
            }
            return super.performEditorAction(actionCode);
        }

        public boolean commitText(CharSequence text, int newCursorPosition) {
            if (RenderSurfaceView.this.textInputListener != null && RenderSurfaceView.this.textInputListener.onCommitText(text, newCursorPosition)) {
                return true;
            }
            return super.commitText(text, newCursorPosition);
        }
    }
}

