/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.opengl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TGA {
    public static ImageTGA inJustDecodeBounds(InputStream f) throws IOException {
        return TGA.loadHeader(f, new ImageTGA());
    }

    private static ImageTGA loadHeader(InputStream f, ImageTGA info) throws IOException {
        int attr;
        f.read();
        f.read();
        info.type = (byte)f.read();
        f.read();
        f.read();
        f.read();
        f.read();
        f.read();
        f.read();
        f.read();
        f.read();
        f.read();
        info.width = f.read() & 0xFF | (f.read() & 0xFF) << 8;
        info.height = f.read() & 0xFF | (f.read() & 0xFF) << 8;
        info.pixelDepth = f.read() & 0xFF;
        info.attr = attr = f.read();
        info.flipped = 0;
        if ((attr & 0x20) != 0) {
            info.flipped = 1;
        }
        return info;
    }

    private static void loadImageData(InputStream f, ImageTGA info) throws IOException {
        int mode = info.pixelDepth / 8;
        int total = info.height * info.width * mode;
        f.read(info.imageData, 0, total);
        if (mode >= 3) {
            int i = 0;
            while (i < total) {
                byte aux = info.imageData[i];
                info.imageData[i] = info.imageData[i + 2];
                info.imageData[i + 2] = aux;
                i += mode;
            }
        }
    }

    private static void loadRLEImageData(InputStream f, ImageTGA info) throws IOException {
        int index = 0;
        byte[] aux = new byte[4];
        int runlength = 0;
        boolean skip = false;
        int flag = 0;
        int mode = info.pixelDepth / 8;
        int total = info.height * info.width;
        int i = 0;
        while (i < total) {
            if (runlength != 0) {
                --runlength;
                skip = flag != 0;
            } else {
                runlength = f.read();
                if (runlength == -1) {
                    return;
                }
                flag = runlength & 0x80;
                if (flag != 0) {
                    runlength -= 128;
                }
                skip = false;
            }
            if (!skip) {
                if (f.read(aux, 0, mode) != mode) {
                    return;
                }
                if (mode >= 3) {
                    byte tmp = aux[0];
                    aux[0] = aux[2];
                    aux[2] = tmp;
                }
            }
            TGA.memcpy(info.imageData, index, aux, 0, mode);
            index += mode;
            ++i;
        }
    }

    private static void flipImage(ImageTGA info) {
        int mode = info.pixelDepth / 8;
        int rowbytes = info.width * mode;
        byte[] row = new byte[rowbytes];
        int y = 0;
        while (y < info.height / 2) {
            TGA.memcpy(row, 0, info.imageData, y * rowbytes, rowbytes);
            TGA.memcpy(info.imageData, y * rowbytes, info.imageData, (info.height - (y + 1)) * rowbytes, rowbytes);
            TGA.memcpy(info.imageData, (info.height - (y + 1)) * rowbytes, row, 0, rowbytes);
            ++y;
        }
        info.flipped = 0;
    }

    private static void memcpy(byte[] dst, int to, byte[] src, int from, int len) {
        System.arraycopy(src, from, dst, to, len);
    }

    public static ImageTGA load(InputStream is) throws IOException {
        BufferedInputStream file;
        ImageTGA info = new ImageTGA();
        try {
            file = new BufferedInputStream(is);
        }
        catch (Exception e) {
            info.status = TGAError.TGA_ERROR_FILE_OPEN;
            return info;
        }
        try {
            TGA.loadHeader(file, info);
        }
        catch (Exception e) {
            info.status = TGAError.TGA_ERROR_READING_FILE;
            file.close();
            return info;
        }
        if (info.type == 1) {
            info.status = TGAError.TGA_ERROR_INDEXED_COLOR;
            file.close();
            return info;
        }
        if (info.type != 2 && info.type != 3 && info.type != 10) {
            info.status = TGAError.TGA_ERROR_COMPRESSED_FILE;
            file.close();
            return info;
        }
        int mode = info.pixelDepth / 8;
        int total = info.height * info.width * mode;
        info.imageData = new byte[total];
        try {
            if (info.type == 10) {
                TGA.loadRLEImageData(file, info);
            } else {
                TGA.loadImageData(file, info);
            }
        }
        catch (Exception e) {
            info.status = TGAError.TGA_ERROR_READING_FILE;
            file.close();
            return info;
        }
        file.close();
        info.status = TGAError.TGA_OK;
        if (info.flipped != 0) {
            TGA.flipImage(info);
            if (info.flipped != 0) {
                info.status = TGAError.TGA_ERROR_MEMORY;
            }
        }
        return info;
    }

    public static void RGBtogreyscale(ImageTGA info) {
        if (info.pixelDepth == 8) {
            return;
        }
        int mode = info.pixelDepth / 8;
        byte[] newImageData = new byte[info.height * info.width];
        int i = 0;
        int j = 0;
        while (j < info.width * info.height) {
            newImageData[j] = (byte)(0.3 * (double)info.imageData[i] + 0.59 * (double)info.imageData[i + 1] + 0.11 * (double)info.imageData[i + 2]);
            i += mode;
            ++j;
        }
        info.imageData = null;
        info.pixelDepth = 8;
        info.type = 3;
        info.imageData = newImageData;
    }

    public static void destroy(ImageTGA info) {
        if (info != null && info.imageData != null) {
            info.imageData = null;
        }
    }

    public static class ImageTGA {
        TGAError status;
        public int type;
        public int pixelDepth;
        public int width;
        public int height;
        public byte[] imageData;
        public int flipped;
        public int attr;
    }

    public static enum TGAError {
        TGA_OK,
        TGA_ERROR_FILE_OPEN,
        TGA_ERROR_READING_FILE,
        TGA_ERROR_INDEXED_COLOR,
        TGA_ERROR_MEMORY,
        TGA_ERROR_COMPRESSED_FILE;

    }
}

