/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.physics;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.e3roid.E3Scene;
import com.e3roid.drawable.Shape;
import com.e3roid.util.MathUtil;

public class PhysicsShape {
    protected Shape shape;
    protected Body body;
    protected float halfShapeWidth;
    protected float halfShapeHeight;
    protected float pixelToMeterRatio = 32.0f;
    protected boolean updatePosition = true;
    protected boolean updateRotation = true;

    public PhysicsShape(Shape shape, Body body) {
        this.shape = shape;
        this.body = body;
        float[] halfCoord = shape.getLocalCenterCoordinates();
        this.halfShapeWidth = halfCoord[0];
        this.halfShapeHeight = halfCoord[1];
    }

    public void setPixelToMeterRatio(float ratio) {
        this.pixelToMeterRatio = ratio;
    }

    public void onUpdate(E3Scene scene, long elapsedMsec) {
        if (this.updatePosition) {
            Vector2 position = this.body.getPosition();
            this.shape.move((int)(position.x * this.pixelToMeterRatio - this.halfShapeWidth), (int)(position.y * this.pixelToMeterRatio - this.halfShapeHeight));
        }
        if (this.updateRotation) {
            float angle = this.body.getAngle();
            this.shape.rotate(MathUtil.radToDeg(angle));
        }
    }

    public Body getBody() {
        return this.body;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void enableUpdatePosition(boolean enable) {
        this.updatePosition = enable;
    }

    public void enableUpdateRotation(boolean enable) {
        this.updateRotation = enable;
    }
}

