/*
 * Decompiled with CFR 0.152.
 */
package com.e3roid.physics;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.World;
import com.e3roid.E3Scene;
import com.e3roid.drawable.Shape;
import com.e3roid.event.SceneUpdateListener;
import com.e3roid.physics.PhysicsShape;
import java.util.ArrayList;

public class PhysicsWorld
implements SceneUpdateListener {
    protected World world;
    protected ArrayList<PhysicsShape> shapes = new ArrayList();
    public static final int VELOCITY_ITERATIONS_DEFAULT = 8;
    public static final int POSITION_ITERATIONS_DEFAULT = 8;
    public static final float PIXEL_TO_METER_RATIO_DEFAULT = 32.0f;
    protected int velocityIters = 8;
    protected int positionIters = 8;

    public PhysicsWorld(Vector2 gravity, boolean allowSleep) {
        this(gravity, allowSleep, 8, 8);
    }

    public PhysicsWorld(Vector2 gravity, boolean allowSleep, int velocityIterations, int positionIterations) {
        this.world = new World(gravity, allowSleep);
        this.velocityIters = velocityIterations;
        this.positionIters = positionIterations;
    }

    @Override
    public void onUpdateScene(E3Scene scene, long elapsedMsec) {
        this.world.step(this.msec2sec(elapsedMsec), this.velocityIters, this.positionIters);
        for (PhysicsShape shape : this.shapes) {
            shape.onUpdate(scene, elapsedMsec);
        }
    }

    private float msec2sec(long msec) {
        return (float)msec / 1000.0f;
    }

    public void addShape(PhysicsShape shape) {
        this.shapes.add(shape);
    }

    public void removeShape(PhysicsShape shape) {
        this.destroyBody(shape.getBody());
        this.shapes.remove(shape);
    }

    public void removeShape(Shape shape) {
        PhysicsShape pShape = this.findShape(shape);
        if (pShape == null) {
            return;
        }
        this.removeShape(pShape);
    }

    public PhysicsShape findShape(Shape shape) {
        for (PhysicsShape pShape : this.shapes) {
            if (pShape.getShape() != shape) continue;
            return pShape;
        }
        return null;
    }

    public void setGravity(Vector2 gravity) {
        this.world.setGravity(gravity);
    }

    public Body createBody(BodyDef pDef) {
        return this.world.createBody(pDef);
    }

    public Joint createJoint(JointDef pDef) {
        return this.world.createJoint(pDef);
    }

    public void destroyBody(Body pBody) {
        this.world.destroyBody(pBody);
    }

    public void destroyJoint(Joint pJoint) {
        this.world.destroyJoint(pJoint);
    }

    public void dispose() {
        this.world.dispose();
    }

    public World getWorld() {
        return this.world;
    }

    public int getPositionIterations() {
        return this.positionIters;
    }

    public void setPositionIterations(int positionIterations) {
        this.positionIters = positionIterations;
    }

    public int getVelocityIterations() {
        return this.velocityIters;
    }

    public void setVelocityIterations(int velocityIterations) {
        this.velocityIters = velocityIterations;
    }
}

